/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.OrgControlEnum;
import org.apache.commons.collections.CollectionUtils;

public class BodySystemOrgControlFieldUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(BodySystemOrgControlFieldUpgradeServiceImpl.class);

    @Override
    public void updateData() {
        logger.info("[BodySystemOrgControlFieldUpgradeServiceImpl] >>>> \u4f53\u7cfb-\u7f16\u62a5\u7ec4\u7ec7\u63a7\u5236\u5b57\u6bb5\u5347\u7ea7... ");
        String prop = String.join((CharSequence)",", "number", "id", "orgcontrol");
        String memberProp = String.join((CharSequence)",", "number", "id", "level", "isleaf");
        DynamicObject[] systemDOList = TmcDataServiceHelper.load((String)"fpm_bodysysmanage", (String)prop, null);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        try (TXHandle tx = TX.requiresNew();){
            try {
                for (DynamicObject system : systemDOList) {
                    int count;
                    List unLeafOrgMemberIds;
                    int count2;
                    if (!StringUtils.isEmpty((String)system.getString("orgcontrol"))) {
                        logger.info("[BodySystemOrgControlFieldUpgradeServiceImpl] >>>> \u5f53\u524d\u4f53\u7cfb\u5df2\u5b58\u5728\u6570\u636e\uff0c\u65e0\u9700\u5347\u7ea7 ");
                        continue;
                    }
                    long systemId = system.getLong("id");
                    DynamicObject[] orgMembers = TmcDataServiceHelper.load((String)"fpm_member", (String)memberProp, (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)systemId), new QFilter("dimtype", "=", (Object)DimsionEnums.ORG.getNumber())});
                    if (orgMembers == null || orgMembers.length == 0) continue;
                    OrgControlEnum finalEnum = null;
                    OrgControlEnum leafControl = null;
                    OrgControlEnum unLeafControl = null;
                    List leafOrgMemberIds = Arrays.stream(orgMembers).filter(item -> item.getBoolean("isleaf")).map(item -> item.getLong("id")).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(leafOrgMemberIds) && (count2 = TmcDataServiceHelper.count((String)"fpm_report", (QFilter[])new QFilter[]{new QFilter("reportorg", "in", leafOrgMemberIds), new QFilter("reportplantype", "=", (Object)ReportPlanType.REPORTPLAN.getNumber())})) > 0) {
                        leafControl = OrgControlEnum.LAST_STAGE;
                    }
                    if (CollectionUtils.isNotEmpty(unLeafOrgMemberIds = Arrays.stream(orgMembers).filter(item -> !item.getBoolean("isleaf")).map(item -> item.getLong("id")).collect(Collectors.toList())) && (count = TmcDataServiceHelper.count((String)"fpm_report", (QFilter[])new QFilter[]{new QFilter("reportorg", "in", unLeafOrgMemberIds), new QFilter("reportplantype", "=", (Object)ReportPlanType.REPORTPLAN.getNumber())})) > 0) {
                        unLeafControl = OrgControlEnum.MID_STAGE;
                    }
                    finalEnum = leafControl == null && unLeafControl == null ? OrgControlEnum.LAST_STAGE : (leafControl != null && unLeafControl == null ? OrgControlEnum.LAST_STAGE : (leafControl == null ? OrgControlEnum.MID_STAGE : OrgControlEnum.ALL_STAGE));
                    system.set("orgcontrol", (Object)finalEnum.getCode());
                    dynamicObjects.add(system);
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
            }
            catch (Throwable e) {
                logger.error("[MemberAggFieldUpgradeServiceImpl] \u5347\u7ea7\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
                tx.markRollback();
            }
        }
        logger.info("[BodySystemOrgControlFieldUpgradeServiceImpl] >>>> \u4f53\u7cfb-\u7f16\u62a5\u7ec4\u7ec7\u63a7\u5236\u5b57\u6bb5\u5347\u7ea7\u7ed3\u675f... ");
    }
}

