/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.context.ControlBotpUpperHolder;
import kd.tmc.fpm.business.dataproc.exception.UpdateException;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.SyncShrekReportDataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.ControlCoefficientInfo;
import kd.tmc.fpm.business.domain.model.control.ControlRequestUpdateInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.ControlUpdateInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.control.WaitConsumeInfo;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.helper.ReportDataControlCoefficientHelper;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.service.IControlExecuteManager;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.IControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.IControlTraceService;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.control.factory.ControlStrategyFactory;
import kd.tmc.fpm.business.mvc.service.control.serial.ControlUpdateSerialManager;
import kd.tmc.fpm.business.mvc.service.dto.ControlExcuteServiceLogParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.ControlParamResultDTO;
import kd.tmc.fpm.business.mvc.service.impl.BizCurrencyFillBackPostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.ControlContextFillBackPostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.ControlExecuteParamPostProcessorImpl;
import kd.tmc.fpm.business.mvc.service.impl.ControlLocalMessageManager;
import kd.tmc.fpm.business.mvc.service.impl.ControlRequestUpdateRecordManager;
import kd.tmc.fpm.business.mvc.service.impl.ControlTimeCheckProcessor;
import kd.tmc.fpm.business.mvc.service.impl.ControlTraceFillBackProcessor;
import kd.tmc.fpm.business.mvc.service.impl.ControlTraceIdProcessPostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.MatchFieldRelateMergeKeyPostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.MultiSourceInfoPostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.RelateExecutePlanRecordManager;
import kd.tmc.fpm.business.mvc.service.impl.RelateReportDataDiffManager;
import kd.tmc.fpm.business.mvc.service.impl.ReportOrgEnableDatePostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.RequestIdTimeOutMakDeletePostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.RollBackRelateExecutePlanRecordManager;
import kd.tmc.fpm.business.mvc.service.impl.SubjectCheckPostProcessorImpl;
import kd.tmc.fpm.business.mvc.service.impl.ZeroFilterPostProcessor;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class ControlExecuteManagerImpl
implements IControlExecuteManager {
    private static final Log logger = LogFactory.getLog(ControlExecuteManagerImpl.class);
    private IControlRepository controlRepository = FpmServiceFactory.getBizService(IControlRepository.class);
    private IControlTraceService controlTraceService = FpmServiceFactory.getBizService(IControlTraceService.class);
    private IDataSaveService dataSaveService = new SyncShrekReportDataSaveServiceImpl(FpmServiceFactory.getBizService(IDataSaveService.class));
    private List<IControlExecuteParamPostProcessor> controlExecuteParamPostProcessorList = new ArrayList<IControlExecuteParamPostProcessor>(16);

    public ControlExecuteManagerImpl() {
        this.registerDefault();
    }

    @Override
    public ControlResult prepare(ControlContext controlContext, List<ControlExcuteServiceLogParamDTO> executeServiceLogParamDTOList) {
        return CommonUtils.printTrace(ControlExecuteManagerImpl.class.getName(), span -> {
            span.addTag("step 1 convertControlExecuteParam");
            logger.info("\u6267\u884c\u63a7\u5236\u53c2\u6570\u8f6c\u6362:{}\u3002\u3002\u3002\u3002\u3002", CommonUtils.getSubListForSize(executeServiceLogParamDTOList, 20));
            List<ControlExecuteParam> controlExecuteParamList = ConverterUtils.convertList(ControlExecuteParam.class, executeServiceLogParamDTOList);
            span.addTag("step 2 invokeControlParamProcessor");
            this.invokeControlParamProcessor(controlContext, controlExecuteParamList);
            logger.info("\u8bbe\u7f6e\u53c2\u6570\u5230\u63a7\u5236\u4e0a\u4e0b\u6587\u3002\u3002\u3002\u3002");
            controlContext.setControlExecuteParamList(controlExecuteParamList);
            if (controlContext.isEmpty()) {
                logger.info("\u6821\u9a8c\u5e76\u8fc7\u6ee4\u53c2\u6570\u540e\uff0c\u53c2\u6570\u4e3a\u7a7a\uff0c\u76f4\u63a5\u8fd4\u56de\u3002\u3002\u3002\u3002\u3002");
                return new ControlResult();
            }
            logger.info("\u6839\u636e\u63a7\u5236\u4e0a\u4e0b\u6587\u83b7\u53d6\u6267\u884c\u7684\u7b56\u7565\u5bf9\u8c61\u3002\u3002\u3002\u3002");
            IControlExecuteStrategy strategy = ControlStrategyFactory.getControlStrategy(controlContext);
            ControlResult controlResult = new ControlResult();
            try {
                span.addTag("step 6 beforeDoControl");
                logger.info("\u5f00\u59cb\u6267\u884cbeforeDoControl:{}\u3002\u3002\u3002\u3002\u3002", CommonUtils.getSubListForSize(controlExecuteParamList, 20));
                strategy.beforeDoControl();
                FpmOperateResult<ControlResult> operateResult = strategy.validate();
                controlResult = this.processResult(operateResult);
                if (controlResult.isFailed()) {
                    logger.info("\u6821\u9a8c\u5931\u8d25\uff0c{}", (Object)controlResult.getErrMsg());
                    ControlRequestUpdateRecordManager.deleteControlUpdateRecordInfoIfNeed(controlContext.getRequestId());
                    return controlResult;
                }
                span.addTag("step 13 handleRecord");
                logger.info("\u8c03\u7528handleRecord\u5904\u7406\u4e1a\u52a1{}\u3002\u3002\u3002\u3002", CommonUtils.getSubListForSize(controlExecuteParamList, 10));
                ControlUpdateInfo controlUpdateInfo = strategy.handleRecord();
                FpmOperateResult result = CommonUtils.processInTransactionRequiresNew(() -> {
                    span.addTag("step 14 batchUpdate");
                    logger.info("\u51c6\u5907\u6267\u884c\u6279\u91cf\u66f4\u65b0\uff1a{}", (Object)controlUpdateInfo);
                    this.batchUpdate(controlUpdateInfo, controlContext);
                    return FpmOperateResult.success();
                });
                FpmAssertUtil.isTrue((boolean)result.isSuccess(), (String)String.join((CharSequence)",", result.getMessageList()));
                for (PlanExecuteRecord planExecuteRecord : controlUpdateInfo.getSavePlanExecuteRecordList()) {
                    if (planExecuteRecord.getExecuteOpType() != controlContext.getPlanExecuteOpType()) continue;
                    controlResult.addSuccessExecuteRecordId(planExecuteRecord.getBillBizInfo().getBillId(), planExecuteRecord.getId());
                }
                return controlResult;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                ControlRequestUpdateRecordManager.deleteControlUpdateRecordInfoIfNeed(controlContext.getRequestId());
                controlResult.setErrMsg(e.getMessage());
                return controlResult;
            }
        });
    }

    private ControlResult processResult(FpmOperateResult<ControlResult> operateResult) {
        if (Objects.isNull(operateResult)) {
            return new ControlResult();
        }
        if (operateResult.isSuccess()) {
            return operateResult.getData();
        }
        ControlResult controlResult = new ControlResult();
        controlResult.setErrMsg(String.join((CharSequence)";", operateResult.getMessageList()));
        return controlResult;
    }

    private List<ReportData> getNeedUpdateReportDataList(ControlUpdateInfo controlUpdateInfo) {
        List<ControlAmountCache.AmountInfo> updateAmountInfoList = controlUpdateInfo.getUpdateAmountInfoList();
        Set reportDataIds = updateAmountInfoList.stream().map(ControlAmountCache.AmountInfo::getReportDataId).collect(Collectors.toSet());
        List<PlanExecuteRecord> savePlanExecuteRecordList = controlUpdateInfo.getSavePlanExecuteRecordList();
        Map reportDataMap = savePlanExecuteRecordList.stream().map(PlanExecuteRecord::getMatchedReportDataList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
        List<PlanExecuteRecord> updatePlanExecuteRecordList = controlUpdateInfo.getUpdatePlanExecuteRecordList();
        Map updateRecordReportDataMap = updatePlanExecuteRecordList.stream().map(PlanExecuteRecord::getMatchedReportDataList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
        reportDataMap.putAll(updateRecordReportDataMap);
        List<ReportData> reportDataList = reportDataMap.values().stream().filter(rd -> reportDataIds.contains(rd.getId())).collect(Collectors.toList());
        Set<Long> dataIds = reportDataMap.keySet();
        List notExistsIds = reportDataIds.stream().filter(dataId -> !dataIds.contains(dataId)).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(notExistsIds)) {
            List<ReportData> dataList = new ReportDataQueryService().queryReportData(t -> t.setIdList(notExistsIds));
            reportDataList.addAll(dataList);
        }
        return reportDataList;
    }

    private void batchUpdate(ControlUpdateInfo controlUpdateInfo, ControlContext controlContext) {
        if (controlUpdateInfo.isEmpty()) {
            controlContext.getControlRequestUpdateRecordManager().updateControlRequestToConsume();
            return;
        }
        List<PlanExecuteRecord> savePlanExecuteRecordList = controlUpdateInfo.getSavePlanExecuteRecordList();
        this.controlRepository.savePlanExecuteRecord(savePlanExecuteRecordList);
        List<PlanExecuteRecord> updatePlanExecuteRecordList = controlUpdateInfo.getUpdatePlanExecuteRecordList();
        try {
            this.dataSaveService.updateAndCheckResult(IDataSaveService.Constants.CONTROL_PLAN_EXECUTE_RECORD_UPDATE, updatePlanExecuteRecordList, (k, o) -> {
                o.add(CommonUtils.getBooleanStringValue(k.getDeleteStatus()));
                o.add(k.getExecuteStatus().getValue());
                o.add(k.getAclRemainAmt());
                o.add(k.getId());
                o.add(k.getOriginalExecuteStatus().getValue());
                o.add(CommonUtils.getBooleanStringValue(k.getOriginalDeleteStatus()));
            });
        }
        catch (UpdateException e) {
            logger.info("\u66f4\u65b0\u5931\u8d25\uff0csql:{},\u53c2\u6570\uff1a{},\u5f71\u54cd\u7684\u884c\u6570\uff1a{},\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{e.getSql(), Arrays.asList(e.getParams()), e.getUpdateCount(), e.getMessage(), e});
            PlanExecuteRecord planExecuteRecord = (PlanExecuteRecord)e.getObj();
            String errorMsg = this.getErrorMsg(Collections.singletonList(planExecuteRecord));
            throw new KDBizException(errorMsg);
        }
        this.dataSaveService.updateAndCheckResult(IDataSaveService.Constants.CONTROL_PLAN_EXECUTE_RECORD_E_UPDATE, updatePlanExecuteRecordList, (k, o) -> {
            o.add(k.getRelateRecordId());
            o.add(k.getOriginalRecordId());
            o.add(k.getId());
        });
        Map<Long, PlanExecuteRecord> allPlanExecuteMap = this.getAllPlanExecuteMap(controlContext, controlUpdateInfo);
        Map<String, List<Map.Entry<Long, AtomicReference<BigDecimal>>>> sqlMap = this.getSqlMap(allPlanExecuteMap, controlUpdateInfo);
        try {
            sqlMap.forEach((sql, releaseEntryList) -> this.dataSaveService.updateAndCheckResult(() -> sql, releaseEntryList, (k, o) -> {
                o.add(((AtomicReference)k.getValue()).get());
                o.add(k.getKey());
                o.add(((AtomicReference)k.getValue()).get());
            }));
        }
        catch (UpdateException e) {
            logger.info("\u66f4\u65b0\u5931\u8d25\uff0csql:{},\u53c2\u6570\uff1a{},\u5f71\u54cd\u7684\u884c\u6570\uff1a{},\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{e.getSql(), Arrays.asList(e.getParams()), e.getUpdateCount(), e.getMessage(), e});
            Map.Entry entry = (Map.Entry)e.getObj();
            PlanExecuteRecord planExecuteRecord = allPlanExecuteMap.get(entry.getKey());
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u8bb0\u5f55\uff1a\u3010%1$s\u3011\u6709\u5176\u4ed6\u7ebf\u7a0b\u6b63\u5728\u91ca\u653e\u989d\u5ea6\uff0c\u672c\u6b21\u91ca\u653e\uff1a\u3010%2$s\u3011\u5bfc\u81f4\u989d\u5ea6\u4e0d\u8db3\u3002\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ControlExecuteManagerImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), planExecuteRecord.getRecordNumber(), ((AtomicReference)entry.getValue()).get());
            throw new KDBizException(errorMsg);
        }
        List<ControlAmountCache.AmountInfo> updateAmountInfoList = this.mergeRelateDiffAmountInfo(controlUpdateInfo, controlContext.getRelateReportDataManager());
        this.updateControlUpdateInfo(updateAmountInfoList, controlContext);
        Function<Long, ControlCoefficientInfo> coefficientFunction = ReportDataControlCoefficientHelper.getInstance(controlContext).getReportDataControlCoefficientFunction();
        try {
            switch (controlContext.getPlanExecuteOpType()) {
                case PRE_OCCUPY_WRITE: 
                case PRE_OCCUPY_DELETE: 
                case PRE_OCCUPY_RELEASE: {
                    this.dataSaveService.updateAndCheckResult(IDataSaveService.Constants.CONTROL_OCCUPY_HOLD_REPORT_DATA_UPDATE, updateAmountInfoList, (k, o) -> {
                        o.add(k.getLockDiffAmt());
                        o.add(k.getReportDataId());
                        o.add(((ControlCoefficientInfo)coefficientFunction.apply(k.getReportDataId())).getCalculateData());
                        o.add(k.getLockDiffAmt());
                    });
                    break;
                }
                case WRITE: 
                case CANCEL: 
                case RELEASE: 
                case UPDATE: {
                    this.dataSaveService.updateAndCheckResult(IDataSaveService.Constants.CONTROL_ACT_HOLD_REPORT_DATA_UPDATE, updateAmountInfoList, (k, o) -> {
                        o.add(k.getActDiffAmt());
                        o.add(k.getLockDiffAmt());
                        o.add(k.getReportDataId());
                    });
                    break;
                }
            }
            if (controlContext.getPlanExecuteOpType().isOccupy()) {
                ControlUpdateSerialManager.getControlUpdateSerialManager().increment();
            }
        }
        catch (UpdateException e) {
            ControlAmountCache.AmountInfo info = (ControlAmountCache.AmountInfo)e.getObj();
            Long reportDataId = info.getReportDataId();
            ControlCoefficientInfo coefficientInfo = coefficientFunction.apply(reportDataId);
            logger.info("\u66f4\u65b0\u5931\u8d25\uff0csql:{},\u53c2\u6570\uff1a{},\u5f71\u54cd\u7684\u884c\u6570\uff1a{},\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{e.getSql(), Arrays.asList(e.getParams()), e.getUpdateCount(), e.getMessage(), e});
            ControlParamResultDTO.ErrorMessage errorMessage = this.getErrorMsg(coefficientInfo, controlContext, info);
            throw new KDBizException(errorMessage == null ? e.getMessage() : errorMessage.getMessage());
        }
    }

    public Map<String, List<Map.Entry<Long, AtomicReference<BigDecimal>>>> getSqlMap(Map<Long, PlanExecuteRecord> planExecuteRecordMap, ControlUpdateInfo controlUpdateInfo) {
        Map<Long, AtomicReference<BigDecimal>> releasedAmtFormUpdateRecords = this.getReleasedAmtFormUpdateRecords(controlUpdateInfo);
        HashMap<String, List<Map.Entry<Long, AtomicReference<BigDecimal>>>> sqlMap = new HashMap<String, List<Map.Entry<Long, AtomicReference<BigDecimal>>>>(4);
        for (Map.Entry<Long, AtomicReference<BigDecimal>> entry : releasedAmtFormUpdateRecords.entrySet()) {
            Long key2 = entry.getKey();
            PlanExecuteRecord planExecuteRecord = planExecuteRecordMap.get(key2);
            if (Objects.isNull(planExecuteRecord)) {
                logger.info("\u4e0d\u53ef\u80fd\u8d70\u5230\u8fd9\u91cc\u7684\u3002\uff1a{},{}", (Object)key2, (Object)entry.getKey());
                continue;
            }
            boolean positive = planExecuteRecord.getActAmount().compareTo(BigDecimal.ZERO) > 0;
            String sql = this.getSql(positive, planExecuteRecord.getExecuteOpType());
            List entryList = sqlMap.computeIfAbsent(sql, k -> new ArrayList(10));
            entryList.add(entry);
        }
        sqlMap.forEach((key, value) -> value.sort(Map.Entry.comparingByKey()));
        return sqlMap;
    }

    private String getSql(boolean positive, PlanExecuteOpType executeOpType) {
        if (executeOpType.isWrite()) {
            return positive ? "update t_fpm_executeplan set faclremainamt=faclremainamt-? where fid =? and faclremainamt-?>=0" : "update t_fpm_executeplan set faclremainamt=faclremainamt+?  where fid =? and faclremainamt-?<=0";
        }
        if (positive) {
            return "update t_fpm_executeplan set freleasedamt=freleasedamt+? where fid=? and frealamt-freleasedamt-?>=0";
        }
        return "update t_fpm_executeplan set freleasedamt=freleasedamt+? where fid=? and frealamt-freleasedamt-?<=0";
    }

    private Map<Long, PlanExecuteRecord> getAllPlanExecuteMap(ControlContext controlContext, ControlUpdateInfo controlUpdateInfo) {
        Map<Long, PlanExecuteRecord> executeRecordMap = controlContext.getControlTraceInfoMap().values().stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(ControlTraceInfo::getExecuteRecordList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toMap(PlanExecuteRecord::getId, Function.identity(), (a, b) -> a));
        controlUpdateInfo.getSavePlanExecuteRecordList().forEach(p -> executeRecordMap.putIfAbsent(p.getId(), (PlanExecuteRecord)p));
        return executeRecordMap;
    }

    private ControlParamResultDTO.ErrorMessage getErrorMsg(ControlCoefficientInfo coefficientInfo, ControlContext controlContext, ControlAmountCache.AmountInfo amountInfo) {
        FundPlanSystem system = controlContext.getSystem(amountInfo.getSystemId());
        List<ReportData> reportDataList = coefficientInfo.getReportDataList();
        ControlExecuteParam correspondingControlExecuteParam = this.getCorrespondingControlExecuteParam(controlContext, system, coefficientInfo);
        if (correspondingControlExecuteParam == null) {
            logger.info("\u7f16\u5236\u6570\u636eid\uff1a{}\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u3002", (Object)coefficientInfo.getReportDataId());
            return null;
        }
        Optional<ReportData> first = reportDataList.stream().filter(rd -> Objects.equals(coefficientInfo.getReportDataId(), rd.getId())).findFirst();
        if (!first.isPresent()) {
            first = correspondingControlExecuteParam.getRelateReportDataList().stream().filter(rd -> Objects.equals(coefficientInfo.getReportDataId(), rd.getId())).findFirst();
        }
        if (!first.isPresent()) {
            logger.info("{}\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7f16\u5236\u6570\u636e", (Object)coefficientInfo.getReportDataId());
            return null;
        }
        ReportData reportData = first.get();
        IReportDataQueryService reportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
        List<ReportData> dataList = reportDataQueryService.queryReportData(t -> t.setIdList(reportDataList.stream().map(ReportData::getId).collect(Collectors.toList())));
        BigDecimal subtract = BigDecimal.ZERO;
        for (ReportData rd2 : dataList) {
            subtract = rd2.getActAmt().add(rd2.getLockAmt()).add(rd2.getHoldActAmt()).add(rd2.getHoldLockAmt());
        }
        BigDecimal availableAmt = coefficientInfo.getCalculateData().subtract(subtract);
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        HashMap<Long, Object> dimensionValueMap = new HashMap<Long, Object>(dimList.size());
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = dimList.get(i);
            dimensionValueMap.put(templateDim.getDimensionId(), dimValList.get(i));
        }
        List<String> dimensionNameList = system.getMainDimList().stream().filter(dimension -> dimensionValueMap.containsKey(dimension.getId())).sorted(Comparator.comparing(DimensionInfoHelper::getScoreByDimensionType)).map(dimension -> dimension.getDimMemberById((Long)dimensionValueMap.get(dimension.getId()))).map(DimMember::getName).collect(Collectors.toList());
        return new ControlParamResultDTO.ErrorMessage(correspondingControlExecuteParam.getBillBizInfo().getBillNo(), system, dimensionNameList, reportData.getPlanAmt(), amountInfo.getLockDiffAmt(), availableAmt, reportData.getAmountUnit());
    }

    private ControlExecuteParam getCorrespondingControlExecuteParam(ControlContext controlContext, FundPlanSystem system, ControlCoefficientInfo coefficientInfo) {
        List<ControlExecuteParam> controlExecuteParamList = controlContext.getControlExecuteParamList();
        Long reportDataId = coefficientInfo.getReportDataId();
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        DimensionInfoBean dimensionInfoBean = null;
        Optional<ReportData> optional = coefficientInfo.getReportDataList().stream().filter(rd -> Objects.equals(rd.getId(), coefficientInfo.getReportDataId())).findFirst();
        if (optional.isPresent()) {
            dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(optional.get());
        }
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            Optional<ReportData> first;
            ArrayList<ReportData> matchedReportDataList = new ArrayList<ReportData>(controlExecuteParam.getMatchedReportDataList());
            List<ReportData> relateReportDataList = controlExecuteParam.getRelateReportDataList();
            if (EmptyUtil.isNoEmpty(relateReportDataList)) {
                matchedReportDataList.addAll(relateReportDataList);
            }
            if ((first = matchedReportDataList.stream().filter(rd -> Objects.equals(reportDataId, rd.getId())).findFirst()).isPresent()) {
                return controlExecuteParam;
            }
            if (dimensionInfoBean == null) continue;
            QueryIndexInfo dataQueryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(matchedReportDataList, controlContext.getSystem(controlExecuteParam.getSystemId()));
            for (ReportData rd2 : matchedReportDataList) {
                Object subjectId = rd2.getDimValByDimType(DimensionType.SUBJECTS);
                DimensionInfoBean copy = dimensionInfoBean.copy();
                copy.replaceValueIfContains(subjectDim.getId(), subjectId);
                ReportData one = dataQueryIndexInfo.findOne(copy);
                if (one == null) continue;
                return controlExecuteParam;
            }
        }
        return null;
    }

    private List<ControlAmountCache.AmountInfo> mergeRelateDiffAmountInfo(ControlUpdateInfo controlUpdateInfo, IRelateReportDataManager relateReportDataManager) {
        List<ControlAmountCache.AmountInfo> updateAmountInfoList = controlUpdateInfo.getUpdateAmountInfoList();
        List<ReportData> needUpdateReportDataList = this.getNeedUpdateReportDataList(controlUpdateInfo);
        RelateReportDataDiffManager relateReportDataDiffManager = new RelateReportDataDiffManager(needUpdateReportDataList, updateAmountInfoList, relateReportDataManager);
        ControlAmountCache reCalculateDagControlAmountCache = relateReportDataDiffManager.getReCalculateDagControlAmountCache();
        List<ControlAmountCache.AmountInfo> updateData = reCalculateDagControlAmountCache.getUpdateData();
        updateData.addAll(updateAmountInfoList);
        return updateData.stream().sorted(Comparator.comparing(ControlAmountCache.AmountInfo::getReportDataId)).collect(Collectors.toList());
    }

    private void updateControlUpdateInfo(List<ControlAmountCache.AmountInfo> updateAmountInfoList, ControlContext controlContext) {
        ControlRequestUpdateRecordManager controlRequestUpdateRecordManager = controlContext.getControlRequestUpdateRecordManager();
        if (EmptyUtil.isEmpty(updateAmountInfoList)) {
            controlRequestUpdateRecordManager.getControlRequestUpdateInfo().clear();
            controlRequestUpdateRecordManager.updateControlRequestToConsume();
            return;
        }
        ControlRequestUpdateInfo controlRequestUpdateInfo = controlRequestUpdateRecordManager.getControlRequestUpdateInfo();
        controlRequestUpdateInfo.clear();
        for (ControlAmountCache.AmountInfo amountInfo : updateAmountInfoList) {
            controlRequestUpdateInfo.updateByAmountInfo(amountInfo);
        }
        controlRequestUpdateRecordManager.updateControlRequestToConsume();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void commit(List<Long> recordIdList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addCommitListener(final Map<String, List<Long>> dbRouteKeyGroupRecordIdMap) {
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onCommitted() {
                for (Map.Entry entry : dbRouteKeyGroupRecordIdMap.entrySet()) {
                    String dbRouteKey = (String)entry.getKey();
                    List value = (List)entry.getValue();
                    TXHandle h = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        try {
                            ControlLocalMessageManager.getInstance().deleteLocalTxRecord(dbRouteKey, value);
                        }
                        catch (Exception e) {
                            h.markRollback();
                            logger.info(e.getMessage(), (Object)e);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (h == null) continue;
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h.close();
                    }
                }
            }
        });
    }

    private void confirmBatchUpdateData(Map<String, List<PlanExecuteRecord>> controlTraceRecordListMap, ControlUpdateInfo controlUpdateInfo, Long requestId) {
        List<PlanExecuteRecord> needUpdateRecords = controlUpdateInfo.getUpdatePlanExecuteRecordList();
        try {
            this.dataSaveService.updateAndCheckResult(IDataSaveService.Constants.CONTROL_PLAN_EXECUTE_RECORD_UPDATE, needUpdateRecords, (k, o) -> {
                o.add(CommonUtils.getBooleanStringValue(k.getDeleteStatus()));
                o.add(k.getExecuteStatus().getValue());
                o.add(k.getAclRemainAmt());
                o.add(k.getId());
                o.add(k.getOriginalExecuteStatus().getValue());
                o.add(CommonUtils.getBooleanStringValue(k.getOriginalDeleteStatus()));
            });
            this.dataSaveService.updateAndCheckResult(IDataSaveService.Constants.CONTROL_PLAN_EXECUTE_RECORD_E_UPDATE, needUpdateRecords, (k, o) -> {
                o.add(k.getRelateRecordId());
                o.add(k.getOriginalRecordId());
                o.add(k.getId());
            });
            ControlRequestUpdateRecordManager instanceByRequestId = ControlRequestUpdateRecordManager.getInstanceByRequestId(requestId);
            if (instanceByRequestId.getControlRequestUpdateInfo().getPlanExecuteOpType().isDelete()) {
                Map<Long, PlanExecuteRecord> executeRecordMap = controlTraceRecordListMap.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toMap(PlanExecuteRecord::getId, Function.identity(), (a, b) -> a));
                Map<String, List<Map.Entry<Long, AtomicReference<BigDecimal>>>> sqlMap = this.getSqlMap(executeRecordMap, controlUpdateInfo);
                sqlMap.forEach((sql, releaseEntryList) -> this.dataSaveService.updateAndCheckResult(() -> sql, releaseEntryList, (k, o) -> {
                    o.add(((AtomicReference)k.getValue()).get());
                    o.add(k.getKey());
                    o.add(((AtomicReference)k.getValue()).get());
                }));
            }
            List<ControlAmountCache.AmountInfo> amountInfoList = this.mergeRelateDiffAmountInfo(controlUpdateInfo, null);
            ControlRequestUpdateRecordManager.updateConsumed(requestId);
            this.dataSaveService.updateAndCheckResult(IDataSaveService.Constants.CONTROL_OCCUPY_CONFIRM_REPORT_DATA_UPDATE, amountInfoList, (k, o) -> {
                o.add(k.getLockDiffAmt());
                o.add(k.getActDiffAmt());
                o.add(k.getLockDiffAmt());
                o.add(k.getActDiffAmt());
                o.add(k.getReportDataId());
            });
        }
        catch (UpdateException e) {
            logger.info("\u66f4\u65b0\u5931\u8d25\uff0csql:{},\u53c2\u6570\uff1a{},\u5f71\u54cd\u7684\u884c\u6570\uff1a{},\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{e.getSql(), Arrays.asList(e.getParams()), e.getUpdateCount(), e.getMessage(), e});
            throw e;
        }
    }

    private Map<Long, AtomicReference<BigDecimal>> getReleasedAmtFormUpdateRecords(ControlUpdateInfo controlUpdateInfo) {
        ArrayList<PlanExecuteRecord> allPlanExecuteRecordList = new ArrayList<PlanExecuteRecord>(controlUpdateInfo.getSavePlanExecuteRecordList());
        allPlanExecuteRecordList.addAll(controlUpdateInfo.getUpdatePlanExecuteRecordList());
        HashMap<Long, AtomicReference<BigDecimal>> releasedAmtMap = new HashMap<Long, AtomicReference<BigDecimal>>();
        for (PlanExecuteRecord planExecuteRecord : allPlanExecuteRecordList) {
            PlanExecuteOpType executeOpType = planExecuteRecord.getExecuteOpType();
            if (!executeOpType.isRelease()) continue;
            Long originalRecordId = planExecuteRecord.getOriginalRecordId();
            if (EmptyUtil.isEmpty((Long)originalRecordId)) {
                logger.warn("\u6267\u884c\u8bb0\u5f55\uff1a{}\u64cd\u4f5c\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u539f\u59cb\u8bb0\u5f55id\u4e3a\u7a7a\uff0c\u4e3a\u5f02\u5e38\u8bb0\u5f55\u3002\u3002", (Object)planExecuteRecord.getRecordNumber(), (Object)planExecuteRecord.getExecuteOpType());
                continue;
            }
            AtomicReference atomicReleaseAmt = releasedAmtMap.computeIfAbsent(originalRecordId, k -> new AtomicReference<BigDecimal>(BigDecimal.ZERO));
            if (planExecuteRecord.getDeleteStatus().booleanValue()) {
                atomicReleaseAmt.set(((BigDecimal)atomicReleaseAmt.get()).add(planExecuteRecord.getActAmount()));
                continue;
            }
            if (planExecuteRecord.getOriginalExecuteStatus().isHolding() && (planExecuteRecord.getExecuteStatus().isHolding() || planExecuteRecord.getExecuteStatus() == PlanExecuteStatus.FAILURE)) {
                atomicReleaseAmt.set(((BigDecimal)atomicReleaseAmt.get()).add(planExecuteRecord.getActAmount().negate()));
                continue;
            }
            if (!planExecuteRecord.getOriginalExecuteStatus().isSuccess() || planExecuteRecord.getDeleteStatus().booleanValue()) continue;
            atomicReleaseAmt.set(((BigDecimal)atomicReleaseAmt.get()).subtract(planExecuteRecord.getActAmount().negate()));
        }
        return releasedAmtMap;
    }

    private String getErrorMsg(List<PlanExecuteRecord> needUpdateRecords) {
        String collect = needUpdateRecords.stream().map(PlanExecuteRecord::getRecordNumber).collect(Collectors.joining(","));
        return String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6267\u884c\u8bb0\u5f55\uff1a\u3010%1$s\u3011\u5df2\u7ecf\u88ab\u5176\u4ed6\u7ebf\u7a0b\u6d88\u8d39\u3002", (String)"ControlExecuteManagerImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), collect);
    }

    private ControlUpdateInfo doConfirm(Map<String, List<PlanExecuteRecord>> controlTraceRecordListMap, Set<Long> needConsumerIds, Map<Long, ReportData> reportDataMap, Map<String, List<Long>> dbRouteKeyGroupRecordIdMap) {
        List waitConsumerRecords = controlTraceRecordListMap.values().stream().flatMap(Collection::stream).filter(p -> needConsumerIds.contains(p.getId())).sorted(Comparator.comparing(PlanExecuteRecord::getExecuteDate)).collect(Collectors.toList());
        ControlUpdateInfo controlUpdateInfo = new ControlUpdateInfo();
        Map<Long, PlanExecuteRecord> executeRecordMap = controlTraceRecordListMap.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toMap(PlanExecuteRecord::getId, Function.identity(), (a, b) -> a));
        ControlAmountCache controlAmountCache = new ControlAmountCache();
        RelateExecutePlanRecordManager relateExecutePlanRecordManager = new RelateExecutePlanRecordManager(controlUpdateInfo, controlAmountCache, executeRecordMap, reportDataMap);
        for (PlanExecuteRecord planExecuteRecord : waitConsumerRecords) {
            List dbRouteKeyRecordIdList = dbRouteKeyGroupRecordIdMap.computeIfAbsent(planExecuteRecord.getDbRouteKey(), k -> new ArrayList());
            dbRouteKeyRecordIdList.add(planExecuteRecord.getId());
            if (planExecuteRecord.getExecuteStatus() != PlanExecuteStatus.WITHHOLDING) {
                logger.info("\u8bb0\u5f55{}\u5df2\u6d88\u8d39", (Object)planExecuteRecord);
                continue;
            }
            reportDataMap.putAll(planExecuteRecord.getMatchedReportDataList().stream().filter(Objects::nonNull).collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a)));
            controlAmountCache.init(planExecuteRecord.getMatchedReportDataList(), planExecuteRecord.getSystemId());
            relateExecutePlanRecordManager.consumerHoldingAmt(planExecuteRecord);
            planExecuteRecord.setExecuteStatus(PlanExecuteStatus.SUCCESSFUL);
            planExecuteRecord.setExecuteDate(DateUtils.getCurrentDate());
            planExecuteRecord.setDeleteStatus(this.isNeedFlagDelete(planExecuteRecord));
            controlUpdateInfo.addUpdatePlanExecuteRecord(planExecuteRecord);
            relateExecutePlanRecordManager.process(planExecuteRecord);
        }
        List<ControlAmountCache.AmountInfo> updateData = controlAmountCache.getUpdateData();
        updateData.forEach(controlUpdateInfo::addUpdateAmountInfo);
        return controlUpdateInfo;
    }

    private Map<String, List<PlanExecuteRecord>> getControlTraceMap(List<PlanExecuteRecord> planExecuteRecordList) {
        HashMap<String, List<PlanExecuteRecord>> controlTraceRecordListMap = new HashMap<String, List<PlanExecuteRecord>>(planExecuteRecordList.size());
        for (PlanExecuteRecord planExecuteRecord : planExecuteRecordList) {
            Long systemId = planExecuteRecord.getSystemId();
            BillBizInfo billBizInfo = planExecuteRecord.getBillBizInfo();
            String billSystemKey = String.join((CharSequence)"_", systemId.toString(), billBizInfo.getBillId().toString());
            controlTraceRecordListMap.computeIfAbsent(billSystemKey, key -> this.controlTraceService.getControlTraceInfo(billBizInfo, systemId).stream().filter(Objects::nonNull).map(ControlTraceInfo::getExecuteRecordList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return controlTraceRecordListMap;
    }

    private boolean isNeedFlagDelete(PlanExecuteRecord planExecuteRecord) {
        if (planExecuteRecord.getExecuteOpType() == PlanExecuteOpType.CANCEL) {
            return true;
        }
        return planExecuteRecord.getExecuteOpType() == PlanExecuteOpType.PRE_OCCUPY_DELETE;
    }

    private void fillTraceIdAndNeedSearchInfo(List<PlanExecuteRecord> planExecuteRecordList, Set<Long> needConsumerIds) {
        for (PlanExecuteRecord planExecuteRecord : planExecuteRecordList) {
            if (planExecuteRecord.getExecuteStatus() != PlanExecuteStatus.WITHHOLDING) continue;
            needConsumerIds.add(planExecuteRecord.getId());
            List<WaitConsumeInfo> waitConsumeInfoList = planExecuteRecord.getWaitConsumeInfoList();
            if (EmptyUtil.isEmpty(waitConsumeInfoList)) continue;
            needConsumerIds.addAll(waitConsumeInfoList.stream().map(WaitConsumeInfo::getWaitConsumeRecordId).collect(Collectors.toSet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(List<Long> recordIdList) {
        List<PlanExecuteRecord> planExecuteRecordList = this.controlRepository.loadPlanExecuteRecords(recordIdList);
        if (EmptyUtil.isEmpty(planExecuteRecordList = planExecuteRecordList.stream().filter(p -> p.getDeleteStatus() == false).filter(p -> p.getExecuteStatus().isHolding()).collect(Collectors.toList()))) {
            return;
        }
        try {
            Long requestId = planExecuteRecordList.get(0).getRequestId();
            ControlBotpUpperHolder.set(planExecuteRecordList);
            try {
                Map<String, List<PlanExecuteRecord>> controlTraceRecordListMap = this.getControlTraceMap(planExecuteRecordList);
                HashMap<Long, ReportData> reportDataMap = new HashMap<Long, ReportData>(64);
                ControlUpdateInfo controlUpdateInfo = this.doRollBack(controlTraceRecordListMap, recordIdList, reportDataMap);
                logger.info("ControlUpdateInfo: {}", (Object)controlUpdateInfo);
                try (TXHandle h = TX.requiresNew();){
                    try {
                        this.rollBackBatchUpdateData(controlUpdateInfo, requestId);
                    }
                    catch (Exception e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        finally {
            ControlBotpUpperHolder.clean();
        }
    }

    private ControlUpdateInfo doRollBack(Map<String, List<PlanExecuteRecord>> controlTraceRecordListMap, List<Long> needConsumerIds, Map<Long, ReportData> reportDataMap) {
        List waitConsumerRecords = controlTraceRecordListMap.values().stream().flatMap(Collection::stream).filter(p -> needConsumerIds.contains(p.getId())).sorted(Comparator.comparing(PlanExecuteRecord::getExecuteDate)).collect(Collectors.toList());
        ControlUpdateInfo controlUpdateInfo = new ControlUpdateInfo();
        Map<Long, PlanExecuteRecord> executeRecordMap = controlTraceRecordListMap.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toMap(PlanExecuteRecord::getId, Function.identity(), (a, b) -> a));
        ControlAmountCache controlAmountCache = new ControlAmountCache();
        RollBackRelateExecutePlanRecordManager relateExecutePlanRecordManager = new RollBackRelateExecutePlanRecordManager(controlUpdateInfo, controlAmountCache, executeRecordMap, reportDataMap);
        for (PlanExecuteRecord planExecuteRecord : waitConsumerRecords) {
            if (planExecuteRecord.getExecuteStatus() != PlanExecuteStatus.WITHHOLDING) {
                logger.info("\u8bb0\u5f55{}\u5df2\u6d88\u8d39", (Object)planExecuteRecord);
                continue;
            }
            reportDataMap.putAll(planExecuteRecord.getMatchedReportDataList().stream().filter(Objects::nonNull).collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a)));
            controlAmountCache.init(planExecuteRecord.getMatchedReportDataList(), planExecuteRecord.getSystemId());
            relateExecutePlanRecordManager.consumerHoldingAmt(planExecuteRecord);
            planExecuteRecord.setExecuteStatus(PlanExecuteStatus.FAILURE);
            planExecuteRecord.setExecuteDate(DateUtils.getCurrentDate());
            planExecuteRecord.setDeleteStatus(this.isNeedFlagDelete(planExecuteRecord));
            controlUpdateInfo.addUpdatePlanExecuteRecord(planExecuteRecord);
            relateExecutePlanRecordManager.process(planExecuteRecord);
        }
        List<ControlAmountCache.AmountInfo> updateData = controlAmountCache.getUpdateData();
        updateData.forEach(controlUpdateInfo::addUpdateAmountInfo);
        return controlUpdateInfo;
    }

    private void rollBackBatchUpdateData(ControlUpdateInfo controlUpdateInfo, Long requestId) {
        List<PlanExecuteRecord> needUpdateRecords = controlUpdateInfo.getUpdatePlanExecuteRecordList();
        Map<Long, AtomicReference<BigDecimal>> releasedAmtFormUpdateRecords = this.getReleasedAmtFormUpdateRecords(controlUpdateInfo);
        List releaseEntryList = releasedAmtFormUpdateRecords.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList());
        try {
            this.dataSaveService.updateAndCheckResult(IDataSaveService.Constants.CONTROL_PLAN_EXECUTE_RECORD_UPDATE, needUpdateRecords, (k, o) -> {
                o.add(CommonUtils.getBooleanStringValue(k.getDeleteStatus()));
                o.add(k.getExecuteStatus().getValue());
                o.add(k.getId());
                o.add(k.getOriginalExecuteStatus().getValue());
                o.add(CommonUtils.getBooleanStringValue(k.getOriginalDeleteStatus()));
            });
            this.dataSaveService.updateAndCheckResult(IDataSaveService.Constants.CONTROL_PLAN_EXECUTE_RECORD_E_UPDATE, needUpdateRecords, (k, o) -> {
                o.add(k.getRelateRecordId());
                o.add(k.getOriginalRecordId());
                o.add(k.getId());
            });
            this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_executeplan set freleasedamt=freleasedamt-? where fid=? ", releaseEntryList, (k, o) -> {
                o.add(((AtomicReference)k.getValue()).get());
                o.add(k.getKey());
            });
            List<ControlAmountCache.AmountInfo> amountInfoList = this.mergeRelateDiffAmountInfo(controlUpdateInfo, null);
            ControlRequestUpdateRecordManager instanceByRequestId = ControlRequestUpdateRecordManager.getInstanceByRequestId(requestId);
            if (EmptyUtil.isNoEmpty((Object)instanceByRequestId)) {
                instanceByRequestId.updateControlRequestToDeleteNotNewTransaction();
            }
            this.dataSaveService.updateAndCheckResult(IDataSaveService.Constants.CONTROL_ROLLBACK_REPORT_DATA_UPDATE, amountInfoList, (k, o) -> {
                o.add(k.getLockDiffAmt());
                o.add(k.getActDiffAmt());
                o.add(k.getReportDataId());
            });
        }
        catch (UpdateException e) {
            logger.error(e.getMessage(), (Throwable)((Object)e));
            String errorMsg = this.getErrorMsg(needUpdateRecords);
            throw new KDBizException(errorMsg);
        }
    }

    private void invokeControlParamProcessor(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        if (EmptyUtil.isEmpty(this.controlExecuteParamPostProcessorList)) {
            return;
        }
        ArrayList<IControlExecuteParamPostProcessor> list = new ArrayList<IControlExecuteParamPostProcessor>(this.controlExecuteParamPostProcessorList);
        list.addAll(controlContext.getControlExecuteParamPostProcessorList());
        list.sort(Comparator.comparing(IControlExecuteParamPostProcessor::getOrder));
        for (IControlExecuteParamPostProcessor controlExecuteParamPostProcessor : list) {
            controlExecuteParamPostProcessor.postProcess(controlContext, controlExecuteParamList);
        }
    }

    public void registerControlParamProcessor(IControlExecuteParamPostProcessor controlExecuteParamPostProcessor) {
        if (!this.controlExecuteParamPostProcessorList.contains(controlExecuteParamPostProcessor)) {
            this.controlExecuteParamPostProcessorList.add(controlExecuteParamPostProcessor);
        }
    }

    private void registerDefault() {
        this.registerControlParamProcessor(new ControlTimeCheckProcessor());
        this.registerControlParamProcessor(new RequestIdTimeOutMakDeletePostProcessor());
        this.registerControlParamProcessor(new ControlContextFillBackPostProcessor());
        this.registerControlParamProcessor(new MatchFieldRelateMergeKeyPostProcessor());
        this.registerControlParamProcessor(new ControlExecuteParamPostProcessorImpl());
        this.registerControlParamProcessor(new ZeroFilterPostProcessor());
        this.registerControlParamProcessor(new SubjectCheckPostProcessorImpl());
        this.registerControlParamProcessor(new ReportOrgEnableDatePostProcessor());
        this.registerControlParamProcessor(new MultiSourceInfoPostProcessor());
        this.registerControlParamProcessor(new ControlTraceIdProcessPostProcessor());
        this.registerControlParamProcessor(new ControlTraceFillBackProcessor());
        this.registerControlParamProcessor(new BizCurrencyFillBackPostProcessor());
    }

    private static /* synthetic */ boolean lambda$commit$26(PlanExecuteRecord p) {
        return p.getExecuteStatus().isHolding();
    }

    private static /* synthetic */ boolean lambda$commit$25(PlanExecuteRecord p) {
        return p.getDeleteStatus() == false;
    }
}

