/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTracePlanRecordSort;
import kd.tmc.fpm.business.domain.model.control.ControlUpdateInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.control.RecordWithoutHoldingInfo;
import kd.tmc.fpm.business.domain.model.control.WaitConsumeInfo;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dto.ExecContrCompareParamDTO;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections4.MapUtils;

public class ControlStrategyDelegate {
    private ControlContext controlContext;
    private IReportRepository repository = new ReportRepository();
    private Map<Long, Report> reportMap;
    private Map<String, ControlTracePlanRecordSort> controlTracePlanRecordSortMap;
    private static final Log logger = LogFactory.getLog(ControlStrategyDelegate.class);

    public ControlStrategyDelegate(ControlContext controlContext) {
        this.controlContext = controlContext;
    }

    public PlanExecuteRecord createPlanExecuteRecord(ControlExecuteParam controlExecuteParam) {
        PlanExecuteRecord planExecuteRecord = new PlanExecuteRecord();
        planExecuteRecord.setId(DB.genGlobalLongId());
        planExecuteRecord.setAccurateMatch(controlExecuteParam.isAccurateMatch());
        planExecuteRecord.setVersion("");
        planExecuteRecord.setDbRouteKey(this.controlContext.getDbRouteKey());
        planExecuteRecord.setExecuteOpType(this.controlContext.getPlanExecuteOpType());
        BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
        planExecuteRecord.setBillBizInfo(billBizInfo);
        planExecuteRecord.setMatchRuleId(controlExecuteParam.getMatchRule().getId());
        planExecuteRecord.setActAmount(controlExecuteParam.getExecuteActAmount());
        planExecuteRecord.setDeleteStatus(Boolean.FALSE);
        planExecuteRecord.setOriginalDeleteStatus(planExecuteRecord.getDeleteStatus());
        planExecuteRecord.setExecuteStatus(PlanExecuteStatus.WITHHOLDING);
        planExecuteRecord.setOriginalExecuteStatus(planExecuteRecord.getExecuteStatus());
        planExecuteRecord.setSystemId(controlExecuteParam.getSystemId());
        planExecuteRecord.setReportOrgId(controlExecuteParam.getReportOrgId());
        planExecuteRecord.setExecuteDate(DateUtils.getCurrentDate());
        planExecuteRecord.setReportData(controlExecuteParam.getReportData());
        planExecuteRecord.setRate(controlExecuteParam.getRate());
        planExecuteRecord.setRateDate(controlExecuteParam.getRateDate());
        planExecuteRecord.setBizOpName(this.controlContext.getOpName());
        planExecuteRecord.setDetailMatchInfo(controlExecuteParam.getDetailMatchInfo());
        List<ReportData> matchedReportDataList = controlExecuteParam.getMatchedReportDataList();
        planExecuteRecord.setMatchedReportDataList(matchedReportDataList);
        planExecuteRecord.setDetailMatchedDimIdS(controlExecuteParam.getDetailMatchedDimIdS());
        planExecuteRecord.setFloatMatchedDimIdS(controlExecuteParam.getFloatMatchedDimIdS());
        planExecuteRecord.setReportTypeId(controlExecuteParam.getReportTypeId());
        if (this.controlContext.getPlanExecuteOpType() == PlanExecuteOpType.WRITE || this.controlContext.getPlanExecuteOpType() == PlanExecuteOpType.PRE_OCCUPY_WRITE) {
            planExecuteRecord.setUnReleaseAmt(planExecuteRecord.getActAmount());
        }
        planExecuteRecord.setControlTraceId(this.controlContext.getControlTraceId(billBizInfo.getBillId()));
        planExecuteRecord.setRequestId(this.controlContext.getRequestId());
        this.generateWithHoldingInfo(planExecuteRecord, this.isOccupy(), this.isPositive());
        planExecuteRecord.setBizCurrencyId(controlExecuteParam.getBizCurrencyId());
        PlanExecuteRecord originalPlanExecuteRecord = controlExecuteParam.getOriginalPlanExecuteRecord();
        if (Objects.nonNull(originalPlanExecuteRecord)) {
            planExecuteRecord.setOriginalRecordId(originalPlanExecuteRecord.getId());
        }
        return planExecuteRecord;
    }

    private boolean isOccupy() {
        return this.isOccupy(this.controlContext.getPlanExecuteOpType());
    }

    public boolean isOccupy(PlanExecuteOpType planExecuteOpType) {
        switch (planExecuteOpType) {
            case PRE_OCCUPY_DELETE: 
            case PRE_OCCUPY_WRITE: 
            case PRE_OCCUPY_RELEASE: {
                return true;
            }
        }
        return false;
    }

    private boolean isPositive() {
        return !this.isRelease(this.controlContext.getPlanExecuteOpType());
    }

    private boolean isRelease() {
        return this.isRelease(this.controlContext.getPlanExecuteOpType());
    }

    public boolean isRelease(PlanExecuteOpType planExecuteOpType) {
        switch (planExecuteOpType) {
            case PRE_OCCUPY_DELETE: 
            case CANCEL: {
                return true;
            }
        }
        return false;
    }

    public PlanExecuteRecord getReleasePlanExecuteRecord(PlanExecuteRecord planExecuteRecord, PlanExecuteRecord waitReleaseRecord, PlanExecuteOpType planExecuteOpType) {
        return this.getReleasePlanExecuteRecord(planExecuteRecord, waitReleaseRecord, planExecuteOpType, waitReleaseRecord.getActAmount());
    }

    public PlanExecuteRecord getReleasePlanExecuteRecord(PlanExecuteRecord planExecuteRecord, PlanExecuteRecord waitReleaseRecord, PlanExecuteOpType planExecuteOpType, BigDecimal waitReleaseAmt) {
        PlanExecuteRecord copy = waitReleaseRecord.copy(p -> {
            p.setBizOpName(planExecuteRecord.getBizOpName());
            p.setOriginalRecordId(waitReleaseRecord.getId());
            p.setRelateRecordId(planExecuteRecord.getId());
            p.setExecuteOpType(planExecuteOpType);
            p.setRecordNumber(null);
            BigDecimal actAmt = waitReleaseAmt;
            if (planExecuteOpType == PlanExecuteOpType.RELEASE || planExecuteOpType == PlanExecuteOpType.PRE_OCCUPY_RELEASE) {
                actAmt = waitReleaseAmt.negate();
            }
            p.setActAmount(actAmt);
            List<RecordWithoutHoldingInfo> withoutHoldingInfoList = p.getRecordWithoutHoldingInfoList();
            List<RecordWithoutHoldingInfo> recordWithoutHoldingInfoList = waitReleaseRecord.getRecordWithoutHoldingInfoList();
            Deque<Long> idQueue = ControlStrategyDelegate.getIds(recordWithoutHoldingInfoList.size());
            Map<Long, ReportData> matchedReportDataMap = p.getMatchedReportDataMap();
            for (RecordWithoutHoldingInfo recordWithoutHoldingInfo : recordWithoutHoldingInfoList) {
                RecordWithoutHoldingInfo withoutHoldingInfo = new RecordWithoutHoldingInfo();
                withoutHoldingInfo.setId(idQueue.poll());
                Long reportDataId = recordWithoutHoldingInfo.getReportDataId();
                if (planExecuteOpType == PlanExecuteOpType.PRE_OCCUPY_RELEASE || planExecuteOpType == PlanExecuteOpType.PRE_OCCUPY_DELETE) {
                    withoutHoldingInfo.setHoldLockAmt(matchedReportDataMap.get(reportDataId).getReportActAmount(waitReleaseAmt.negate()));
                }
                if (planExecuteOpType == PlanExecuteOpType.RELEASE || planExecuteOpType == PlanExecuteOpType.CANCEL) {
                    withoutHoldingInfo.setHoldActAmt(matchedReportDataMap.get(reportDataId).getReportActAmount(waitReleaseAmt.negate()));
                }
                withoutHoldingInfo.setReportDataId(reportDataId);
                withoutHoldingInfoList.add(withoutHoldingInfo);
            }
        });
        return copy;
    }

    private static Deque<Long> getIds(int count) {
        LinkedList<Long> idQueue = new LinkedList<Long>();
        if (count > 0) {
            long[] idArr;
            for (long id : idArr = DB.genGlobalLongIds((int)count)) {
                idQueue.offer(id);
            }
        }
        return idQueue;
    }

    public PlanExecuteRecord generateRecordFormPlanExecuteRecord(PlanExecuteRecord planExecuteRecord, Consumer<PlanExecuteRecord> planExecuteRecordConsumer) {
        PlanExecuteRecord actualGenOccupyRecord = planExecuteRecord.copy(planExecuteRecordConsumer);
        this.generateWithHoldingInfo(actualGenOccupyRecord, this.isOccupy(actualGenOccupyRecord.getExecuteOpType()), !this.isRelease(actualGenOccupyRecord.getExecuteOpType()));
        return actualGenOccupyRecord;
    }

    public void generateWithHoldingInfo(PlanExecuteRecord planExecuteRecord, boolean isOccupy, boolean isPositive) {
        List<ReportData> matchedReportDataList = planExecuteRecord.getMatchedReportDataList();
        ControlAmountCache controlAmountCache = this.controlContext.getControlAmountCache();
        BigDecimal reportActAmount = planExecuteRecord.getActAmount();
        reportActAmount = isPositive ? reportActAmount : reportActAmount.negate();
        ArrayList<RecordWithoutHoldingInfo> recordWithoutHoldingInfoList = new ArrayList<RecordWithoutHoldingInfo>(matchedReportDataList.size());
        Deque<Long> ids = ControlStrategyDelegate.getIds(matchedReportDataList.size());
        for (ReportData reportData : matchedReportDataList) {
            RecordWithoutHoldingInfo recordWithoutHoldingInfo = new RecordWithoutHoldingInfo();
            BigDecimal realReportActAmount = reportData.getReportActAmount(reportActAmount);
            recordWithoutHoldingInfo.setHoldActAmt(isOccupy ? BigDecimal.ZERO : realReportActAmount);
            recordWithoutHoldingInfo.setId(ids.poll());
            recordWithoutHoldingInfo.setHoldLockAmt(isOccupy ? realReportActAmount : BigDecimal.ZERO);
            recordWithoutHoldingInfo.setReportDataId(reportData.getId());
            if (isOccupy) {
                controlAmountCache.updateLockAmount(reportData.getId(), realReportActAmount);
            } else {
                controlAmountCache.updateActAmount(reportData.getId(), realReportActAmount);
            }
            recordWithoutHoldingInfoList.add(recordWithoutHoldingInfo);
        }
        planExecuteRecord.setRecordWithoutHoldingInfoList(recordWithoutHoldingInfoList);
    }

    public void updateWithHoldingAmt(PlanExecuteRecord withHoldingRecord) {
        this.updateWithHoldingAmtByCache(this.controlContext.getControlAmountCache(), withHoldingRecord);
    }

    public void updateWithHoldingAmtByCache(ControlAmountCache controlAmountCache, PlanExecuteRecord withHoldingRecord) {
        this.updateWithHoldingAmtByCache(controlAmountCache, withHoldingRecord, withHoldingRecord.getActAmount(), this.isRelease(), this.isOccupy());
    }

    public void updateWithHoldingAmtByCache(ControlAmountCache controlAmountCache, PlanExecuteRecord withHoldingRecord, BigDecimal amount) {
        this.updateWithHoldingAmtByCache(controlAmountCache, withHoldingRecord, amount, this.isRelease(), this.isOccupy());
    }

    public void updateWithHoldingAmt(PlanExecuteRecord withHoldingRecord, BigDecimal waitReleaseAmt, boolean isRelease, boolean isOccupy) {
        this.updateWithHoldingAmtByCache(this.controlContext.getControlAmountCache(), withHoldingRecord, waitReleaseAmt, isRelease, isOccupy);
    }

    public void updateWithHoldingAmt(PlanExecuteRecord withHoldingRecord, boolean isRelease, boolean isOccupy) {
        this.updateWithHoldingAmtByCache(this.controlContext.getControlAmountCache(), withHoldingRecord, withHoldingRecord.getActAmount(), isRelease, isOccupy);
    }

    public void updateWithHoldingAmt(PlanExecuteRecord withHoldingRecord, BigDecimal waitReleaseAmt) {
        this.updateWithHoldingAmtByCache(this.controlContext.getControlAmountCache(), withHoldingRecord, waitReleaseAmt, this.isRelease(), this.isOccupy());
    }

    public void updateWithHoldingAmtByCache(ControlAmountCache controlAmountCache, PlanExecuteRecord withHoldingRecord, BigDecimal waitReleaseAmt, boolean isRelease, boolean isOccupy) {
        List<RecordWithoutHoldingInfo> recordWithoutHoldingInfoList = withHoldingRecord.getRecordWithoutHoldingInfoList();
        Map reportDataMap = withHoldingRecord.getMatchedReportDataList().stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
        for (RecordWithoutHoldingInfo info : recordWithoutHoldingInfoList) {
            BigDecimal holdLockAmt;
            BigDecimal waitReleaseAmtReal = ((ReportData)reportDataMap.get(info.getReportDataId())).getReportActAmount(waitReleaseAmt);
            BigDecimal bigDecimal = holdLockAmt = isRelease ? waitReleaseAmtReal.negate() : waitReleaseAmtReal;
            if (isOccupy) {
                controlAmountCache.updateLockAmount(info.getReportDataId(), holdLockAmt);
                continue;
            }
            controlAmountCache.updateActAmount(info.getReportDataId(), holdLockAmt);
        }
    }

    @Deprecated
    public List<ControlTraceInfo> sortedExecuteRecord(List<ControlTraceInfo> traceInfoList, PlanExecuteRecord baseRecord) {
        ArrayList<ControlTraceInfo> result = new ArrayList<ControlTraceInfo>(traceInfoList.size());
        for (ControlTraceInfo controlTraceInfo : traceInfoList) {
            ControlTraceInfo currNewInfo = new ControlTraceInfo();
            List<PlanExecuteRecord> executeRecordList = controlTraceInfo.getExecuteRecordList();
            if (!CollectionUtils.isEmpty(executeRecordList)) {
                ArrayList<PlanExecuteRecord> samDimPreOccRecordList = new ArrayList<PlanExecuteRecord>(16);
                ArrayList<PlanExecuteRecord> samDimAndAmtPreOccRecordList = new ArrayList<PlanExecuteRecord>(16);
                executeRecordList = executeRecordList.stream().sorted(Comparator.comparing(PlanExecuteRecord::getExecuteDate)).collect(Collectors.toList());
                for (PlanExecuteRecord occupyRecord : executeRecordList) {
                    if (occupyRecord.getReportData() == null || occupyRecord.getDeleteStatus().booleanValue()) continue;
                    ExecContrCompareParamDTO currWriteAmtCompareParam = new ExecContrCompareParamDTO(baseRecord);
                    ExecContrCompareParamDTO historyContrCompare = new ExecContrCompareParamDTO(occupyRecord);
                    int compareResult = currWriteAmtCompareParam.compare(historyContrCompare);
                    if (compareResult == 0) {
                        samDimAndAmtPreOccRecordList.add(occupyRecord);
                    }
                    if (compareResult != 2) continue;
                    samDimPreOccRecordList.add(occupyRecord);
                }
                if (!CollectionUtils.isEmpty(samDimPreOccRecordList)) {
                    executeRecordList.removeAll(samDimPreOccRecordList);
                    executeRecordList.addAll(0, samDimPreOccRecordList);
                }
                if (!CollectionUtils.isEmpty(samDimAndAmtPreOccRecordList)) {
                    executeRecordList.removeAll(samDimAndAmtPreOccRecordList);
                    executeRecordList.addAll(0, samDimAndAmtPreOccRecordList);
                }
                controlTraceInfo.setExecuteRecordList(executeRecordList);
                currNewInfo.setExecuteRecordList(new ArrayList<PlanExecuteRecord>(executeRecordList));
            }
            result.add(currNewInfo);
        }
        return result;
    }

    public ControlTracePlanRecordSort sortedExecuteRecord(List<ControlTraceInfo> traceInfoList, String key) {
        logger.info("sortedExecuteRecord start");
        if (EmptyUtil.isEmpty(traceInfoList)) {
            return ControlTracePlanRecordSort.getInstance(null);
        }
        if (Objects.isNull(this.controlTracePlanRecordSortMap)) {
            this.controlTracePlanRecordSortMap = new HashMap<String, ControlTracePlanRecordSort>(16);
        }
        ControlTracePlanRecordSort controlTracePlanRecordSort = this.controlTracePlanRecordSortMap.computeIfAbsent(key, k -> ControlTracePlanRecordSort.getInstanceByList(traceInfoList));
        logger.info("sortedExecuteRecord has traceInfo end");
        return controlTracePlanRecordSort;
    }

    @Deprecated
    public List<PlanExecuteRecord> getControlTracePlanRecordFilterDelete(PlanExecuteRecord currentPlanExecuteRecord, ControlUpdateInfo controlUpdateInfo) {
        BillBizInfo billBizInfo = currentPlanExecuteRecord.getBillBizInfo();
        String key = String.join((CharSequence)"#", billBizInfo.getBillId().toString(), currentPlanExecuteRecord.getSystemId().toString());
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        List<ControlTraceInfo> controlTraceInfoList = controlTraceInfoMap.get(key);
        if (EmptyUtil.isEmpty(controlTraceInfoList)) {
            return Collections.emptyList();
        }
        Predicate<PlanExecuteRecord> deleteFilter = planExecuteRecord -> {
            if (planExecuteRecord.isUpdate()) {
                controlUpdateInfo.addUpdatePlanExecuteRecord((PlanExecuteRecord)planExecuteRecord);
                planExecuteRecord.clearMark();
            }
            return planExecuteRecord.getDeleteStatus() == false;
        };
        return controlTraceInfoList.stream().filter(Objects::nonNull).map(ControlTraceInfo::getExecuteRecordList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(deleteFilter::test).filter(planExecuteRecord -> Objects.equals(planExecuteRecord.getSystemId(), currentPlanExecuteRecord.getSystemId())).filter(planExecuteRecord -> Objects.equals(planExecuteRecord.getReportTypeId(), currentPlanExecuteRecord.getReportTypeId())).collect(Collectors.toList());
    }

    public void addWaitConsumeInfo(PlanExecuteRecord planExecuteRecord) {
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        BillBizInfo billBizInfo = planExecuteRecord.getBillBizInfo();
        String key = String.join((CharSequence)"#", billBizInfo.getBillId().toString(), planExecuteRecord.getSystemId().toString());
        List controlTraceInfoList = controlTraceInfoMap.getOrDefault(key, Collections.emptyList());
        List<WaitConsumeInfo> waitConsumeInfoList = controlTraceInfoList.stream().map(ControlTraceInfo::getExecuteRecordList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(p -> p.getDeleteStatus() == false).filter(p -> p.getExecuteStatus() == PlanExecuteStatus.WITHHOLDING).filter(p -> EmptyUtil.isEmpty((Long)p.getRelateRecordId())).map(PlanExecuteRecord::getId).map(WaitConsumeInfo::new).collect(Collectors.toList());
        planExecuteRecord.setWaitConsumeInfoList(waitConsumeInfoList);
    }

    public String getGroupKey(BillBizInfo billBizInfo, BillMatchRule billMatchRule) {
        return this.getGroupKey(billBizInfo, billMatchRule.getId());
    }

    public String getGroupKey(BillBizInfo billBizInfo, Long matchRuleId) {
        StringBuilder sb = new StringBuilder();
        sb.append(billBizInfo.getBillId());
        Long entryId = billBizInfo.getEntryId();
        if (EmptyUtil.isNoEmpty((Long)entryId)) {
            sb.append("_").append(entryId);
        }
        sb.append("_").append(matchRuleId);
        return sb.toString();
    }

    public Map<Long, Report> getReportMap() {
        List<Report> reportList;
        if (MapUtils.isNotEmpty(this.reportMap)) {
            return this.reportMap;
        }
        HashSet<Long> reportIds = new HashSet<Long>(4);
        for (ControlExecuteParam controlExecuteParam : this.controlContext.getControlExecuteParamList()) {
            reportIds.addAll(controlExecuteParam.getMatchedReportDataList().stream().map(ReportData::getReportId).collect(Collectors.toSet()));
            List<ReportData> relateReportDataList = controlExecuteParam.getRelateReportDataList();
            if (!EmptyUtil.isNoEmpty(relateReportDataList)) continue;
            reportIds.addAll(relateReportDataList.stream().map(ReportData::getReportId).collect(Collectors.toSet()));
        }
        logger.info("\u67e5\u8be2\u7f16\u5236\u8868:{}", reportIds);
        List<Report> reports = reportList = this.repository.loadSimpleReport(reportIds, r -> {
            r.setNeedTemplate(true);
            r.setNeedRateTableId(true);
            r.setNeedCompanyMember(true);
            r.setNeedAuditErId(true);
            r.setNeedInformantErId(true);
        });
        this.reportMap = reports.stream().collect(Collectors.toMap(Report::getId, Function.identity(), (a, b) -> a));
        return this.reportMap;
    }

    public Report getReportById(Long reportId) {
        this.getReportMap();
        return this.reportMap.computeIfAbsent(reportId, k -> this.repository.loadSimpleReport(Collections.singleton(reportId), r -> {
            r.setNeedTemplate(true);
            r.setNeedRateTableId(true);
            r.setNeedCompanyMember(true);
            r.setNeedAuditErId(true);
            r.setNeedInformantErId(true);
        }).get(0));
    }

    public void deleteErrorRecordIfNeed(ControlUpdateInfo controlUpdateInfo) {
        logger.info("\u5220\u9664\u5f02\u5e38\u6267\u884c\u8bb0\u5f55....");
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        controlTraceInfoMap.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).map(ControlTraceInfo::getExecuteRecordList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(PlanExecuteRecord::isUpdate).forEach(p -> {
            logger.info("\u6267\u884c\u8bb0\u5f55\uff1a{}\u4e3a\u5f02\u5e38\u8bb0\u5f55\uff0c\u6267\u884c\u5220\u9664");
            p.clearMark();
            controlUpdateInfo.addUpdatePlanExecuteRecord((PlanExecuteRecord)p);
        });
    }

    public void fillCompleteControlUpdateInfo(ControlUpdateInfo controlUpdateInfo) {
        ControlAmountCache controlAmountCache = this.controlContext.getControlAmountCache();
        List<ControlAmountCache.AmountInfo> updateData = controlAmountCache.getUpdateData();
        controlUpdateInfo.addAllUpdateAmountInfo(updateData);
    }

    public void fillMatchInfo(ControlExecuteParam controlExecuteParam, PlanExecuteRecord planExecuteRecord) {
        controlExecuteParam.setActAmount(planExecuteRecord.getActAmount(), true);
        controlExecuteParam.setDetailMatchInfo(planExecuteRecord.getDetailMatchInfo());
        controlExecuteParam.setMatchedReportDataList(planExecuteRecord.getMatchedReportDataList());
        controlExecuteParam.setDetailMatchedDimIdS(planExecuteRecord.getDetailMatchedDimIdS());
        controlExecuteParam.setFloatMatchedDimIdS(planExecuteRecord.getFloatMatchedDimIdS());
        DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBeanByFilter(planExecuteRecord.getReportData(), td -> td.getDimType().isSystemDim());
        if (EmptyUtil.isNoEmpty(planExecuteRecord.getDetailMatchedDimIdS())) {
            BitMap<Long, Long> bitMap = new BitMap<Long, Long>(16);
            bitMap.addValue(new HashSet<Long>(planExecuteRecord.getDetailMatchedDimIdS()), planExecuteRecord.getReportData().getId());
            controlExecuteParam.setDetailDimBitMap(bitMap);
        }
        if (EmptyUtil.isNoEmpty(planExecuteRecord.getFloatMatchedDimIdS())) {
            planExecuteRecord.getFloatMatchedDimIdS().forEach(dimId -> dimensionInfoBean.addDimensionInfo(dimId, planExecuteRecord.getReportData().getDimValByDimensionId((Long)dimId)));
        }
        controlExecuteParam.setDimensionInfoBean(dimensionInfoBean);
        controlExecuteParam.setReportData(planExecuteRecord.getReportData());
        controlExecuteParam.setOriginalPlanExecuteRecord(planExecuteRecord);
        controlExecuteParam.setReportTypeId(planExecuteRecord.getReportTypeId());
        controlExecuteParam.setRate(planExecuteRecord.getRate());
        controlExecuteParam.setRateDate(planExecuteRecord.getRateDate());
        controlExecuteParam.setAccurateMatch(planExecuteRecord.getAccurateMatch());
        controlExecuteParam.setBizCurrencyId(planExecuteRecord.getBizCurrencyId());
    }

    public void processCurrentHoldingRecordIfNeed(ControlUpdateInfo controlUpdateInfo, ControlTracePlanRecordSort controlTracePlanRecordSort, ControlExecuteParam controlExecuteParam) {
        logger.info("\u91cd\u5165\u5904\u7406\u5c1a\u672a\u6d88\u8d39\u7684\u9884\u6263\u51cf...");
        if (controlTracePlanRecordSort.isEmpty()) {
            return;
        }
        BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
        List holdingRecordList = controlTracePlanRecordSort.getPlanExecuteRecords(this.controlContext.getPlanExecuteOpType(), controlExecuteParam.getBillBizInfo()).stream().filter(Objects::nonNull).filter(p -> p.getExecuteStatus() == PlanExecuteStatus.WITHHOLDING).collect(Collectors.toList());
        logger.info("\u5f53\u524d\u5355\u636e\uff1a{}\u5b58\u5728\u5c1a\u672a\u6d88\u8d39\u7684\u9884\u6263\u51cf\u8bb0\u5f55\uff1a{}", (Object)billBizInfo.getBillNo(), holdingRecordList);
        if (EmptyUtil.isEmpty(holdingRecordList)) {
            return;
        }
        logger.info("\u672c\u6b21\u64cd\u4f5c\u91cd\u505a\uff0c\u5bf9\u4e0a\u6b21\u672a\u6d88\u8d39\u7684\u9884\u6263\u51cf\u8bb0\u5f55\u76f4\u63a5\u5220\u9664....");
        for (PlanExecuteRecord holdingRecord : holdingRecordList) {
            holdingRecord.setDeleteStatus(Boolean.TRUE);
            this.updateWithHoldingAmt(holdingRecord, !this.isRelease(), this.isOccupy());
            controlUpdateInfo.addUpdatePlanExecuteRecord(holdingRecord);
            controlTracePlanRecordSort.updateRecord(holdingRecord);
        }
    }

    public String getControlTraceMapKey(ControlExecuteParam controlExecuteParam) {
        BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
        String key = String.join((CharSequence)"#", billBizInfo.getBillId().toString(), controlExecuteParam.getSystemId().toString());
        return key;
    }

    public boolean largeThan(BigDecimal currentActualAmt, BigDecimal occupyAmt) {
        if (occupyAmt.compareTo(BigDecimal.ZERO) > 0) {
            return currentActualAmt.compareTo(occupyAmt) > 0;
        }
        return currentActualAmt.compareTo(occupyAmt) < 0;
    }
}

