/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.control.RecordWithoutHoldingInfo;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ControlRepository;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.IControlTraceService;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.impl.ControlLocalMessageManager;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DbRouteUtil;

public class ControlTraceFillBackProcessor
implements IControlExecuteParamPostProcessor {
    private static final Log logger = LogFactory.getLog(ControlTraceFillBackProcessor.class);
    private final IControlTraceService controlTraceService = FpmServiceFactory.getBizService(IControlTraceService.class);
    private final IControlRepository controlRepository = new ControlRepository();

    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        logger.info("\u67e5\u8be2\u63a7\u5236\u94fe\u8def\u4fe1\u606f\u3002\u3002\u3002\u3002\u3002");
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.getControlTraceInfo(controlContext, controlExecuteParamList);
        logger.info("\u6839\u636e\u94fe\u8def\u4fe1\u606f\u521d\u59cb\u5316\u91d1\u989d\u7f13\u5b58\u3002\u3002\u3002\u3002\u3002");
        ControlAmountCache controlAmountCache = this.getControlAmountCache(controlTraceInfoMap);
        logger.info("\u5408\u5e76\u94fe\u8def\u4e0a\u7684\u91ca\u653e\u91d1\u989d\u5230\u5bf9\u5e94\u7684\u9884\u5360\u6216\u5b9e\u5360\u7684\u672a\u91ca\u653e\u91d1\u989d\u3002\u3002\u3002\u3002");
        this.mergeReleaseAmtToWriteRecord(controlTraceInfoMap);
        controlContext.setControlTraceInfoMap(controlTraceInfoMap);
        controlContext.setControlAmountCache(controlAmountCache);
    }

    private void mergeReleaseAmtToWriteRecord(Map<String, List<ControlTraceInfo>> controlTraceInfoMap) {
        for (List<ControlTraceInfo> controlTraceInfoList : controlTraceInfoMap.values()) {
            for (ControlTraceInfo traceInfo : controlTraceInfoList) {
                List<PlanExecuteRecord> executeRecordList = traceInfo.getExecuteRecordList();
                if (EmptyUtil.isEmpty(executeRecordList)) continue;
                this.mergeReleaseAmtToWriteRecord(executeRecordList);
            }
        }
    }

    private void mergeReleaseAmtToWriteRecord(List<PlanExecuteRecord> executeRecordList) {
        Map<PlanExecuteOpType, List<PlanExecuteRecord>> planExecuteOpTypeListMap = executeRecordList.stream().filter(p -> p.getExecuteStatus().isSuccessOrHolding()).filter(p -> p.getDeleteStatus() == false).collect(Collectors.groupingBy(PlanExecuteRecord::getExecuteOpType));
        List<PlanExecuteRecord> occupyPlanExecuteRecords = planExecuteOpTypeListMap.getOrDefault(PlanExecuteOpType.PRE_OCCUPY_WRITE, Collections.emptyList());
        occupyPlanExecuteRecords.forEach(p -> p.setUnReleaseAmt(p.getActAmount()));
        List occupyReleasePlanExecuteRecords = planExecuteOpTypeListMap.getOrDefault(PlanExecuteOpType.PRE_OCCUPY_RELEASE, Collections.emptyList());
        Map<Long, List<PlanExecuteRecord>> occupyReleasedRecordMap = occupyReleasePlanExecuteRecords.stream().collect(Collectors.groupingBy(PlanExecuteRecord::getOriginalRecordId));
        occupyPlanExecuteRecords.forEach(planExecuteRecord -> {
            BigDecimal releaseAmt = occupyReleasedRecordMap.getOrDefault(planExecuteRecord.getId(), Collections.emptyList()).stream().map(PlanExecuteRecord::getActAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            planExecuteRecord.setUnReleaseAmt(planExecuteRecord.getActAmount().add(releaseAmt));
        });
        List<PlanExecuteRecord> planExecuteRecords = planExecuteOpTypeListMap.getOrDefault(PlanExecuteOpType.WRITE, Collections.emptyList());
        planExecuteRecords.forEach(planExecuteRecord -> planExecuteRecord.setUnReleaseAmt(planExecuteRecord.getAclRemainAmt()));
    }

    private ControlAmountCache getControlAmountCache(Map<String, List<ControlTraceInfo>> controlTraceInfoMap) {
        ControlAmountCache controlAmountCache = new ControlAmountCache();
        for (List<ControlTraceInfo> controlTraceInfoList : controlTraceInfoMap.values()) {
            for (ControlTraceInfo controlTraceInfo : controlTraceInfoList) {
                controlAmountCache.init(controlTraceInfo);
            }
        }
        List<PlanExecuteRecord> planExecuteRecordList = controlTraceInfoMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(ControlTraceInfo::getExecuteRecordList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Predicate<PlanExecuteRecord> errorRecordFilter = this.getErrorRecordFilter(planExecuteRecordList);
        Consumer<PlanExecuteRecord> withoutHoldingConsumer = this.getWithoutHoldingConsumer(controlAmountCache, planExecuteRecordList);
        controlTraceInfoMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(ControlTraceInfo::getExecuteRecordList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).distinct().filter(errorRecordFilter::test).filter(planExecuteRecord -> planExecuteRecord.getExecuteStatus() == PlanExecuteStatus.WITHHOLDING).forEach(withoutHoldingConsumer::accept);
        return controlAmountCache;
    }

    private Predicate<PlanExecuteRecord> getErrorRecordFilter(List<PlanExecuteRecord> planExecuteRecordList) {
        if (EmptyUtil.isEmpty(planExecuteRecordList)) {
            return planExecuteRecord -> false;
        }
        Map planExecuteRecordMap = planExecuteRecordList.stream().collect(Collectors.toMap(PlanExecuteRecord::getId, Function.identity()));
        HashSet<Long> relateRecordIds = new HashSet<Long>(16);
        for (PlanExecuteRecord planExecuteRecord2 : planExecuteRecordList) {
            Object relateRecord;
            Long relateId = planExecuteRecord2.getRelateRecordId();
            while (Objects.nonNull(relateRecord = (PlanExecuteRecord)planExecuteRecordMap.get(relateId))) {
                relateId = ((PlanExecuteRecord)relateRecord).getRelateRecordId();
            }
            if (!EmptyUtil.isNoEmpty((Long)relateId)) continue;
            relateRecordIds.add(relateId);
        }
        if (EmptyUtil.isNoEmpty(relateRecordIds)) {
            List<PlanExecuteRecord> executeRecordList = this.controlRepository.loadPlanExecuteRecords(relateRecordIds);
            planExecuteRecordList.addAll(executeRecordList);
        }
        Map groupDbRouteKeyRecordIdMap = planExecuteRecordList.stream().filter(p -> p.getExecuteStatus().isHolding() && EmptyUtil.isEmpty((Long)p.getRelateRecordId())).map(p -> {
            if (EmptyUtil.isEmpty((String)p.getDbRouteKey())) {
                p.setDbRouteKey(DbRouteUtil.getDbRouteKey(p.getBillBizInfo().getEntityType()));
            }
            return p;
        }).collect(Collectors.groupingBy(PlanExecuteRecord::getDbRouteKey, Collectors.mapping(PlanExecuteRecord::getId, Collectors.toList())));
        ControlLocalMessageManager controlLocalMessageManager = ControlLocalMessageManager.getInstance();
        HashMap<Long, Boolean> booleanMap = new HashMap<Long, Boolean>(planExecuteRecordList.size());
        for (Map.Entry entry : groupDbRouteKeyRecordIdMap.entrySet()) {
            booleanMap.putAll(controlLocalMessageManager.exists((String)entry.getKey(), (List)entry.getValue()));
        }
        Map executeRecordMap = planExecuteRecordList.stream().collect(Collectors.toMap(PlanExecuteRecord::getId, Function.identity()));
        return p -> {
            PlanExecuteRecord planExecuteRecord;
            if (booleanMap.getOrDefault(p.getId(), Boolean.FALSE).booleanValue()) {
                return false;
            }
            Long relateRecordId = p.getRelateRecordId();
            if (EmptyUtil.isEmpty((Long)relateRecordId)) {
                return booleanMap.getOrDefault(p.getId(), Boolean.FALSE) == false;
            }
            while (Objects.nonNull(planExecuteRecord = (PlanExecuteRecord)executeRecordMap.get(relateRecordId))) {
                if (booleanMap.getOrDefault(planExecuteRecord.getId(), Boolean.FALSE).booleanValue()) {
                    return false;
                }
                relateRecordId = planExecuteRecord.getRelateRecordId();
            }
            return true;
        };
    }

    private Consumer<PlanExecuteRecord> getWithoutHoldingConsumer(ControlAmountCache controlAmountCache, List<PlanExecuteRecord> planExecuteRecordList) {
        Map planExecuteRecordMap = planExecuteRecordList.stream().collect(Collectors.toMap(PlanExecuteRecord::getId, Function.identity(), (a, b) -> a));
        Map<Long, List<PlanExecuteRecord>> relateRecordMap = planExecuteRecordList.stream().filter(p -> EmptyUtil.isNoEmpty((Long)p.getRelateRecordId())).collect(Collectors.groupingBy(PlanExecuteRecord::getRelateRecordId));
        return planExecuteRecord -> {
            planExecuteRecord.setDeleteStatus(Boolean.TRUE);
            planExecuteRecord.markUpdate();
            this.processRelateRecord(controlAmountCache, relateRecordMap, (PlanExecuteRecord)planExecuteRecord);
            this.doProcessFailHoldingAmt(controlAmountCache, (PlanExecuteRecord)planExecuteRecord, true);
            Long originalRecordId = planExecuteRecord.getOriginalRecordId();
            if (EmptyUtil.isNoEmpty((Long)originalRecordId)) {
                PlanExecuteRecord originalPlanExecuteRecord = (PlanExecuteRecord)planExecuteRecordMap.get(originalRecordId);
                this.processRelateRecord(controlAmountCache, relateRecordMap, originalPlanExecuteRecord);
            }
        };
    }

    private void doProcessFailHoldingAmt(ControlAmountCache controlAmountCache, PlanExecuteRecord planExecuteRecord, boolean negate) {
        List<RecordWithoutHoldingInfo> recordWithoutHoldingInfoList = planExecuteRecord.getRecordWithoutHoldingInfoList();
        if (EmptyUtil.isEmpty(recordWithoutHoldingInfoList)) {
            return;
        }
        for (RecordWithoutHoldingInfo info : recordWithoutHoldingInfoList) {
            BigDecimal holdLockAmt;
            BigDecimal holdActAmt = CommonUtils.getNegativeValueIfNeed(info.getHoldActAmt(), negate);
            if (EmptyUtil.isNoEmpty((BigDecimal)holdActAmt)) {
                controlAmountCache.updateActAmount(info.getReportDataId(), holdActAmt);
            }
            if (!EmptyUtil.isNoEmpty((BigDecimal)(holdLockAmt = CommonUtils.getNegativeValueIfNeed(info.getHoldLockAmt(), negate)))) continue;
            controlAmountCache.updateLockAmount(info.getReportDataId(), holdLockAmt);
        }
    }

    private void processRelateRecord(ControlAmountCache controlAmountCache, Map<Long, List<PlanExecuteRecord>> relateRecordMap, PlanExecuteRecord planExecuteRecord) {
        Long id = planExecuteRecord.getId();
        List relateRecordList = relateRecordMap.getOrDefault(id, Collections.emptyList());
        if (EmptyUtil.isEmpty(relateRecordList)) {
            return;
        }
        for (PlanExecuteRecord relateRecord : relateRecordList) {
            this.doProcessFailHoldingAmt(controlAmountCache, relateRecord, false);
            this.processRelateRecord(controlAmountCache, relateRecordMap, relateRecord);
        }
    }

    private Map<String, List<ControlTraceInfo>> getControlTraceInfo(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        HashMap<String, List<ControlTraceInfo>> controlTraceInfoMap = new HashMap<String, List<ControlTraceInfo>>(controlExecuteParamList.size());
        HashMap planExecuteRecordMap = new HashMap(16);
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            Long systemId = controlExecuteParam.getSystemId();
            String key = String.join((CharSequence)"#", billBizInfo.getBillId().toString(), systemId.toString());
            controlTraceInfoMap.computeIfAbsent(key, k -> {
                List<ControlTraceInfo> controlTraceInfos = this.controlTraceService.getControlTraceInfo(billBizInfo, systemId, this.getPlanExecuteRecordPredicate(controlContext, billBizInfo));
                this.distinctPlanExecuteRecord(controlTraceInfos, planExecuteRecordMap);
                return controlTraceInfos;
            });
        }
        return controlTraceInfoMap;
    }

    private void distinctPlanExecuteRecord(List<ControlTraceInfo> controlTraceInfos, Map<Long, PlanExecuteRecord> planExecuteRecordMap) {
        for (ControlTraceInfo controlTraceInfo : controlTraceInfos) {
            List<PlanExecuteRecord> executeRecordList = controlTraceInfo.getExecuteRecordList();
            if (EmptyUtil.isEmpty(executeRecordList)) continue;
            List<PlanExecuteRecord> planExecuteRecords = executeRecordList.stream().map(planExecuteRecord -> planExecuteRecordMap.computeIfAbsent(planExecuteRecord.getId(), k -> planExecuteRecord)).collect(Collectors.toList());
            controlTraceInfo.setExecuteRecordList(planExecuteRecords);
        }
    }

    private Predicate<PlanExecuteRecord> getPlanExecuteRecordPredicate(ControlContext controlContext, BillBizInfo billBizInfo) {
        return planExecuteRecord -> {
            Long controlTraceId = planExecuteRecord.getControlTraceId();
            Long currentTraceId = controlContext.getControlTraceId(billBizInfo.getBillId());
            if (!controlContext.isMultiSource(billBizInfo.getBillId()) && !Objects.equals(controlTraceId, currentTraceId)) {
                return false;
            }
            if (planExecuteRecord.getExecuteStatus() == PlanExecuteStatus.SUCCESSFUL) {
                return true;
            }
            return planExecuteRecord.getExecuteStatus() == PlanExecuteStatus.WITHHOLDING;
        };
    }

    @Override
    public int getOrder() {
        return 20;
    }
}

