/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillControlTraceIdInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceIdInfo;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IBillControlTraceIdInfoRepository;
import kd.tmc.fpm.business.mvc.service.control.trace.IBillTraceIdManager;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;

public class ControlTraceManager {
    private static final Log logger = LogFactory.getLog(ControlTraceManager.class);
    private IBillTraceIdManager billTraceIdManager;
    private IBillControlTraceIdInfoRepository billControlTraceIdInfoRepository = FpmServiceFactory.getBizService(IBillControlTraceIdInfoRepository.class);
    private Map<Long, BillControlTraceIdInfo> billControlTraceIdInfoMap = new HashMap<Long, BillControlTraceIdInfo>(256);

    private ControlTraceManager(IBillTraceIdManager billTraceIdManager) {
        this.billTraceIdManager = billTraceIdManager;
    }

    public static ControlTraceManager getInstance(IBillTraceIdManager billTraceIdManager, List<BillBizInfo> billBizInfoList) {
        ControlTraceManager controlTraceManager = new ControlTraceManager(billTraceIdManager);
        controlTraceManager.init(billBizInfoList);
        return controlTraceManager;
    }

    public Long getControlTraceId(Long billId) {
        BillControlTraceIdInfo controlTraceIdInfo = this.billControlTraceIdInfoMap.get(billId);
        if (controlTraceIdInfo == null) {
            throw new KDBizException("");
        }
        return controlTraceIdInfo.getControlTraceId();
    }

    private void init(List<BillBizInfo> billBizInfoList) {
        if (EmptyUtil.isEmpty(billBizInfoList)) {
            return;
        }
        Map billBizInfoMap = billBizInfoList.stream().collect(Collectors.toMap(BillBizInfo::getBillId, Function.identity(), (a, b) -> a));
        HashSet<Long> billIds = new HashSet<Long>(billBizInfoMap.keySet());
        logger.info("\u67e5\u8be2\u5df2\u521d\u59cb\u5316\u7684\u94fe\u8defid\uff1a{}", CommonUtils.getSubListForSize(new ArrayList<Long>(billIds), 10));
        List<BillControlTraceIdInfo> billControlTraceIdInfos = this.billControlTraceIdInfoRepository.loadByBusinessBillIds(billIds);
        Map controlTraceIdInfoMap = billControlTraceIdInfos.stream().collect(Collectors.toMap(BillControlTraceIdInfo::getBusinessBillId, Function.identity(), (a, b) -> a));
        this.billControlTraceIdInfoMap.putAll(controlTraceIdInfoMap);
        billIds.removeAll(controlTraceIdInfoMap.keySet());
        if (EmptyUtil.isEmpty(billIds)) {
            logger.info("\u6240\u6709\u94fe\u8defid\u90fd\u6709\u521d\u59cb\u5316\u3002\u3002\u3002\u3002");
            return;
        }
        List waitSearch = billBizInfoList.stream().filter(billBizInfo -> billIds.contains(billBizInfo.getBillId())).distinct().collect(Collectors.toList());
        logger.info("\u67e5\u8be2\u672a\u521d\u59cb\u5316\u7684\u94fe\u8defid\uff1a{}", CommonUtils.getSubListForSize(new ArrayList<Long>(billIds), 10));
        String dLockName = String.format("%s.%s", CacheKeyUtil.getAcctId(), "getControlTraceId");
        FpmOperateResult finalResult = CommonUtils.processInDLock(dLockName, 60000L, () -> {
            List<BillControlTraceIdInfo> reSearchBillControlTraceIdInfos = this.billControlTraceIdInfoRepository.loadByBusinessBillIds(billIds);
            Map reSearchControlTraceIdInfoMap = reSearchBillControlTraceIdInfos.stream().collect(Collectors.toMap(BillControlTraceIdInfo::getBusinessBillId, Function.identity(), (a, b) -> a));
            this.billControlTraceIdInfoMap.putAll(reSearchControlTraceIdInfoMap);
            billIds.removeAll(reSearchControlTraceIdInfoMap.keySet());
            waitSearch.removeIf(billBizInfo -> reSearchControlTraceIdInfoMap.containsKey(billBizInfo.getBillId()));
            if (EmptyUtil.isEmpty((Collection)billIds) || EmptyUtil.isEmpty((Collection)waitSearch)) {
                return FpmOperateResult.success();
            }
            ControlTraceIdInfo controlTraceIds = this.billTraceIdManager.getControlTraceIdInfo(waitSearch);
            List<ControlTraceIdInfo.BillControlTraceIdInfo> billControlTraceIdInfoList = controlTraceIds.getBillControlTraceIdInfoList();
            Deque<Long> idDeque = CommonUtils.batchGenerateIds(billControlTraceIdInfoList.size());
            ArrayList<BillControlTraceIdInfo> needSave = new ArrayList<BillControlTraceIdInfo>(billIds.size());
            for (ControlTraceIdInfo.BillControlTraceIdInfo info : billControlTraceIdInfoList) {
                BillBizInfo billBizInfo2 = info.getBillBizInfo();
                Long billId = billBizInfo2.getBillId();
                Long traceId = info.getControlTraceId();
                BillControlTraceIdInfo controlTraceIdInfo = new BillControlTraceIdInfo(idDeque.poll(), billId, billBizInfo2.getEntityType(), traceId);
                this.billControlTraceIdInfoMap.put(billId, controlTraceIdInfo);
                needSave.add(controlTraceIdInfo);
                FpmOperateResult result = CommonUtils.processInNewTransaction(() -> {
                    this.billControlTraceIdInfoRepository.saveAll(needSave);
                    return FpmOperateResult.success();
                });
                if (result.isSuccess()) continue;
                throw new KDBizException(String.join((CharSequence)",", result.getMessageList()));
            }
            return FpmOperateResult.success();
        });
        if (!finalResult.isSuccess()) {
            throw new KDBizException(String.join((CharSequence)",", finalResult.getMessageList()));
        }
    }
}

