/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodControlStrategyType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetailControlInfo;
import kd.tmc.fpm.business.domain.model.control.DetailControlInfo;
import kd.tmc.fpm.business.domain.model.control.DimValueListInfo;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.AbstractDecorationControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.helper.StringHelper;

public class DetailCurrentControlDataFillControlExecuteStrategy
extends AbstractDecorationControlExecuteStrategy {
    private ControlStrategyDetailControlInfo controlStrategyDetailControlInfo;

    public DetailCurrentControlDataFillControlExecuteStrategy(AbstractControlExecuteStrategy controlExecuteStrategy) {
        super(controlExecuteStrategy);
        this.controlStrategyDetailControlInfo = this.controlContext.getControlStrategyDetailControlInfo();
    }

    @Override
    public FpmOperateResult<ControlResult> validate() {
        PlanExecuteOpType planExecuteOpType = this.controlContext.getPlanExecuteOpType();
        if (planExecuteOpType.isOccupy() || planExecuteOpType.isOccupyCancel()) {
            this.detailCurrentControlDataFillIfNeed();
        }
        return super.validate();
    }

    private void detailCurrentControlDataFillIfNeed() {
        logger.info("\u9884\u5360\u6216\u53d6\u6d88\u9884\u5360\uff0c\u5982\u679c\u5339\u914d\u5230\u4e86\u660e\u7ec6\u8868\u4e2d\u7684\u660e\u7ec6\u7ef4\u5ea6\uff0c\u5e76\u4e14\u63a7\u5236\u7b56\u7565\u6309\u5f53\u671f\u63a7\uff0c\u586b\u5145\u5f53\u671f\u6570\u636e\u3002\u3002\u3002\u3002");
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        Map dimensionMap = this.controlContext.getAllFundPlanSystem().stream().map(FundPlanSystem::getDimList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a));
        Set reportPeriodIds = controlExecuteParamList.stream().map(ControlExecuteParam::getReportData).map(ReportData::getReportPeriodId).collect(Collectors.toSet());
        Map<Long, PeriodMember> periodMemberMap = dimensionMap.values().stream().filter(dimension -> dimension.getDimType().isPeriodDim()).map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).filter(dimMember -> reportPeriodIds.contains(dimMember.getId())).map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        DimValueListInfo dimValueListInfo = new DimValueListInfo();
        HashSet<Long> reportIds = new HashSet<Long>(10);
        ArrayList<ControlExecuteParam> needQueryList = new ArrayList<ControlExecuteParam>(controlExecuteParamList.size());
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            PeriodMember periodMember;
            List<DimMember> children;
            BitMap<Long, Long> detailDimBitMap;
            Long one;
            Set<Long> detailControlDimIds;
            PeriodControlStrategyType periodControlStrategyType;
            if (!controlExecuteParam.matchedDetail() || !controlExecuteParam.isAccurateMatch()) continue;
            Long reportOrgId = controlExecuteParam.getReportOrgId();
            Long reportTypeId = controlExecuteParam.getReportTypeId();
            ControlStrategy controlStrategy = this.controlContext.getControlStrategy(controlExecuteParam.getSystemId(), reportTypeId, reportOrgId);
            if (Objects.isNull(controlStrategy) || (periodControlStrategyType = controlStrategy.getPeriodControlStrategyType()) == PeriodControlStrategyType.DETAIL_PERIOD_CONTROL) continue;
            ReportData reportData = controlExecuteParam.getReportData();
            Long subjectId = controlExecuteParam.getSubjectId();
            DetailControlInfo detailControlInfo = this.controlStrategyDetailControlInfo.getDetailControlInfo(controlExecuteParam);
            if (EmptyUtil.isEmpty((Object)detailControlInfo) || EmptyUtil.isEmpty(detailControlDimIds = detailControlInfo.getDetailDimIds(subjectId)) || EmptyUtil.isEmpty((Long)(one = (detailDimBitMap = controlExecuteParam.getDetailDimBitMap()).findOne(detailControlDimIds))) || EmptyUtil.isEmpty(children = (periodMember = periodMemberMap.get(reportData.getReportPeriodId())).getChildren())) continue;
            Map<TemplateDim, Object> detailMatchInfo = controlExecuteParam.getDetailMatchInfo();
            Map<Long, Object> detailValueMap = detailMatchInfo.entrySet().stream().collect(Collectors.toMap(entry -> ((TemplateDim)entry.getKey()).getDimensionId(), Map.Entry::getValue));
            detailControlDimIds.forEach(detailDimId -> dimValueListInfo.addDimensionValue((Dimension)dimensionMap.get(detailDimId), ((Dimension)dimensionMap.get(detailDimId)).getDetailDimType().isExtraField() ? StringHelper.getStringValue(detailValueMap.get(detailDimId)) : detailValueMap.get(detailDimId)));
            DimensionInfoBean dimensionInfoBean = controlExecuteParam.getDimensionInfoBean();
            List dimensionIdList = dimensionInfoBean.getDimensionIdList();
            List memberIdList = dimensionInfoBean.getMemberIdList();
            Set<Long> optionalDimIds = detailControlInfo.getOptionalDimIds(subjectId);
            for (int i = 0; i < dimensionIdList.size(); ++i) {
                Dimension dimension2 = (Dimension)dimensionMap.get(dimensionIdList.get(i));
                DimensionType dimType = dimension2.getDimType();
                if (dimType.isPeriodDim()) {
                    dimValueListInfo.addDimensionListValue(dimension2, children.stream().map(DimMember::getId).collect(Collectors.toList()));
                    continue;
                }
                if (dimType.isSystemDim()) {
                    dimValueListInfo.addDimensionValue(dimension2, memberIdList.get(i));
                    continue;
                }
                if (!optionalDimIds.contains(dimension2.getId())) continue;
                dimValueListInfo.addDimensionValue(dimension2, memberIdList.get(i));
            }
            needQueryList.add(controlExecuteParam);
            reportIds.add(reportData.getReportId());
        }
        this.doQueryAndFill(needQueryList, reportIds, dimValueListInfo, periodMemberMap);
        logger.info("\u586b\u5145\u5f53\u671f\u6570\u636e\u5b8c\u6bd5....");
    }

    private void doQueryAndFill(List<ControlExecuteParam> needQueryList, Set<Long> reportIds, DimValueListInfo dimValueListInfo, Map<Long, PeriodMember> periodMemberMap) {
        if (dimValueListInfo.isEmpty()) {
            return;
        }
        IReportDataQueryService bizService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
        List<ReportData> reportDataList = bizService.queryReportDataForAllSystem(t -> {
            t.setDimValList(dimValueListInfo.getDimValueList());
            t.setDimIdList(dimValueListInfo.getDimensionList());
            t.setReportIdS(new ArrayList<Long>(reportIds));
        });
        logger.info("\u5b58\u5728\u6309\u660e\u7ec6\u7ef4\u5ea6\u63a7\uff0c\u5e76\u4e14\u6309\u5f53\u671f\u63a7\u7684\u6570\u636e\uff0c\u67e5\u8be2\u5230\u7684\u6240\u6709\u5f53\u671f\u6570\u636e\u6761\u6570\uff1a{}", (Object)reportDataList.size());
        Map<Long, List<ReportData>> systemReportDataMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getSystemId));
        HashMap<Long, QueryIndexInfo> queryIndexInfoMap = new HashMap<Long, QueryIndexInfo>(systemReportDataMap.size());
        Deque<Long> idDeque = CommonUtils.batchGenerateIds(needQueryList.size());
        for (ControlExecuteParam controlExecuteParam : needQueryList) {
            Long systemId = controlExecuteParam.getSystemId();
            List<ReportData> systemReportDataList = systemReportDataMap.get(systemId);
            if (EmptyUtil.isEmpty(systemReportDataList)) continue;
            DimensionInfoBean dimensionInfoBean = controlExecuteParam.getDimensionInfoBean().copy();
            ReportData reportData = controlExecuteParam.getReportData();
            PeriodMember periodMember = periodMemberMap.get(reportData.getReportPeriodId());
            dimensionInfoBean.removeDimensionInfo(periodMember.getDimensionId());
            DetailControlInfo detailControlInfo = this.controlStrategyDetailControlInfo.getDetailControlInfo(controlExecuteParam);
            Long subjectId = controlExecuteParam.getSubjectId();
            Set<Long> optionalDimIds = detailControlInfo.getOptionalDimIds(subjectId);
            List dimensionIdList = dimensionInfoBean.getDimensionIdList();
            if (dimensionIdList.size() > 4) {
                List<Long> waitDelete = dimensionIdList.subList(4, dimensionIdList.size()).stream().filter(id -> !optionalDimIds.contains(id)).collect(Collectors.toList());
                waitDelete.forEach(arg_0 -> ((DimensionInfoBean)dimensionInfoBean).removeDimensionInfo(arg_0));
            }
            QueryIndexInfo queryIndexInfo = queryIndexInfoMap.computeIfAbsent(systemId, k -> QueryIndexInfoMapGenerator.buildReportDataIndex(systemReportDataList, this.controlContext.getSystem(systemId)));
            List<DimMember> children = periodMember.getChildren();
            ReportData result = new ReportData(reportData);
            result.clearAmt();
            result.setId(idDeque.poll());
            int count = 0;
            for (DimMember dimMember : children) {
                dimensionInfoBean.replaceValueIfContains(dimMember.getDimensionId(), (Object)dimMember.getId());
                List list = queryIndexInfo.findList(dimensionInfoBean);
                if (EmptyUtil.isEmpty(list)) continue;
                Map<Long, Object> detailDimValueMap = DimensionInfoHelper.getDetailDimValueMap(reportData, detailControlInfo.getDetailDimIds(subjectId));
                Predicate<ReportData> predicate = DimensionInfoHelper.getDetailFieldMatchFilter(detailDimValueMap);
                List<ReportData> dataList = list.stream().filter(predicate).collect(Collectors.toList());
                if (EmptyUtil.isEmpty(dataList)) continue;
                count += dataList.size();
                dataList.forEach(result::add);
                result.setSourceIdList(dataList.stream().map(ReportData::getId).distinct().collect(Collectors.toList()));
            }
            logger.info("\u4e1a\u52a1\u5355\u636e\uff1a{}\uff0c\u4f53\u7cfb\uff1a{}\uff0c\u5339\u914d\u5230\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a{}\uff0c\u6309\u660e\u7ec6\u7ef4\u5ea6\uff1a{}\u63a7\uff0c\u751f\u6210\u7684\u5927\u671f\u95f4\u6570\u636eid\uff1a{}\uff0c\u8ba1\u5212\u989d\u5ea6\u603b\u91d1\u989d\uff1a{}\uff0c\u7b26\u5408\u6761\u4ef6\u7684\u603b\u8bb0\u5f55\uff1a{}", new Object[]{controlExecuteParam.getBillBizInfo().getBillNo(), this.controlContext.getSystem(systemId).getName(), controlExecuteParam.getDimensionInfoBean(), result.getId(), result.getPlanAmt(), count});
            List<TemplateDim> dimList = result.getDimList();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                if (!templateDim.getDimType().isPeriodDim()) continue;
                result.getDimValList().set(i, result.getReportPeriodId());
                break;
            }
            BitMap<Long, Long> detailDimBitMap = controlExecuteParam.getDetailDimBitMap();
            Set<Long> detailDimIds = detailDimBitMap.getKeys(reportData.getId());
            detailDimBitMap.addValue(detailDimIds, result.getId());
            controlExecuteParam.getOptionalMaybeNeedReportDataList().add(result);
            if (this.controlContext.getPlanExecuteOpType() != PlanExecuteOpType.PRE_OCCUPY_DELETE) continue;
            controlExecuteParam.getRelateReportDataList().add(result);
        }
    }
}

