/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtDetailInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecordMore;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.service.IEvaluateAmtBizService;
import kd.tmc.fpm.business.mvc.service.IEvaluateAmtManageService;
import kd.tmc.fpm.business.mvc.service.dto.EvalDetailParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.EvalLoadParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.WaitApprovedAmountAmtDTO;
import kd.tmc.fpm.business.mvc.service.dto.WaitApprovedAmountAmtInfoResultDTO;
import kd.tmc.fpm.business.mvc.service.impl.EvaluateAmtBizServiceImpl;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class EvaluateAmtManageServiceImpl
implements IEvaluateAmtManageService {
    private IEvaluateAmtBizService evaluateAmtBizService = new EvaluateAmtBizServiceImpl();
    private ISumPlanRepository sumPlanRepository = new SumPlanRepository();
    private ICustomDimSeqService iCustomDimSeqService = FpmServiceFactory.getBizService(ICustomDimSeqService.class);

    @Override
    public FpmOperateResult<ApprovedAmountRecordMore> load(EvalLoadParamDTO evalLoadParamDTO) {
        ApprovedAmountRecordMore approvedAmountRecordMore = this.evaluateAmtBizService.load(evalLoadParamDTO);
        if (EmptyUtil.isEmpty((Object)approvedAmountRecordMore)) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u91d1\u989d\u6838\u5b9a\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u9009\u4e2d\u7684\u5355\u5143\u683c\u6ca1\u6709\u5bf9\u5e94\u7684\u6c47\u603b\u7f16\u5236\u6570\u636e", (String)"EvaluateAmtManageServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return FpmOperateResult.success(approvedAmountRecordMore);
    }

    @Override
    public FpmOperateResult<List<WaitApprovedAmountAmtInfoResultDTO>> loadWaitApprovedAmountAmtInfo(WaitApprovedAmountAmtDTO waitApprovedAmountAmtDTO) {
        Map<Long, ApprovedAmountAmtDetailInfo> detailInfoMap = this.getExistsLongApprovedAmountAmtDetailInfoMap(waitApprovedAmountAmtDTO.getSumRecordId(), waitApprovedAmountAmtDTO.getApprovalId(), Boolean.FALSE);
        SumPlanRecord sumPlanRecord = this.sumPlanRepository.loadSumPlanRecord(waitApprovedAmountAmtDTO.getSumRecordId());
        if (sumPlanRecord.getReportStatus() == ReportStatus.ENABLE) {
            waitApprovedAmountAmtDTO.setEnable(true);
            waitApprovedAmountAmtDTO.setAllReportDataIds(detailInfoMap.keySet());
        }
        List<WaitApprovedAmountAmtInfoResultDTO> resultDTOList = this.evaluateAmtBizService.loadWaitApprovedAmountAmtInfo(waitApprovedAmountAmtDTO);
        this.addSubApprovalRecordToMapIfNotApproved(waitApprovedAmountAmtDTO.getSumRecordId(), detailInfoMap, resultDTOList);
        this.updateInfo(detailInfoMap, resultDTOList);
        Map<Long, Integer> customDimSeqMap = this.iCustomDimSeqService.loadCustomDimSeqMap(sumPlanRecord.getSystemId());
        resultDTOList.forEach(dto -> dto.setCustomDimSeqMap(customDimSeqMap));
        return FpmOperateResult.success(resultDTOList);
    }

    @Override
    public FpmOperateResult save(ApprovedAmountRecord approvedAmountRecord) {
        return this.evaluateAmtBizService.save(approvedAmountRecord);
    }

    @Override
    public FpmOperateResult<List<WaitApprovedAmountAmtInfoResultDTO>> loadWaitApprovedAmountDetailInfo(Long sumRecordId, Long sumReportDataId, List<EvalDetailParamDTO> evalDetailParamDTOs) {
        Map<Long, ApprovedAmountAmtDetailInfo> detailInfoMap = this.getExistsLongApprovedAmountAmtDetailInfoMap(sumRecordId, sumReportDataId, Boolean.TRUE);
        SumPlanRecord sumPlanRecord = this.sumPlanRepository.loadSumPlanRecord(sumRecordId);
        List<WaitApprovedAmountAmtInfoResultDTO> waitApprovedAmountAmtInfoResultDTOS = this.evaluateAmtBizService.loadWaitApprovedAmountDetailInfo(evalDetailParamDTOs, sumPlanRecord.getReportStatus() == ReportStatus.ENABLE);
        this.addSubApprovalRecordToMapIfNotApproved(sumRecordId, detailInfoMap, waitApprovedAmountAmtInfoResultDTOS);
        this.updateInfo(detailInfoMap, waitApprovedAmountAmtInfoResultDTOS);
        Map<Long, Integer> customDimSeqMap = this.iCustomDimSeqService.loadCustomDimSeqMap(sumPlanRecord.getSystemId());
        waitApprovedAmountAmtInfoResultDTOS.forEach(dto -> dto.setCustomDimSeqMap(customDimSeqMap));
        return FpmOperateResult.success(waitApprovedAmountAmtInfoResultDTOS);
    }

    private Map<Long, ApprovedAmountAmtDetailInfo> getExistsLongApprovedAmountAmtDetailInfoMap(Long sumRecordId, Long approvalId, Boolean isDetail) {
        List<ApprovedAmountAmtDetailInfo> load = this.evaluateAmtBizService.load(sumRecordId, approvalId, isDetail);
        return load.stream().collect(Collectors.toMap(ApprovedAmountAmtDetailInfo::getReportDataId, Function.identity()));
    }

    private void updateInfo(Map<Long, ApprovedAmountAmtDetailInfo> detailInfoMap, List<WaitApprovedAmountAmtInfoResultDTO> resultDTOList) {
        for (WaitApprovedAmountAmtInfoResultDTO info : resultDTOList) {
            this.updateDetailInfo(detailInfoMap, info);
            List<WaitApprovedAmountAmtInfoResultDTO> children = info.getChildren();
            if (EmptyUtil.isEmpty(children)) continue;
            for (int i = 0; i < children.size(); ++i) {
                WaitApprovedAmountAmtInfoResultDTO child = children.get(i);
                BigDecimal bigDecimal = this.updateDetailInfo(detailInfoMap, child);
            }
        }
    }

    private BigDecimal updateDetailInfo(Map<Long, ApprovedAmountAmtDetailInfo> detailInfoMap, WaitApprovedAmountAmtInfoResultDTO info) {
        Long id = info.getReportData().getId();
        ApprovedAmountAmtDetailInfo approvedAmountAmtDetailInfo = detailInfoMap.get(id);
        if (EmptyUtil.isEmpty((Object)approvedAmountAmtDetailInfo)) {
            info.setOriginalEvaluateAmt(info.getReportData().getOriginalPlanAmt());
            return BigDecimal.ZERO;
        }
        BigDecimal evaluateAmt = info.getEvaluateAmt();
        info.setEvaluateAmt(approvedAmountAmtDetailInfo.getApprovedAmt());
        info.setEvalAdjustReason(approvedAmountAmtDetailInfo.getEvalAdjustReason());
        info.setFillUser(approvedAmountAmtDetailInfo.getFillUser());
        info.setOriginalEvaluateAmt(approvedAmountAmtDetailInfo.getOriginalApprovedAmt());
        return evaluateAmt;
    }

    private void addSubApprovalRecordToMapIfNotApproved(Long sumRecordId, Map<Long, ApprovedAmountAmtDetailInfo> detailInfoMap, List<WaitApprovedAmountAmtInfoResultDTO> waitApprovedAmountAmtInfoResultDTOS) {
        ArrayList<Long> downReportDataIdList = new ArrayList<Long>(32);
        for (WaitApprovedAmountAmtInfoResultDTO resultDTO : waitApprovedAmountAmtInfoResultDTOS) {
            List<WaitApprovedAmountAmtInfoResultDTO> children;
            ReportData reportData = resultDTO.getReportData();
            Long reportDataId = reportData.getId();
            if (!detailInfoMap.containsKey(reportDataId)) {
                downReportDataIdList.add(reportDataId);
            }
            if (EmptyUtil.isEmpty(children = resultDTO.getChildren())) continue;
            for (WaitApprovedAmountAmtInfoResultDTO child : children) {
                ReportData childRd = child.getReportData();
                Long childRdId = childRd.getId();
                if (detailInfoMap.containsKey(childRdId)) continue;
                downReportDataIdList.add(childRdId);
            }
        }
        List<ApprovedAmountAmtDetailInfo> detailInfoList = this.evaluateAmtBizService.queryDirectionDownLevel(sumRecordId, downReportDataIdList);
        Map amtDetailInfoMap = detailInfoList.stream().map(t -> {
            t.setEvalAdjustReason("");
            t.setFillUser(0L);
            t.setOriginalApprovedAmt(t.getApprovedAmt());
            return t;
        }).collect(Collectors.toMap(ApprovedAmountAmtDetailInfo::getReportDataId, Function.identity()));
        detailInfoMap.putAll(amtDetailInfoMap);
    }
}

