/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.SourceBillType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.execbiasanalys.ExecBiasAnalys;
import kd.tmc.fpm.business.domain.model.report.MetricHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IExecBiasAnalysService;
import kd.tmc.fpm.business.domain.service.impl.ExecBiasAnalysService;
import kd.tmc.fpm.business.mvc.repository.IExecBiasAnalysRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ExecBiasAnalysRepository;
import kd.tmc.fpm.business.mvc.service.IExecBiasAnalysBizService;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class ExecBiasAnalysBizServiceImpl
implements IExecBiasAnalysBizService {
    private static Log logger = LogFactory.getLog(ExecBiasAnalysBizServiceImpl.class);
    private IExecBiasAnalysRepository repository = new ExecBiasAnalysRepository();
    private IReportBizService reportBizService = new ReportBizService();
    private ISumPlanBizService sumPlanBizService = new SumPlanBizServiceImpl();
    private IExecBiasAnalysService service = new ExecBiasAnalysService();
    private IReportRepository reportRepository = FpmServiceFactory.getBizService(IReportRepository.class);

    @Override
    public FpmOperateResult<ExecBiasAnalys> load(Long id) {
        ExecBiasAnalys execBiasAnalys = this.repository.load(id);
        Long reportId = execBiasAnalys.getSourcebill();
        if (execBiasAnalys.getSourceBillType() == SourceBillType.REPORT) {
            FpmOperateResult<Report> reportFpmOperateResult = this.reportBizService.loadReportNotContRefData(reportId, null);
            if (!reportFpmOperateResult.isSuccess()) {
                return FpmOperateResult.error(reportFpmOperateResult.getMessageList());
            }
            Report report = reportFpmOperateResult.getData();
            this.service.transfer(report, null);
            execBiasAnalys.setReport(report);
        } else if (SourceBillType.SUMPLAN == execBiasAnalys.getSourceBillType()) {
            FpmOperateResult<SumPlanRecord> sumPlanFpmOperateResult = this.sumPlanBizService.loadWithReport(reportId);
            if (!sumPlanFpmOperateResult.isSuccess()) {
                return FpmOperateResult.error(sumPlanFpmOperateResult.getMessageList());
            }
            SumPlanRecord sumPlanRecord = sumPlanFpmOperateResult.getData();
            SumPlanReport sumPlanReport = sumPlanRecord.getSumPlanReportList().get(0);
            this.service.transfer(sumPlanReport, null);
            execBiasAnalys.setSumPlanReportList(sumPlanRecord.getSumPlanReportList());
        }
        return FpmOperateResult.success(execBiasAnalys);
    }

    @Override
    public FpmOperateResult<Report> loadReport(Long reportId, FundPlanSystem system, MetricHeader metricHeader) {
        FpmOperateResult<Report> reportFpmOperateResult = this.reportBizService.loadReportNotContRefData(reportId, null);
        if (!reportFpmOperateResult.isSuccess()) {
            return FpmOperateResult.error(reportFpmOperateResult.getMessageList());
        }
        Report report = reportFpmOperateResult.getData();
        report.setReferencePeriodType(null);
        report.setReferencePeriodMember(null);
        if (report.getPeriodMemberList().size() > 1) {
            report.setPeriodMemberList(Collections.singletonList(report.getCurrentReportPeriod()));
        }
        List<Long> metricMemberIds = metricHeader != null && CollectionUtils.isNotEmpty(metricHeader.getMetricMemberIds()) ? metricHeader.getMetricMemberIds() : this.defaultMetricMemberIds(report.getSystemId());
        MetricValueUtils.splitMetric(report, metricMemberIds);
        this.service.transfer(report, metricMemberIds);
        return FpmOperateResult.success(report);
    }

    @Override
    public void transfer(Report report, List<Long> metricMemberIds) {
        this.service.transfer(report, metricMemberIds);
    }

    @Override
    public List<Long> defaultMetricMemberIds(Long systemId) {
        QFilter filter = new QFilter("bodysystem", "=", (Object)systemId);
        filter.and("dimtype", "=", (Object)DimensionType.METRIC.getNumber());
        filter.and("metrictype", "in", Arrays.asList(MetricMemberTypeEnum.BASE.getValue(), MetricMemberTypeEnum.ANALYSE.getValue()));
        filter.and("metricpresettype", "in", Arrays.asList(TemplateMetricType.PLANAMT.getCode(), TemplateMetricType.ACTMAT.getCode(), TemplateMetricType.EXECUTEAMT.getCode()));
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] metricMembers = TmcDataServiceHelper.load((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{filter});
        return Arrays.stream(metricMembers).map(c -> c.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public FpmOperateResult<Report> loadReport(Long reportId, MetricHeader metricHeader) {
        return this.reportBizService.loadReportNotContRefData(reportId, true, metricHeader);
    }

    @Override
    public FpmOperateResult<Void> delete(Report report) {
        this.reportRepository.deleteAuxDataList(report);
        return FpmOperateResult.success();
    }

    @Override
    public FpmOperateResult<SumPlanRecord> loadSumReport(Long reportId, FundPlanSystem system, SumPlanHeader sumPlanHeader) {
        FpmOperateResult<SumPlanRecord> sumPlanFpmOperateResult = this.sumPlanBizService.loadWithOutReference(reportId, system, sumPlanHeader);
        if (!sumPlanFpmOperateResult.isSuccess()) {
            return FpmOperateResult.error(sumPlanFpmOperateResult.getMessageList());
        }
        SumPlanReport sumPlanReport = sumPlanFpmOperateResult.getData().getSumPlanReportList().get(0);
        sumPlanReport.setReferencePeriodMember(null);
        sumPlanReport.setReferencePeriodType(null);
        if (sumPlanReport.getPeriodMemberList().size() > 1) {
            sumPlanReport.setPeriodMemberList(Collections.singletonList(sumPlanReport.getCurrentReportPeriod()));
        }
        List<Long> metricMemberIds = sumPlanHeader != null && CollectionUtils.isNotEmpty(sumPlanHeader.getMetricMemberIds()) ? sumPlanHeader.getMetricMemberIds() : this.defaultMetricMemberIds(sumPlanReport.getSystemId());
        MetricValueUtils.splitMetric(sumPlanReport, metricMemberIds);
        this.service.transfer(sumPlanReport, metricMemberIds);
        return FpmOperateResult.success(sumPlanFpmOperateResult.getData());
    }
}

