/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.converter.PlanExecuteRecordConverter;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.common.enums.ExecutePlanOpTypeEnum;

public class FpmPlanExecuteRecordDataUpgradeRPCServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(FpmPlanExecuteRecordDataUpgradeRPCServiceImpl.class);
    private static final int DEFAULT_PAGE_SIZE = 800;

    @Override
    public void updateData() {
        QFilter qFilter;
        QFilter pageFilter;
        DynamicObjectCollection execPlanIdDyColl;
        int historyDataSize = 0;
        int upgradeDataSize = 0;
        Long lastId = 0L;
        while (!EmptyUtil.isEmpty((DynamicObjectCollection)(execPlanIdDyColl = QueryServiceHelper.query((String)"fpm_executeplan", (String)"id", (QFilter[])new QFilter[]{pageFilter = new QFilter("id", ">", (Object)lastId), qFilter = QFilter.isNull((String)String.join((CharSequence)".", "hold_entryentity", "id"))}, (String)"id", (int)800)))) {
            lastId = ((DynamicObject)execPlanIdDyColl.get(execPlanIdDyColl.size() - 1)).getLong("id");
            historyDataSize += execPlanIdDyColl.size();
            DynamicObject[] execPlanDOArr = TmcDataServiceHelper.load((Object[])execPlanIdDyColl.stream().map(dy -> dy.getLong("id")).toArray(Long[]::new), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_executeplan"));
            ArrayList<DynamicObject> waitSaveData = new ArrayList<DynamicObject>(execPlanDOArr.length);
            for (DynamicObject execPlanDO : execPlanDOArr) {
                DynamicObjectCollection holdEntryColl = execPlanDO.getDynamicObjectCollection("hold_entryentity");
                if (!EmptyUtil.isEmpty((DynamicObjectCollection)holdEntryColl) || !this.initialOldDataHoldEntry(execPlanDO)) continue;
                waitSaveData.add(execPlanDO);
            }
            if (!EmptyUtil.isNoEmpty(waitSaveData)) continue;
            SaveServiceHelper.save((DynamicObject[])waitSaveData.toArray(new DynamicObject[0]));
            upgradeDataSize += waitSaveData.size();
        }
        logger.info("\u6267\u884c\u8ba1\u5212\u8bb0\u5f55-\u5386\u53f2\u6570\u636e\u5347\u7ea7, \u5171\u5904\u7406\u5386\u53f2\u6570\u636e[{}]\u6761, \u6570\u636e\u5347\u7ea7[{}]\u6761", (Object)historyDataSize, (Object)upgradeDataSize);
    }

    private boolean initialOldDataHoldEntry(DynamicObject execPlanDO) {
        PlanExecuteRecord planExecuteRecord = PlanExecuteRecordConverter.converterToExecuteRecord(execPlanDO);
        if (EmptyUtil.isEmpty(planExecuteRecord.getMatchedReportDataList())) {
            return false;
        }
        DynamicObjectCollection holdEntryColl = execPlanDO.getDynamicObjectCollection("hold_entryentity");
        for (ReportData reportData : planExecuteRecord.getMatchedReportDataList()) {
            DynamicObject holdEntryRowDO = holdEntryColl.addNew();
            holdEntryRowDO.set("hold_reportdataid", (Object)reportData.getId());
            ExecutePlanOpTypeEnum executeOpType = ExecutePlanOpTypeEnum.get((String)execPlanDO.getString("planexecuteop"));
            boolean isPreemptedExecuteOp = ExecutePlanOpTypeEnum.isPreemptedExecuteOp((ExecutePlanOpTypeEnum)executeOpType);
            BigDecimal holdLockAmt = isPreemptedExecuteOp ? execPlanDO.getBigDecimal("realamt") : BigDecimal.ZERO;
            holdEntryRowDO.set("hold_holdlockamt", (Object)reportData.getReportActAmount(holdLockAmt));
            boolean isWriteExecuteOp = ExecutePlanOpTypeEnum.isWriteExecuteOp((ExecutePlanOpTypeEnum)executeOpType);
            BigDecimal holdActAmt = isWriteExecuteOp ? execPlanDO.getBigDecimal("realamt") : BigDecimal.ZERO;
            holdEntryRowDO.set("hold_holdactamt", (Object)reportData.getReportActAmount(holdActAmt));
        }
        return true;
    }
}

