/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.common.enums.DiffDirectionEnum;

public class InnerRecordDataUpgradeServiceImpl
implements IUpgradeService {
    @Override
    public void updateData() {
        Object[] internalRecords = BusinessDataServiceHelper.load((String)"fpm_innercancelrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
        if (EmptyUtil.isNoEmpty((Object[])internalRecords)) {
            Set<Object> ids = Arrays.stream(internalRecords).map(o -> Long.valueOf(o.getPkValue().toString())).collect(Collectors.toSet());
            internalRecords = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_innercancelrecord"));
            ArrayList<Object> waitSaveDatas = new ArrayList<Object>(internalRecords.length);
            for (Object internalRecord : internalRecords) {
                DynamicObjectCollection totalEntrys = internalRecord.getDynamicObjectCollection("totalentry");
                DynamicObjectCollection detailEntrys = internalRecord.getDynamicObjectCollection("entryentity");
                String batchNumber = "OS-001";
                if (detailEntrys.size() <= 0 || totalEntrys.size() != 0) continue;
                BigDecimal inflowAmt = BigDecimal.ZERO;
                BigDecimal outflowAmt = BigDecimal.ZERO;
                String direction = null;
                for (DynamicObject detailEntry : detailEntrys) {
                    detailEntry.set("offsetbatchnumber", (Object)batchNumber);
                    DynamicObject subject = detailEntry.getDynamicObject("subjectid");
                    if (EmptyUtil.isEmpty((DynamicObject)subject)) continue;
                    if (subject.getString("flow").equals("B")) {
                        inflowAmt = inflowAmt.add(detailEntry.getBigDecimal("balanceamt"));
                    } else if (subject.getString("flow").equals("C")) {
                        outflowAmt = outflowAmt.add(detailEntry.getBigDecimal("balanceamt"));
                    }
                    if (inflowAmt.compareTo(BigDecimal.ZERO) > 0) {
                        direction = DiffDirectionEnum.INFLOW.getDirection();
                        continue;
                    }
                    if (inflowAmt.compareTo(BigDecimal.ZERO) >= 0) continue;
                    direction = DiffDirectionEnum.OUTFLOW.getDirection();
                }
                DynamicObject totalEntry = totalEntrys.addNew();
                totalEntry.set("entry_offset_batch_number", (Object)batchNumber);
                totalEntry.set("entry_offset_detail_num", (Object)detailEntrys.size());
                totalEntry.set("entry_diff_direction", direction);
                totalEntry.set("entry_offset_amt_sum", (Object)internalRecord.getBigDecimal("sumcancelamount"));
                totalEntry.set("entry_diff_amt_sum", (Object)internalRecord.getBigDecimal("sumdiffamount"));
                waitSaveDatas.add(internalRecord);
            }
            if (EmptyUtil.isNoEmpty(waitSaveDatas)) {
                SaveServiceHelper.save((DynamicObject[])waitSaveDatas.toArray(new DynamicObject[0]));
            }
        }
    }
}

