/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.BillDimensionMatchInfo;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class MatchFieldRelateMergeKeyPostProcessor
implements IControlExecuteParamPostProcessor {
    public static final Log logger = LogFactory.getLog(MatchFieldRelateMergeKeyPostProcessor.class);

    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        logger.info("filterMatchField  start\u3002\u3002\u3002\u3002");
        Iterator<ControlExecuteParam> iterator = controlExecuteParamList.iterator();
        HashMap<Long, Set> systemSkipDims = new HashMap<Long, Set>(8);
        HashMap<String, String> signMap = new HashMap<String, String>(256);
        while (iterator.hasNext()) {
            ControlExecuteParam next = iterator.next();
            BillBizInfo billBizInfo = next.getBillBizInfo();
            if (Objects.isNull(billBizInfo)) {
                iterator.remove();
                continue;
            }
            List<BizProps> bizProps = billBizInfo.getBizProps();
            if (EmptyUtil.isEmpty(bizProps)) {
                iterator.remove();
                continue;
            }
            List<BizProps> bizPropsList = bizProps.stream().filter(bizProp -> Objects.nonNull(bizProp.getBizProp())).peek(bizProp -> {
                if (Objects.isNull(bizProp.getValue())) {
                    bizProp.setValue("");
                }
            }).collect(Collectors.toList());
            billBizInfo.setBizProps(bizPropsList);
            BillDimensionMatchInfo billDimensionMatchInfo = next.getBillDimensionMatchInfo();
            Long systemId = next.getSystemId();
            FundPlanSystem system = controlContext.getSystem(systemId);
            if (Objects.isNull(system)) {
                iterator.remove();
                continue;
            }
            Set skipDims = systemSkipDims.computeIfAbsent(systemId, k -> {
                HashSet<Long> skip = new HashSet<Long>(4);
                Dimension dimension = system.getDetailDimensionByDetailType(DetailDimType.PLAN_AMOUNT);
                skip.add(dimension.getId());
                return skip;
            });
            skipDims.forEach(billDimensionMatchInfo::addSkipDimId);
            String sign = billDimensionMatchInfo.getSign();
            String mergeKey = signMap.getOrDefault(sign, "");
            if (EmptyUtil.isEmpty((String)mergeKey)) {
                signMap.put(sign, next.getUniqueId());
                continue;
            }
            next.setMergeKey(mergeKey);
        }
        Map<String, ControlExecuteParam> controlExecuteParamMap = controlExecuteParamList.stream().filter(controlExecuteParam -> EmptyUtil.isEmpty((String)controlExecuteParam.getMergeKey())).collect(Collectors.toMap(ControlExecuteParam::getUniqueId, Function.identity(), (a, b) -> a));
        controlContext.setControlExecuteParamMergeMap(controlExecuteParamMap);
        logger.info("filterMatchField  end\u3002\u3002\u3002\u3002");
    }

    @Override
    public int getOrder() {
        return -80;
    }
}

