/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.PlanChangeHeader;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IPlanChangeService;
import kd.tmc.fpm.business.domain.service.impl.PlanChangeService;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.IPlanChangeBizService;
import kd.tmc.fpm.business.mvc.service.IPlanChangeManageService;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.impl.PlanChangeBizServiceImpl;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.spread.datamanager.CellDataUpdateInfo;
import kd.tmc.fpm.business.spread.datamanager.CopyDataInfo;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManager;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.ReportDataManagerFactoryV2;
import kd.tmc.fpm.business.spread.datamanager.ReportDataReceiverFactory;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleConvert;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleInfo;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.spread.command.event.AskExecuteEvent;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import org.apache.commons.collections.CollectionUtils;

public class PlanChangeManageServiceImpl
implements IPlanChangeManageService {
    private static Log logger = LogFactory.getLog(PlanChangeManageServiceImpl.class);
    private IDimensionRepository dimRepo = new DimensionRepository();
    private IPlanChangeBizService bizService = new PlanChangeBizServiceImpl();
    private IReportBizService reportBizService = new ReportBizService();
    private IReportRepository reportRep = new ReportRepository();
    private IPlanChangeService planChangeService = new PlanChangeService();

    @Override
    public FpmOperateResult<IReportDataManagerV2> load(Long changeId, Long reportId, String pageId, PlanChangeHeader changeHeader, IFpmPageCacheService cacheService) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(PlanChangeManageServiceImpl.class.getSimpleName());){
            logger.info("\u5f00\u59cb\u52a0\u8f7d\u8c03\u6574\u5355\uff1a{}\uff0c\u62a5\u8868id\uff1a{}\uff0c\u9875\u9762\u7ef4\uff1a{}", new Object[]{changeId, reportId, pageId});
            span.addTag("Adjustment Doc Load - Load System Information");
            ArrayList<Long> reportIdList = new ArrayList<Long>(1);
            reportIdList.add(reportId);
            Map<Long, Long> reportId2SystemIdMap = this.reportRep.loadReportSystemId(reportIdList);
            FundPlanSystem system = this.dimRepo.loadSystem(reportId2SystemIdMap.get(reportId));
            span.addTag("Adjustment Doc Load - Load adjustment Doc report information");
            PlanChangeRecord changeRecord = this.bizService.load(changeId, reportId, system, changeHeader);
            PlanChangeReport changeReport = changeRecord.getChangeReportList().stream().filter(Objects::nonNull).filter(o -> o.getReportId().compareTo(reportId) == 0).findFirst().get();
            span.addTag("Adjustment sheet loading - data manager building");
            ReportDataManagerV2 manager = ReportDataManagerFactoryV2.getAdjustReportDataManager(system, changeReport, cacheService);
            FpmOperateResult<IReportDataManagerV2> fpmOperateResult = FpmOperateResult.success(manager);
            return fpmOperateResult;
        }
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> load(Long changeId, Long reportId, List<Long> pageDimS, String pageId, PlanChangeHeader changeHeader, IFpmPageCacheService cacheService) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(PlanChangeManageServiceImpl.class.getSimpleName());){
            span.addTag("Adjustment Doc Load - Load System Information");
            ArrayList<Long> reportIdList = new ArrayList<Long>(1);
            reportIdList.add(reportId);
            Map<Long, Long> reportId2SystemIdMap = this.reportRep.loadReportSystemId(reportIdList);
            FundPlanSystem system = this.dimRepo.loadSystem(reportId2SystemIdMap.get(reportId));
            span.addTag("Adjustment Doc Load - Load adjustment Doc report information");
            PlanChangeRecord changeRecord = this.bizService.load(changeId, reportId, system, changeHeader);
            PlanChangeReport changeReport = changeRecord.getChangeReportList().stream().filter(Objects::nonNull).filter(o -> o.getReportId().compareTo(reportId) == 0).findFirst().get();
            span.addTag("Adjustment sheet loading - data manager building");
            ReportDataManagerV2 manager = ReportDataManagerFactoryV2.getAdjustReportDataManagerByPageDim(system, changeReport, cacheService, pageDimS);
            FpmOperateResult<IReportDataManagerV2> fpmOperateResult = FpmOperateResult.success(manager);
            return fpmOperateResult;
        }
    }

    @Override
    public FpmOperateResult<List<Cell>> update(IReportDataManagerV2 manager, List<CellDataUpdateInfo> updateCells, CellDataSource dataSource) {
        List<CellDataUpdateInfo> rebuildList = this.rebuildUpdateCellsIfNeed(updateCells, manager, dataSource);
        manager.updateCellDataForceDAG(rebuildList, dataSource);
        List<Cell> needUpdateValList = manager.getNeedUpdateValList();
        return FpmOperateResult.success(needUpdateValList);
    }

    @Override
    public FpmOperateResult<List<Cell>> copy(IReportDataManagerV2 manager, List<CopyDataInfo> copyDataInfoList, CellDataSource cellDataSource) {
        Cell firstData;
        if (CollectionUtils.isEmpty(copyDataInfoList) || manager.getReportTemplate().getTemplateType() == TemplateType.FIXED) {
            return FpmOperateResult.success(new ArrayList(1));
        }
        copyDataInfoList.stream().forEach(item -> {
            if (item.getVal() == null) {
                item.setVal("");
            }
        });
        CacheCellMeta meta = cellDataSource.getMeta();
        Map<Integer, Map<Integer, List<CopyDataInfo>>> colAndRowCopyDataMap = copyDataInfoList.stream().collect(Collectors.groupingBy(CopyDataInfo::getCol, Collectors.groupingBy(CopyDataInfo::getRow)));
        ArrayList needHandleDataList = new ArrayList(copyDataInfoList.size());
        copyDataInfoList.stream().forEach(item -> needHandleDataList.add(cellDataSource.getCell(item.getRow(), item.getCol())));
        ArrayList<CellDataUpdateInfo> updateInfoList = new ArrayList<CellDataUpdateInfo>(needHandleDataList.size());
        FundPlanSystem system = manager.getSystem();
        Dimension opNameDim = system.getDetailDimensionByDetailType(DetailDimType.COUNTERPARTY_NAME);
        Dimension opTypeDim = system.getDetailDimensionByDetailType(DetailDimType.CONNTERPARTY_TYPE);
        List<ReportCalcVal> colDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        Optional<ReportCalcVal> opNameOptional = colDimValList.stream().filter(item -> opNameDim.getId().equals(item.getDimensionId())).findFirst();
        Optional<ReportCalcVal> opTypeOptional = colDimValList.stream().filter(item -> opTypeDim.getId().equals(item.getDimensionId())).findFirst();
        int opNameCol = -1;
        if (opNameOptional.isPresent()) {
            ReportCalcVal reportCalcVal = opNameOptional.get();
            opNameCol = reportCalcVal.getCol();
        }
        int opTypeColTep = -1;
        ReportCalcVal opTypeCalcVal = null;
        if (opTypeOptional.isPresent()) {
            opTypeCalcVal = opTypeOptional.get();
            opTypeColTep = opTypeCalcVal.getCol();
        }
        int opTypeCol = opTypeColTep;
        List opTypeDataList = needHandleDataList.stream().filter(item -> item.getCellType() == CellTypeEnum.MUTITYPEWIDGET && item.getCol() == opTypeCol).collect(Collectors.toList());
        for (Cell reportCalcVal : opTypeDataList) {
            CacheCell cell;
            Object key;
            int row = reportCalcVal.getRow();
            int col = reportCalcVal.getCol();
            if (opTypeCalcVal == null) continue;
            ReportValueType valueType = opTypeCalcVal.getValueType();
            Map extMap = (Map)valueType.getValue();
            Map<Integer, List<CopyDataInfo>> colDataMap = colAndRowCopyDataMap.get(col);
            List<CopyDataInfo> copyDataInfoS = colDataMap.get(row);
            if (!CollectionUtils.isNotEmpty(copyDataInfoS)) continue;
            CopyDataInfo copyDataInfo = copyDataInfoS.get(0);
            String copyDataVal = copyDataInfo.getVal().toString().trim();
            Object newVal = key = extMap.get(copyDataVal);
            if (!Objects.isNull(key)) {
                if (opNameCol >= 0) {
                    cell = cellDataSource.getCell(copyDataInfo.getRow(), opNameCol);
                    cell.setWidgetValue(key);
                }
            } else {
                newVal = null;
                if (opNameCol >= 0) {
                    cell = cellDataSource.getCell(copyDataInfo.getRow(), opNameCol);
                    CellDataUpdateInfo cellDataUpdateInfo = new CellDataUpdateInfo(cell.getRow(), cell.getCol(), null);
                    updateInfoList.add(cellDataUpdateInfo);
                }
            }
            CellDataUpdateInfo cellDataUpdateInfo = new CellDataUpdateInfo(row, col, newVal);
            updateInfoList.add(cellDataUpdateInfo);
        }
        List f7DataList = needHandleDataList.stream().filter(item -> item.getCellType() == CellTypeEnum.F7WIDGET && !StringUtils.isEmpty((Object)item.getWidgetValue())).collect(Collectors.toList());
        Map<Integer, List<Cell>> f7ColMap = f7DataList.stream().collect(Collectors.groupingBy(item -> item.getCol()));
        for (Map.Entry<Integer, List<Cell>> next : f7ColMap.entrySet()) {
            List<Cell> currDataList = next.getValue();
            Map<Object, List<Cell>> f7TypeColMap = currDataList.stream().collect(Collectors.groupingBy(item -> item.getWidgetValue()));
            for (Map.Entry<Object, List<Cell>> f7TypeNext : f7TypeColMap.entrySet()) {
                String f7EntityType = f7TypeNext.getKey().toString();
                currDataList = f7TypeNext.getValue();
                firstData = currDataList.get(0);
                HashSet nameSet = new HashSet(16);
                currDataList.stream().forEach(item -> {
                    Map copyDataColMap = (Map)colAndRowCopyDataMap.get(item.getCol());
                    List copyDataInfoS = (List)copyDataColMap.get(item.getRow());
                    nameSet.addAll(copyDataInfoS.stream().map(o -> o.getVal().toString().trim()).filter(str -> !StringUtils.isEmpty((Object)str)).collect(Collectors.toSet()));
                });
                if (nameSet.size() == 0) continue;
                List<QFilter> filter = this.getF7Filter(system, colDimValList, manager.getReportTemplate(), firstData.getCol(), null);
                BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)f7EntityType);
                String nameProperty = basedataEntityType.getNameProperty();
                if (StringUtils.isEmpty((Object)nameProperty)) continue;
                QFilter nameQFilter = new QFilter(nameProperty, "in", nameSet);
                filter.add(nameQFilter);
                DynamicObjectCollection dbDataColl = QueryServiceHelper.query((String)f7EntityType, (String)"id,name", (QFilter[])filter.toArray(new QFilter[0]));
                Map nameAndIdMap = dbDataColl.stream().collect(Collectors.toMap(item -> item.getString("name"), Function.identity(), (k1, k2) -> k1));
                currDataList.stream().forEach(item -> {
                    Map copyDataRowMap = (Map)colAndRowCopyDataMap.get(item.getCol());
                    List copyDataInfoS = (List)copyDataRowMap.get(item.getRow());
                    String val = ((CopyDataInfo)copyDataInfoS.get(0)).getVal().toString();
                    val = val.trim();
                    DynamicObject dbData = (DynamicObject)nameAndIdMap.get(val);
                    CellDataUpdateInfo cellDataUpdateInfo = null;
                    cellDataUpdateInfo = dbData != null ? new CellDataUpdateInfo(item.getRow(), item.getCol(), dbData.getLong("id")) : new CellDataUpdateInfo(item.getRow(), item.getCol(), null);
                    updateInfoList.add(cellDataUpdateInfo);
                });
            }
        }
        List f7NoTypeDataList = needHandleDataList.stream().filter(item -> item.getCellType() == CellTypeEnum.F7WIDGET && StringUtils.isEmpty((Object)item.getWidgetValue())).collect(Collectors.toList());
        for (Cell reportCalcVal : f7NoTypeDataList) {
            CellDataUpdateInfo cellDataUpdateInfo = new CellDataUpdateInfo(reportCalcVal.getRow(), reportCalcVal.getCol(), reportCalcVal.getValue());
            updateInfoList.add(cellDataUpdateInfo);
        }
        List enumDataList = needHandleDataList.stream().filter(item -> item.getCellType() == CellTypeEnum.DOWNBOXWIDGET).collect(Collectors.toList());
        Map<Integer, List<Cell>> enumDataColMap = enumDataList.stream().collect(Collectors.groupingBy(item -> item.getCol()));
        for (Map.Entry<Integer, List<Cell>> next : enumDataColMap.entrySet()) {
            List<Cell> currColDataList = next.getValue();
            firstData = currColDataList.get(0);
            Map enumValueMap = (Map)firstData.getWidgetValue();
            currColDataList.stream().forEach(item -> {
                Map copyDataRowMap = (Map)colAndRowCopyDataMap.get(item.getCol());
                List copyDataInfoS = (List)copyDataRowMap.get(item.getRow());
                String val = ((CopyDataInfo)copyDataInfoS.get(0)).getVal().toString();
                CellDataUpdateInfo cellDataUpdateInfo = null;
                cellDataUpdateInfo = enumValueMap.containsKey(val) ? new CellDataUpdateInfo(item.getRow(), item.getCol(), val) : new CellDataUpdateInfo(item.getRow(), item.getCol(), null);
                updateInfoList.add(cellDataUpdateInfo);
            });
        }
        List<CellDataUpdateInfo> rebuildList = this.rebuildUpdateCellsIfNeed(updateInfoList, manager, cellDataSource);
        manager.updateCellDataForceDAG(rebuildList, cellDataSource);
        return FpmOperateResult.success(manager.getNeedUpdateValList());
    }

    @Override
    public FpmOperateResult<List<Cell>> deleteRows(IReportDataManagerV2 manager, CellDataSource dataSource, AskExecuteEvent event) {
        FpmOperateResult<List<Cell>> result = FpmOperateResult.success();
        List rows = ((List)event.getParams()).stream().filter(Objects::nonNull).filter(o -> o != 0).sorted().collect(Collectors.toList());
        if (rows == null || rows.size() == 0) {
            result.setData(new ArrayList(10));
            return result;
        }
        ReportTemplate reportTemplate = manager.getReportTemplate();
        Integer maxLineCount = reportTemplate.getMaxLineCount();
        Long reportId = manager.getReportId();
        HashSet<Long> reportIdSet = new HashSet<Long>(1, 1.0f);
        reportIdSet.add(reportId);
        Report simpleReport = this.reportRep.loadSimpleReport(reportIdSet, t -> t.setNeedReportPeriodType(true)).get(0);
        boolean hasDetailPeriod = simpleReport.getReportPeriodType().getDetailPeriodType() != null;
        int detailTemplateMaxRow = reportTemplate.getDataStartRow(hasDetailPeriod) + maxLineCount;
        List collect = rows.stream().filter(index -> index > detailTemplateMaxRow).map(integer -> integer + 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            String moreThanMaxLines = collect.stream().map(integer -> integer.toString()).collect(Collectors.joining("\u3001"));
            String errorMessage = String.format(ResManager.loadKDString((String)"\u5f85\u5220\u9664\u7684\u7b2c%1$s\u884c\u5927\u4e8e\u660e\u7ec6\u8868\u6a21\u677f\u8bbe\u7f6e\u7684\u6700\u5927\u884c\u6570\uff1a%2$s\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"PlanChangeManageServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), moreThanMaxLines, detailTemplateMaxRow + 1);
            return FpmOperateResult.error(errorMessage);
        }
        FundPlanSystem system = manager.getSystem();
        Optional<Dimension> subjectDimensionOp = system.getDimList().stream().filter(Objects::nonNull).filter(o -> o.getDimType() == DimensionType.SUBJECTS).findAny();
        if (!subjectDimensionOp.isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u79d1\u76ee\u7ef4\u5ea6\uff0c\u5b58\u5728\u6570\u636e\u95ee\u9898\u3002", (String)"PlanChangeManageServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        CacheCellMeta meta = dataSource.getMeta();
        List colDimList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        Integer subjectDimCol = colDimList.stream().filter(calcVal -> Objects.nonNull(calcVal.getDimensionId())).filter(calcVal -> Objects.equals(calcVal.getDimensionId(), ((Dimension)subjectDimensionOp.get()).getId())).map(ReportCalcVal::getCol).findAny().get();
        Integer startRow = colDimList.stream().map(ReportCalcVal::getRow).max(Integer::compareTo).get();
        AuxiliaryCellStyleConvert auxiliaryCellStyleConvert = new AuxiliaryCellStyleConvert();
        List nonDeleteRows = rows.stream().filter(row -> {
            if (row <= startRow) {
                return true;
            }
            CacheCell subjectCell = dataSource.getCell((int)row, subjectDimCol);
            if (Objects.isNull((Object)subjectCell)) {
                return false;
            }
            AuxiliaryCellStyleInfo auxiliaryCellStyleInfo = auxiliaryCellStyleConvert.toAuxiliaryCellStyle(subjectCell.getCellStyleMark());
            CellStyleInfo cellStyleInfo = auxiliaryCellStyleInfo.generateStyle();
            return cellStyleInfo.isL();
        }).collect(Collectors.toList());
        List deleteRows = rows.stream().filter(row -> !nonDeleteRows.contains(row)).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(deleteRows)) {
            result.setData(new ArrayList(10));
            String errorMessage = String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u9009\u4e2d\u7684\u201c%s\u201d\u884c\uff0c\u8868\u5934\u548c\u5df2\u751f\u6548\u7684\u7f16\u5236\u6570\u636e\u4e0d\u5141\u8bb8\u88ab\u5220\u9664\u3002", (String)"PlanChangeManageServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]), nonDeleteRows.stream().map(row -> String.valueOf(row + 1)).collect(Collectors.joining(",")));
            return FpmOperateResult.error(errorMessage);
        }
        List<CacheCell> allCell = dataSource.getAllCell();
        Map<Integer, List<CacheCell>> rowMap = allCell.stream().collect(Collectors.groupingBy(CacheCell::getRow));
        ArrayList<CellDataUpdateInfo> updateCellDataList = new ArrayList<CellDataUpdateInfo>(16);
        ArrayList<Long> deleteDataIdList = new ArrayList<Long>();
        for (Integer deleteRow : deleteRows) {
            List<CacheCell> cols = rowMap.get(deleteRow);
            if (cols == null) continue;
            for (CacheCell cell : cols) {
                if (cell.getDataId() != null) {
                    deleteDataIdList.add((Long)cell.getDataId());
                }
                updateCellDataList.add(new CellDataUpdateInfo(cell.getRow(), cell.getCol(), null));
            }
        }
        if (deleteDataIdList.size() > 0) {
            dataSource.addDeletedDataIdList(deleteDataIdList);
        }
        if (EmptyUtil.isEmpty(nonDeleteRows)) {
            String successMessage = String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5220\u9664\u884c\u201c%1$s\u201d\u3002", (String)"PlanChangeManageServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]), rows.stream().map(row -> String.valueOf(row + 1)).collect(Collectors.joining(",")));
            result.setSuccessMessage(successMessage);
        } else {
            String warnMessage = String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u4e2d\uff0c\u5df2\u6210\u529f\u5220\u9664\u201c%1$s\u201d\u884c\uff0c\u201c%2$s\u201d\u884c\u65e0\u6cd5\u5220\u9664\uff0c\u8868\u5934\u548c\u5df2\u751f\u6548\u7684\u7f16\u5236\u6570\u636e\u4e0d\u5141\u8bb8\u88ab\u5220\u9664\u3002", (String)"PlanChangeManageServiceImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]), deleteRows.stream().map(row -> String.valueOf(row + 1)).collect(Collectors.joining(",")), nonDeleteRows.stream().map(row -> String.valueOf(row + 1)).collect(Collectors.joining(",")));
            result.setSuccessMessage(warnMessage);
        }
        manager.updateCellDataForceDAG(updateCellDataList, dataSource);
        result.setData(manager.getNeedUpdateValList());
        return result;
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> save(IReportDataManagerV2 manager, PlanChangeRecord pc, CellDataSource cellDataSource) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(PlanChangeManageServiceImpl.class.getSimpleName());){
            span.addTag("save_step_1");
            PlanChangeRecord planChangeRecord = this.bizService.loadWithoutOriginalReportData(pc.getId());
            span.addTag("save_step_2");
            this.updateHeadInfo(planChangeRecord, pc);
            span.addTag("save_step_3");
            this.deleteNotExistsReportData(planChangeRecord);
            Set<Long> reportIds = planChangeRecord.getOriginalReportIdList().stream().collect(Collectors.toSet());
            List<Report> originalReports = this.reportRep.loadReportWithAllDimension(reportIds);
            Map reportMap = originalReports.stream().collect(Collectors.toMap(Report::getId, Function.identity()));
            List<PlanChangeReport> changeReportList = planChangeRecord.getChangeReportList();
            for (PlanChangeReport planChangeReport : changeReportList) {
                this.planChangeService.changeDataBuildByRD(planChangeReport, (Report)reportMap.get(planChangeReport.getReportId()));
            }
            Optional<PlanChangeReport> first = planChangeRecord.getChangeReportList().stream().filter(report -> Objects.equals(manager.getReportId(), report.getReportId())).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e0e\u8c03\u6574\u5355\u201c%1$s\u201d\u8bb0\u5f55\u76f8\u5173\u7684\u8ba1\u5212\u7f16\u5236\u5355\u636e\u201c%2$s\u201d\u4fe1\u606f\u3002", (String)"PlanChangeManageServiceImpl_5", (String)"tmc-fpm-business", (Object[])new Object[0]), pc.getId(), manager.getReportId()));
            }
            span.addTag("save_step_4");
            manager.reverseDataToReportDataReceiver(cellDataSource, ReportDataReceiverFactory.createPlanChangeDataReceiver(first.get()));
            span.addTag("save_step_5");
            this.bizService.save(planChangeRecord, manager.getSystem(), originalReports);
            cellDataSource.updateCellAndClearDirty(cellDataSource.getAllCell());
            FpmOperateResult<IReportDataManagerV2> fpmOperateResult = FpmOperateResult.success(manager);
            return fpmOperateResult;
        }
    }

    @Override
    public FpmOperateResult<List<ReportCalcVal>> updateCellData(IReportDataManager manager, List<CellDataUpdateInfo> updateInfoList) {
        return null;
    }

    @Override
    public FpmOperateResult<IReportDataManager> audit(IReportDataManager manager) {
        return null;
    }

    @Override
    public FpmOperateResult<List<QFilter>> getF7Filter(IReportDataManagerV2 manager, int col, String name, CellDataSource cellDataSource) {
        CacheCellMeta meta = cellDataSource.getMeta();
        ReportCalcTree colDimTree = meta.getColDimTree();
        List<ReportCalcVal> currColDimValList = colDimTree.getDimCalcValList(col, meta.getColOffSet());
        return FpmOperateResult.success(this.getF7Filter(manager.getSystem(), currColDimValList, manager.getReportTemplate(), col, name));
    }

    private List<QFilter> getF7Filter(FundPlanSystem fundPlanSystem, List<ReportCalcVal> colDimValList, ReportTemplate template, int col, String name) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        List currColDimList = colDimValList.stream().filter(item -> col == item.getCol()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(colDimValList) && currColDimList.size() == 1) {
            ReportCalcVal currCol = (ReportCalcVal)currColDimList.get(0);
            List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
            Optional<TemplateDim> currColTemplateDimOpt = allTemplateDim.stream().filter(item -> item.getDimensionId().equals(currCol.getDimensionId())).findFirst();
            if (!currColTemplateDimOpt.isPresent()) {
                return qFilterList;
            }
            TemplateDim currColTemplateDim = currColTemplateDimOpt.get();
            if (DimensionType.DETAILDIM != currColTemplateDim.getDimType()) {
                DimensionType dimType = currColTemplateDim.getDimType();
                List<Long> memberScope = currColTemplateDim.getMemberScope();
                if (DimensionType.PERIOD == dimType) {
                    List<Long> finalPeriodMemberScope = memberScope;
                    Dimension orgPeriodDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
                    List periodMemberList = orgPeriodDim.getAllDimMemberList().stream().filter(item -> memberScope.contains(item.getId())).collect(Collectors.toList());
                    List childMemberList = periodMemberList.stream().map(DimMember::getAllChildMember).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(childMemberList)) {
                        finalPeriodMemberScope = childMemberList.stream().map(DimMember::getId).collect(Collectors.toList());
                    }
                    qFilterList.add(new QFilter("id", "in", finalPeriodMemberScope));
                } else {
                    qFilterList.add(new QFilter("id", "in", memberScope));
                }
                qFilterList.add(new QFilter("bodysystem", "=", (Object)fundPlanSystem.getId()));
                qFilterList.add(new QFilter("dimtype", "=", (Object)dimType.getNumber()));
            }
        }
        if (EmptyUtil.isNotEmpty((CharSequence)name)) {
            qFilterList.add(new QFilter("name", "like", (Object)("%" + name + "%")));
        }
        return qFilterList;
    }

    private void updateHeadInfo(PlanChangeRecord planChangeRecord, PlanChangeRecord pc) {
        planChangeRecord.setCreatorId(pc.getCreatorId());
        planChangeRecord.setApplyDate(pc.getApplyDate());
        planChangeRecord.setAdjustReason(pc.getAdjustReason());
        planChangeRecord.setAdjustType(pc.getAdjustType());
        planChangeRecord.setOriginalReportIdList(pc.getOriginalReportIdList());
        planChangeRecord.setAmountUnit(pc.getAmountUnit());
        planChangeRecord.setAdjustRollPeriod(pc.getAdjustRollPeriod());
    }

    private void deleteNotExistsReportData(PlanChangeRecord planChangeRecord) {
        HashSet<Long> reportIdSet = new HashSet<Long>(planChangeRecord.getOriginalReportIdList());
        List<PlanChangeReport> changeReportList = planChangeRecord.getChangeReportList();
        List notExistReports = changeReportList.stream().filter(report -> !reportIdSet.contains(report.getReportId())).collect(Collectors.toList());
        changeReportList.removeAll(notExistReports);
    }

    private List<CellDataUpdateInfo> rebuildUpdateCellsIfNeed(List<CellDataUpdateInfo> updateInfoList, IReportDataManagerV2 dataManager, CellDataSource cellDataSource) {
        ReportTemplate reportTemplate = dataManager.getReportTemplate();
        if (!reportTemplate.getTemplateType().isDetail()) {
            return updateInfoList;
        }
        int subjectCol4UpdateFlowCol = ReportHelper.getSubjectColIfNeedUpdateSubjectFlow(reportTemplate, cellDataSource.getMeta().getColDimTree());
        if (subjectCol4UpdateFlowCol < 0) {
            return updateInfoList;
        }
        List subjectUpdateInfoList = updateInfoList.stream().filter(info -> info.getCol() == subjectCol4UpdateFlowCol).collect(Collectors.toList());
        Set subjectMemberIdSet = subjectUpdateInfoList.stream().map(CellDataUpdateInfo::getVal).filter(Objects::nonNull).map(o -> (Long)o).collect(Collectors.toSet());
        String selectProperties = "id,flow";
        DynamicObjectCollection subjectMemberDyColl = QueryServiceHelper.query((String)"fpm_member", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", subjectMemberIdSet)});
        Map memberId2DyMap = subjectMemberDyColl.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (a, b) -> a));
        ArrayList<CellDataUpdateInfo> subjectFlowUpdateInfoList = new ArrayList<CellDataUpdateInfo>(subjectUpdateInfoList.size());
        for (CellDataUpdateInfo info2 : subjectUpdateInfoList) {
            if (info2.getCol() != subjectCol4UpdateFlowCol) continue;
            CacheCell subjectCacheCell = cellDataSource.getCell(info2.getRow(), info2.getCol());
            info2.setOldVal(subjectCacheCell.getValue());
            int flowCellRow = info2.getRow();
            int flowCellCol = info2.getCol() + 1;
            CacheCell subjectFlowCacheCell = cellDataSource.getCell(flowCellRow, flowCellCol);
            Object flowOldVal = subjectFlowCacheCell.getValue();
            String newFlowTypeVal = Objects.nonNull(memberId2DyMap.get(info2.getVal())) ? ((DynamicObject)memberId2DyMap.get(info2.getVal())).getString("flow") : null;
            Long flowNewVal = Objects.isNull(newFlowTypeVal) ? null : Arrays.stream(FlowType.values()).filter(flowType -> Objects.equals(flowType.getNumber(), newFlowTypeVal)).map(FlowType::getVirtualId).findAny().get();
            CellDataUpdateInfo subjectFlowUpdateInfo = new CellDataUpdateInfo(flowCellRow, flowCellCol, (Object)flowNewVal, flowOldVal);
            subjectFlowUpdateInfoList.add(subjectFlowUpdateInfo);
        }
        ArrayList<CellDataUpdateInfo> rebuildList = new ArrayList<CellDataUpdateInfo>(updateInfoList.size() + subjectFlowUpdateInfoList.size());
        rebuildList.addAll(updateInfoList);
        rebuildList.addAll(subjectFlowUpdateInfoList);
        return rebuildList;
    }
}

