/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.AbstractDecorationControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class PlanExecuteRecordBackFillControlExecuteStrategy
extends AbstractDecorationControlExecuteStrategy {
    public PlanExecuteRecordBackFillControlExecuteStrategy(AbstractControlExecuteStrategy abstractControlExecuteStrategy) {
        super(abstractControlExecuteStrategy);
    }

    @Override
    public void beforeDoControl() {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        Set bizBillIds = controlExecuteParamList.stream().map(ControlExecuteParam::getBillBizInfo).map(BillBizInfo::getBillId).collect(Collectors.toSet());
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        Map<Long, List<PlanExecuteRecord>> relatePlanExecuteRecordMap = controlTraceInfoMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(ControlTraceInfo::getExecuteRecordList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(p -> EmptyUtil.isNoEmpty((Long)p.getRelateRecordId())).filter(p -> p.getDeleteStatus() == false).distinct().collect(Collectors.groupingBy(PlanExecuteRecord::getRelateRecordId));
        Map<String, List<PlanExecuteRecord>> planExecuteRecordMap = controlTraceInfoMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(controlTraceInfo -> Objects.equals(controlTraceInfo.getEntityType(), this.controlContext.getEntityType())).filter(controlTraceInfo -> bizBillIds.contains(controlTraceInfo.getBillId())).map(ControlTraceInfo::getExecuteRecordList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(p -> p.getDeleteStatus() == false).filter(p -> p.getExecuteOpType() == this.getFilterType()).distinct().collect(Collectors.groupingBy(p -> this.controlStrategyDelegate.getGroupKey(p.getBillBizInfo(), p.getMatchRuleId())));
        ArrayList<ControlExecuteParam> newParam = new ArrayList<ControlExecuteParam>(4);
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            String groupKey = this.controlStrategyDelegate.getGroupKey(controlExecuteParam.getBillBizInfo(), controlExecuteParam.getMatchRule());
            List planExecuteRecordList = planExecuteRecordMap.getOrDefault(groupKey, Collections.emptyList());
            if (EmptyUtil.isEmpty(planExecuteRecordList)) {
                logger.info("\u6ca1\u6709\u5bf9\u5e94\u7684\u9884\u5360\u6267\u884c\u8bb0\u5f55\u3002\u3002\u3002");
                continue;
            }
            this.fillMatchInfo(controlExecuteParam, (PlanExecuteRecord)planExecuteRecordList.get(0), relatePlanExecuteRecordMap);
            for (int i = 1; i < planExecuteRecordList.size(); ++i) {
                ControlExecuteParam copy = controlExecuteParam.copy();
                this.fillMatchInfo(copy, (PlanExecuteRecord)planExecuteRecordList.get(i), relatePlanExecuteRecordMap);
                newParam.add(copy);
            }
        }
        controlExecuteParamList.addAll(newParam);
        controlExecuteParamList.removeIf(next -> Objects.isNull(next.getOriginalPlanExecuteRecord()));
        this.abstractControlExecuteStrategy.beforeDoControl();
    }

    @Override
    public FpmOperateResult<ControlResult> validate() {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        controlExecuteParamList.removeIf(next -> Objects.isNull(next.getOriginalPlanExecuteRecord()));
        return this.abstractControlExecuteStrategy.validate();
    }

    private void fillMatchInfo(ControlExecuteParam controlExecuteParam, PlanExecuteRecord planExecuteRecord, Map<Long, List<PlanExecuteRecord>> relatePlanExecuteRecordMap) {
        this.controlStrategyDelegate.fillMatchInfo(controlExecuteParam, planExecuteRecord);
        controlExecuteParam.setRelatePlanExecuteRecordList(relatePlanExecuteRecordMap.getOrDefault(planExecuteRecord.getId(), Collections.emptyList()));
    }

    private PlanExecuteOpType getFilterType() {
        PlanExecuteOpType planExecuteOpType = this.controlContext.getPlanExecuteOpType();
        switch (planExecuteOpType) {
            case PRE_OCCUPY_DELETE: 
            case PRE_OCCUPY_RELEASE: {
                return PlanExecuteOpType.PRE_OCCUPY_WRITE;
            }
            case CANCEL: 
            case RELEASE: {
                return PlanExecuteOpType.WRITE;
            }
        }
        throw new KDBizException("unKnow reverse PlanExecuteOpType" + planExecuteOpType.getNumber());
    }
}

