/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTracePlanRecordSort;
import kd.tmc.fpm.business.domain.model.control.ControlUpdateInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.message.MessageParam;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IControlService;
import kd.tmc.fpm.business.helper.ControlHelper;
import kd.tmc.fpm.business.helper.ControlMetricCalculateHelper;
import kd.tmc.fpm.business.helper.ControlStrategyUpdateInfoHelper;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dto.ControlParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.ControlParamResultDTO;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.MessageHelper;

public class PreOccupyControlExecuteStrategy
extends AbstractControlExecuteStrategy {
    private final IControlService controlService;
    private final List<MessageParam> warnMessageList;

    public PreOccupyControlExecuteStrategy(ControlContext controlContext) {
        super(controlContext);
        this.warnMessageList = new ArrayList<MessageParam>(controlContext.getControlExecuteParamList().size() / 4);
        this.controlService = FpmServiceFactory.getBizService(IControlService.class);
    }

    @Override
    public void beforeDoControl() {
    }

    @Override
    public FpmOperateResult<ControlResult> validate() {
        if (this.controlResult.hasError()) {
            return super.validate();
        }
        try {
            ControlMetricCalculateHelper.set();
            this.fillRelateReportData();
            this.checkControlStrategy();
            ControlStrategyUpdateInfoHelper.insertControlUpdateInfoAndFillBackRequestId(this.controlContext);
            if (!this.controlResult.hasError() && ControlStrategyUpdateInfoHelper.needReCheck(this.controlContext)) {
                this.warnMessageList.clear();
                this.reCheckControlStrategy();
            }
            if (EmptyUtil.isNoEmpty(this.warnMessageList)) {
                MessageHelper.batchSendMessageByTemplate(this.warnMessageList);
            }
            FpmOperateResult<ControlResult> fpmOperateResult = FpmOperateResult.success(this.controlResult);
            return fpmOperateResult;
        }
        finally {
            ControlMetricCalculateHelper.remove();
        }
    }

    private void reCheckControlStrategy() {
        logger.info("\u5f53\u524d\u6709\u5176\u4ed6\u7ebf\u7a0b\u6b63\u5728\u5199\u5165\uff0c\u91cd\u65b0\u6821\u9a8c\u63a7\u5236\u7b56\u7565\u3002\u3002\u3002");
        ControlStrategyUpdateInfoHelper.fillBackConcurrentAmountInfo(this.controlContext);
        this.checkControlStrategy();
    }

    private void fillRelateReportData() {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        IRelateReportDataManager relateReportDataManager = this.controlContext.getRelateReportDataManager();
        HashMap<String, List<Object>> mergeKeyReportDataListMap = new HashMap<String, List<Object>>(16);
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            List cacheReportDataList;
            String mergeKey = EmptyUtil.isEmpty((String)controlExecuteParam.getMergeKey()) ? controlExecuteParam.getUniqueId() : controlExecuteParam.getMergeKey();
            String cacheKey = String.join((CharSequence)"#", mergeKey, controlExecuteParam.getReportTypeId().toString());
            if (EmptyUtil.isNoEmpty((String)cacheKey) && EmptyUtil.isNoEmpty(cacheReportDataList = mergeKeyReportDataListMap.getOrDefault(cacheKey, Collections.emptyList()))) {
                controlExecuteParam.setRelateReportDataList(new ArrayList<ReportData>(cacheReportDataList));
                continue;
            }
            ArrayList<ReportData> matchedReportDataList = new ArrayList<ReportData>(controlExecuteParam.getMatchedReportDataList());
            matchedReportDataList.addAll(controlExecuteParam.getOptionalMaybeNeedReportDataList());
            List<ReportData> relateReportDataList = relateReportDataManager.getRelateReportDataListBySourceCanDiff(matchedReportDataList);
            relateReportDataList.addAll(matchedReportDataList);
            relateReportDataList.addAll(controlExecuteParam.getMatchedSameReportDataList());
            controlExecuteParam.setRelateReportDataList(relateReportDataList);
            mergeKeyReportDataListMap.put(cacheKey, relateReportDataList);
        }
    }

    @Override
    public ControlUpdateInfo handleRecord() {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        ControlUpdateInfo controlUpdateInfo = new ControlUpdateInfo();
        this.controlStrategyDelegate.deleteErrorRecordIfNeed(controlUpdateInfo);
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        HashMap<String, Integer> mergeKeySceneTypeMap = new HashMap<String, Integer>(controlExecuteParamList.size());
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            PlanExecuteRecord planExecuteRecord = this.controlStrategyDelegate.createPlanExecuteRecord(controlExecuteParam);
            BillBizInfo billBizInfo = planExecuteRecord.getBillBizInfo();
            String key = String.join((CharSequence)"#", billBizInfo.getBillId().toString(), planExecuteRecord.getSystemId().toString());
            ControlTracePlanRecordSort controlTracePlanRecordSort = this.controlStrategyDelegate.sortedExecuteRecord(controlTraceInfoMap.getOrDefault(key, Collections.emptyList()), key);
            int sceneType = this.getSceneType(controlExecuteParam, planExecuteRecord, mergeKeySceneTypeMap, controlTracePlanRecordSort);
            switch (sceneType) {
                case 0: {
                    break;
                }
                case 1: {
                    this.sameBillOccupy(planExecuteRecord, controlUpdateInfo, controlTracePlanRecordSort, this.deletePlanExecuteRecord(planExecuteRecord, controlUpdateInfo));
                    break;
                }
                case 2: {
                    this.sameBillOccupy(planExecuteRecord, controlUpdateInfo, controlTracePlanRecordSort, this.releaseOccupyPlanExecuteRecord(planExecuteRecord, controlUpdateInfo));
                    break;
                }
                case 3: {
                    this.existsUpperBillOccupy(planExecuteRecord, controlUpdateInfo);
                }
            }
            this.controlStrategyDelegate.addWaitConsumeInfo(planExecuteRecord);
            planExecuteRecord.setControlTraceId(this.controlContext.getControlTraceId(planExecuteRecord.getBillBizInfo().getBillId()));
            controlUpdateInfo.addSavePlanExecuteRecord(planExecuteRecord);
        }
        this.controlStrategyDelegate.fillCompleteControlUpdateInfo(controlUpdateInfo);
        return controlUpdateInfo;
    }

    private int getSceneType(ControlExecuteParam controlExecuteParam, PlanExecuteRecord current, Map<String, Integer> mergeKeySceneTypeMap, ControlTracePlanRecordSort controlTracePlanRecordSort) {
        String mergeKey = controlExecuteParam.getMergeKey();
        if (EmptyUtil.isNoEmpty((String)mergeKey)) {
            return mergeKeySceneTypeMap.getOrDefault(mergeKey, 0);
        }
        int sceneType = controlTracePlanRecordSort.getSceneType(current);
        mergeKeySceneTypeMap.put(controlExecuteParam.getUniqueId(), sceneType);
        return sceneType;
    }

    private void existsUpperBillOccupy(PlanExecuteRecord currentPlanExecuteRecord, ControlUpdateInfo controlUpdateInfo) {
        PlanExecuteRecord suitRecord;
        ControlTracePlanRecordSort controlTracePlanRecordSort = this.getCurrentPreWriteNeedRecords(currentPlanExecuteRecord);
        BigDecimal waitReleaseAmt = currentPlanExecuteRecord.getActAmount();
        AtomicBoolean sameDim = new AtomicBoolean(false);
        while (waitReleaseAmt.compareTo(BigDecimal.ZERO) != 0 && (suitRecord = controlTracePlanRecordSort.getSuitRecord(currentPlanExecuteRecord, sameDim)) != null) {
            PlanExecuteRecord copy;
            BigDecimal unReleaseAmt = suitRecord.getUnReleaseAmt();
            if (BigDecimal.ZERO.compareTo(unReleaseAmt) == 0) continue;
            if (BigDecimal.ZERO.compareTo(waitReleaseAmt) == 0) break;
            if (this.controlStrategyDelegate.largeThan(unReleaseAmt, waitReleaseAmt)) {
                this.releaseOccupyWithHoldingAmt(suitRecord, waitReleaseAmt);
                copy = this.controlStrategyDelegate.getReleasePlanExecuteRecord(currentPlanExecuteRecord, suitRecord, PlanExecuteOpType.PRE_OCCUPY_RELEASE, waitReleaseAmt);
                controlUpdateInfo.addSavePlanExecuteRecord(copy);
                suitRecord.updateUnReleaseAmt(waitReleaseAmt);
                controlTracePlanRecordSort.updateRecord(suitRecord);
                break;
            }
            this.releaseOccupyWithHoldingAmt(suitRecord, unReleaseAmt);
            copy = this.controlStrategyDelegate.getReleasePlanExecuteRecord(currentPlanExecuteRecord, suitRecord, PlanExecuteOpType.PRE_OCCUPY_RELEASE, unReleaseAmt);
            controlUpdateInfo.addSavePlanExecuteRecord(copy);
            suitRecord.setUnReleaseAmt(BigDecimal.ZERO);
            controlTracePlanRecordSort.updateRecord(suitRecord);
            waitReleaseAmt = waitReleaseAmt.subtract(unReleaseAmt);
        }
    }

    private void sameBillOccupy(PlanExecuteRecord planExecuteRecord, ControlUpdateInfo controlUpdateInfo, ControlTracePlanRecordSort controlTracePlanRecordSort, Consumer<PlanExecuteRecord> callBack) {
        List historyOccupyWriteRecordList;
        List<PlanExecuteRecord> withHoldingPlanExecuteRecordList;
        List<PlanExecuteRecord> withHoldingReleaseRecordList;
        Map<PlanExecuteStatus, Map<PlanExecuteOpType, List<PlanExecuteRecord>>> planExecuteStatusMapMap = controlTracePlanRecordSort.getCurrentByExecuteOps(planExecuteRecord, PlanExecuteOpType.PRE_OCCUPY_WRITE, PlanExecuteOpType.PRE_OCCUPY_RELEASE, PlanExecuteOpType.PRE_OCCUPY_DELETE).values().stream().flatMap(Collection::stream).filter(PlanExecuteRecord::isNotTempConsume).collect(Collectors.groupingBy(PlanExecuteRecord::getExecuteStatus, Collectors.groupingBy(PlanExecuteRecord::getExecuteOpType)));
        List<PlanExecuteRecord> withHoldingDeleteRecordList = planExecuteStatusMapMap.getOrDefault((Object)PlanExecuteStatus.WITHHOLDING, Collections.emptyMap()).getOrDefault(PlanExecuteOpType.PRE_OCCUPY_DELETE, Collections.emptyList());
        if (EmptyUtil.isNoEmpty(withHoldingDeleteRecordList)) {
            logger.info("\u5b58\u5728\u9884\u6263\u51cf\u72b6\u6001\u4e0b\u7684\u9884\u5360\u5220\u9664\uff0c\u4f5c\u5e9f\u9884\u6263\u51cf\u72b6\u6001\u4e0b\u7684\u9884\u5360\u5220\u9664\u8bb0\u5f55\uff1a{}\u3002\u3002\u3002\u3002", withHoldingDeleteRecordList);
            this.cancelWithHoldingRecordAndAfresh(planExecuteRecord, withHoldingDeleteRecordList, controlUpdateInfo);
            withHoldingDeleteRecordList.forEach(controlTracePlanRecordSort::updateRecord);
        }
        if (EmptyUtil.isNoEmpty(withHoldingReleaseRecordList = planExecuteStatusMapMap.getOrDefault((Object)PlanExecuteStatus.WITHHOLDING, Collections.emptyMap()).getOrDefault(PlanExecuteOpType.PRE_OCCUPY_RELEASE, Collections.emptyList()))) {
            logger.info("\u5b58\u5728\u9884\u6263\u51cf\u72b6\u6001\u4e0b\u7684\u9884\u5360\u91ca\u653e\uff0c\u4f5c\u5e9f\u9884\u6263\u51cf\u72b6\u6001\u4e0b\u7684\u9884\u5360\u91ca\u653e\u8bb0\u5f55:{}", withHoldingReleaseRecordList);
            this.cancelWithHoldingRecordAndAfresh(planExecuteRecord, withHoldingReleaseRecordList, controlUpdateInfo);
            withHoldingReleaseRecordList.forEach(controlTracePlanRecordSort::updateRecord);
        }
        if (EmptyUtil.isNoEmpty(withHoldingPlanExecuteRecordList = planExecuteStatusMapMap.getOrDefault((Object)PlanExecuteStatus.WITHHOLDING, Collections.emptyMap()).getOrDefault(PlanExecuteOpType.PRE_OCCUPY_WRITE, Collections.emptyList()))) {
            logger.info("\u5b58\u5728\u9884\u6263\u51cf\u72b6\u6001\u4e0b\u7684\u9884\u5360\u5199\u5165\u8bb0\u5f55\uff1a{},\u5c1a\u672a\u6210\u529f\u6d88\u8d39\uff0c\u4f5c\u5e9f", withHoldingPlanExecuteRecordList);
            this.cancelWithHoldingRecordAndAfresh(planExecuteRecord, withHoldingPlanExecuteRecordList, controlUpdateInfo);
            withHoldingPlanExecuteRecordList.forEach(controlTracePlanRecordSort::updateRecord);
        }
        if (EmptyUtil.isEmpty(historyOccupyWriteRecordList = planExecuteStatusMapMap.getOrDefault((Object)PlanExecuteStatus.SUCCESSFUL, Collections.emptyMap()).getOrDefault(PlanExecuteOpType.PRE_OCCUPY_WRITE, Collections.emptyList()))) {
            return;
        }
        List unReleasePlanExecuteRecords = historyOccupyWriteRecordList.stream().filter(p -> p.getDeleteStatus() == false).filter(p -> p.getUnReleaseAmt().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(unReleasePlanExecuteRecords)) {
            return;
        }
        unReleasePlanExecuteRecords.stream().forEach(p -> {
            callBack.accept((PlanExecuteRecord)p);
            controlTracePlanRecordSort.updateRecord((PlanExecuteRecord)p);
        });
    }

    private Consumer<PlanExecuteRecord> deletePlanExecuteRecord(PlanExecuteRecord planExecuteRecord, ControlUpdateInfo controlUpdateInfo) {
        return waitDeleteRecord -> {
            this.releaseOccupyWithHoldingAmt((PlanExecuteRecord)waitDeleteRecord);
            PlanExecuteRecord releasePlanExecuteRecord = this.controlStrategyDelegate.getReleasePlanExecuteRecord(planExecuteRecord, (PlanExecuteRecord)waitDeleteRecord, PlanExecuteOpType.PRE_OCCUPY_DELETE);
            controlUpdateInfo.addSavePlanExecuteRecord(releasePlanExecuteRecord);
            waitDeleteRecord.setRelateRecordId(planExecuteRecord.getId());
            waitDeleteRecord.markTempConsume();
            controlUpdateInfo.addUpdatePlanExecuteRecord((PlanExecuteRecord)waitDeleteRecord);
        };
    }

    private Consumer<PlanExecuteRecord> releaseOccupyPlanExecuteRecord(PlanExecuteRecord planExecuteRecord, ControlUpdateInfo controlUpdateInfo) {
        return waitReleaseRecord -> {
            this.releaseOccupyWithHoldingAmt((PlanExecuteRecord)waitReleaseRecord);
            PlanExecuteRecord copy = this.controlStrategyDelegate.getReleasePlanExecuteRecord(planExecuteRecord, (PlanExecuteRecord)waitReleaseRecord, PlanExecuteOpType.PRE_OCCUPY_RELEASE);
            waitReleaseRecord.setUnReleaseAmt(waitReleaseRecord.getUnReleaseAmt().subtract(waitReleaseRecord.getActAmount()));
            controlUpdateInfo.addSavePlanExecuteRecord(copy);
        };
    }

    private void cancelWithHoldingRecordAndAfresh(PlanExecuteRecord planExecuteRecord, List<PlanExecuteRecord> withHoldingPlanExecuteRecordList, ControlUpdateInfo controlUpdateInfo) {
        for (PlanExecuteRecord withHoldingRecord : withHoldingPlanExecuteRecordList) {
            this.releaseOccupyWithHoldingAmt(withHoldingRecord);
            withHoldingRecord.setDeleteStatus(Boolean.TRUE);
            withHoldingRecord.setRelateRecordId(planExecuteRecord.getId());
            controlUpdateInfo.addUpdatePlanExecuteRecord(withHoldingRecord);
        }
    }

    private void releaseOccupyWithHoldingAmt(PlanExecuteRecord withHoldingRecord) {
        this.releaseOccupyWithHoldingAmt(withHoldingRecord, withHoldingRecord.getActAmount());
    }

    private void releaseOccupyWithHoldingAmt(PlanExecuteRecord withHoldingRecord, BigDecimal waitReleaseAmt) {
        this.controlStrategyDelegate.updateWithHoldingAmt(withHoldingRecord, waitReleaseAmt, true, true);
    }

    private ControlTracePlanRecordSort getCurrentPreWriteNeedRecords(PlanExecuteRecord currentPlanExecuteRecord) {
        BillBizInfo billBizInfo = currentPlanExecuteRecord.getBillBizInfo();
        String key = String.join((CharSequence)"#", billBizInfo.getBillId().toString(), currentPlanExecuteRecord.getSystemId().toString());
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        List<ControlTraceInfo> controlTraceInfoList = controlTraceInfoMap.get(key);
        return this.controlStrategyDelegate.sortedExecuteRecord(controlTraceInfoList, key);
    }

    private void checkControlStrategy() {
        logger.info("\u5f00\u59cb\u6821\u9a8c\u63a7\u5236\u7b56\u7565\u3002\u3002\u3002");
        ArrayList<ControlExecuteParam> controlExecuteParamList = new ArrayList<ControlExecuteParam>(this.controlContext.getControlExecuteParamList());
        controlExecuteParamList.sort(Comparator.comparing(ControlExecuteParam::getActAmount));
        ControlAmountCache controlAmountCache = this.controlContext.getControlAmountCache();
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        ControlAmountCache copy = controlAmountCache.copy();
        HashSet releasedRecordIds = new HashSet(16);
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            if (this.controlResult.hasError()) break;
            ReportData reportData = controlExecuteParam.getReportData();
            Long reportOrgId = controlExecuteParam.getReportOrgId();
            BillMatchRule matchRule = controlExecuteParam.getMatchRule();
            FundPlanSystem system = this.controlContext.getSystem(matchRule.getSystemId());
            Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
            Object currPeriodMemberId = reportData.getDimValByDimType(DimensionType.PERIOD, null);
            PeriodMember currPeriodMember = (PeriodMember)periodDim.getAllDimMemberList().stream().filter(item -> item.getId().equals(currPeriodMemberId)).findFirst().get();
            ControlStrategy controlStrategy = this.controlContext.getControlStrategy(matchRule.getSystemId(), currPeriodMember.getPeriodTypeId(), reportOrgId);
            List<ReportData> relateReportDataList = controlExecuteParam.getRelateReportDataList();
            copy.init(relateReportDataList, system.getId());
            QueryIndexInfo<Long, ReportData> dataQueryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(relateReportDataList, this.controlContext.getSystem(controlExecuteParam.getSystemId()), rd -> true);
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            String key = String.join((CharSequence)"#", billBizInfo.getBillId().toString(), controlExecuteParam.getSystemId().toString());
            List controlTraceInfoList = controlTraceInfoMap.getOrDefault(key, Collections.emptyList());
            List<PlanExecuteRecord> notCompleteReleaseOccupyRecordList = controlTraceInfoList.stream().map(ControlTraceInfo::getExecuteRecordList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(p -> p.getDeleteStatus() == false).filter(p -> Objects.equals(p.getReportTypeId(), controlExecuteParam.getReportTypeId())).filter(p -> p.getExecuteOpType() == PlanExecuteOpType.PRE_OCCUPY_WRITE).filter(p -> p.getUnReleaseAmt().compareTo(BigDecimal.ZERO) > 0).filter(p -> releasedRecordIds.add(p.getId())).distinct().collect(Collectors.toList());
            this.releaseUpperOccupy(dataQueryIndexInfo, notCompleteReleaseOccupyRecordList, controlStrategy, copy);
            Set dimensionIds = controlExecuteParam.getDetailMatchInfo().keySet().stream().map(TemplateDim::getDimensionId).collect(Collectors.toSet());
            List<Dimension> dimensionList = system.getDimList().stream().filter(d -> dimensionIds.contains(d.getId())).collect(Collectors.toList());
            FpmOperateResult<ControlParamResultDTO> operateResult = this.controlService.checkByStrategy(ControlParamDTO.builder().controlStrategy(controlStrategy).billBizInfo(billBizInfo).realAmount(controlExecuteParam.getExecuteActAmount()).holdAmount(controlExecuteParam.getConcurrentWriteAmt()).currPeriodMember(currPeriodMember).reportData(reportData).relReportDataList(relateReportDataList).fundPlanSystem(system).accurateMatch(controlExecuteParam.isAccurateMatch()).matchedDimensions(dimensionList).template(this.controlStrategyDelegate.getReportById(reportData.getReportId()).getTemplate()).controlAmountCache(copy).relateReportDataQueryIndexInfo(dataQueryIndexInfo).detailControlInfo(this.controlContext.getControlStrategyDetailControlInfo().getDetailControlInfo(controlExecuteParam)).controlStrategyDelegate(this.controlStrategyDelegate).build());
            this.handleCheckResult(operateResult, controlExecuteParam);
        }
    }

    private void releaseUpperOccupy(QueryIndexInfo<Long, ReportData> dataQueryIndexInfo, List<PlanExecuteRecord> notCompleteReleaseOccupyRecordList, ControlStrategy controlStrategy, ControlAmountCache copy) {
        if (Objects.isNull(controlStrategy)) {
            return;
        }
        if (EmptyUtil.isEmpty(notCompleteReleaseOccupyRecordList)) {
            return;
        }
        BiConsumer<ReportData, BigDecimal> upperSubjectOccupyAmtConsumer = ControlHelper.getUpperSubjectOccupyAmtConsumer(copy, controlStrategy, dataQueryIndexInfo, this.controlStrategyDelegate);
        for (PlanExecuteRecord notCompleteReleaseOccupyRecord : notCompleteReleaseOccupyRecordList) {
            List<ReportData> matchedReportDataList = notCompleteReleaseOccupyRecord.getMatchedReportDataList();
            if (EmptyUtil.isEmpty(matchedReportDataList)) continue;
            BigDecimal waitReleaseAmt = notCompleteReleaseOccupyRecord.getUnReleaseAmt().negate();
            for (ReportData matchedReportData : matchedReportDataList) {
                Long reportId = matchedReportData.getReportId();
                Report report = this.controlStrategyDelegate.getReportById(reportId);
                ReportTemplate template = report.getTemplate();
                Long reportDataId = matchedReportData.getId();
                copy.updateLockAmount(reportDataId, matchedReportData.getReportActAmount(waitReleaseAmt));
                if (template.getTemplateType() == TemplateType.DETAIL) continue;
                upperSubjectOccupyAmtConsumer.accept(matchedReportData, waitReleaseAmt);
            }
        }
    }

    private void handleCheckResult(FpmOperateResult<ControlParamResultDTO> operateResult, ControlExecuteParam controlExecuteParam) {
        BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
        if (!operateResult.isSuccess()) {
            String errorMessage = String.join((CharSequence)";", operateResult.getMessageList());
            logger.error(errorMessage);
            this.controlResult.addErrMsg(controlExecuteParam.getBillBizInfo().getBillId(), errorMessage);
            return;
        }
        ControlParamResultDTO controlParamResultDTO = operateResult.getData();
        if (!controlParamResultDTO.isSuccess()) {
            logger.info("\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}\uff0c\u4e1a\u52a1\u5355\u636e\u7f16\u53f7\uff1a{} \u6267\u884c\u63a7\u5236\u68c0\u67e5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{billBizInfo.getEntityType(), billBizInfo.getBillNo(), controlParamResultDTO.getErrorMessageList()});
            this.controlResult.addErrMsg(billBizInfo.getBillId(), String.join((CharSequence)";", controlParamResultDTO.getErrorMessageList()));
            return;
        }
        if (!controlParamResultDTO.isWarn()) {
            return;
        }
        logger.info("\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}\uff0c\u4e1a\u52a1\u5355\u636e\u7f16\u53f7\uff1a{} \u4f59\u989d\u9884\u8b66", new Object[]{billBizInfo.getEntityType(), billBizInfo.getBillNo(), controlParamResultDTO.getWarnMessageList()});
        ReportData reportData = controlExecuteParam.getReportData();
        Set<Long> userIds = this.getUserIds(reportData.getReportId());
        logger.info("\u53d1\u9001\u6d88\u606f\u4eba\u5458\uff1a{}", userIds);
        this.warnMessageList.add(MessageParam.builder().userIds(userIds).title(ResManager.loadKDString((String)"\u8d44\u91d1\u8ba1\u5212\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\u63d0\u9192\uff0c\u8bf7\u5c3d\u5feb\u67e5\u770b\u548c\u5904\u7406\u3002", (String)"PreOccupyControlExecuteStrategy_0", (String)"tmc-fpm-business", (Object[])new Object[0])).tag(ResManager.loadKDString((String)"\u8d44\u91d1\u8ba1\u5212\u63a7\u5236\u7b56\u7565\u6821\u9a8c\u7ed3\u679c", (String)"PreOccupyControlExecuteStrategy_1", (String)"tmc-fpm-business", (Object[])new Object[0])).tplScene("fpm_control_available_warn").entityName("fpm_report").warpMessage(messageInfo -> messageInfo.setContent(String.join((CharSequence)";", controlParamResultDTO.getWarnMessageList()))).build());
    }

    private Set<Long> getUserIds(Long reportId) {
        Report report = this.controlStrategyDelegate.getReportById(reportId);
        if (Objects.isNull(report)) {
            return Collections.emptySet();
        }
        HashSet<Long> userIds = new HashSet<Long>(2);
        userIds.add(report.getAuditErId());
        userIds.add(report.getInformantErId());
        return userIds;
    }
}

