/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.ControlUpdateInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.control.RecordWithoutHoldingInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;

public class RelateExecutePlanRecordManager {
    protected ControlUpdateInfo controlUpdateInfo;
    protected ControlAmountCache controlAmountCache;
    protected Map<Long, List<PlanExecuteRecord>> relateRecordMap;
    protected Map<Long, PlanExecuteRecord> planExecuteRecordMap;
    protected Map<Long, ReportData> reportDataMap;

    public RelateExecutePlanRecordManager(ControlUpdateInfo controlUpdateInfo, ControlAmountCache controlAmountCache, Map<Long, PlanExecuteRecord> planExecuteRecordMap, Map<Long, ReportData> reportDataMap) {
        this.controlUpdateInfo = controlUpdateInfo;
        this.controlAmountCache = controlAmountCache;
        this.planExecuteRecordMap = planExecuteRecordMap;
        this.relateRecordMap = planExecuteRecordMap.values().stream().filter(p -> EmptyUtil.isNoEmpty((Long)p.getRelateRecordId())).collect(Collectors.groupingBy(PlanExecuteRecord::getRelateRecordId));
        this.reportDataMap = reportDataMap;
    }

    public void process(PlanExecuteRecord currentPlanExecuteRecord) {
        List relateRecordList;
        Long originalRecordId = currentPlanExecuteRecord.getOriginalRecordId();
        if (this.planExecuteRecordMap.containsKey(originalRecordId)) {
            PlanExecuteRecord originalPlanExecuteRecord = this.planExecuteRecordMap.get(originalRecordId);
            if (this.isDelete(currentPlanExecuteRecord)) {
                originalPlanExecuteRecord.setRelateRecordId(currentPlanExecuteRecord.getId());
                this.deleteAllRelateOfPlanExecuteRecord(originalPlanExecuteRecord);
            }
            if (currentPlanExecuteRecord.getExecuteOpType().isUpdate() && this.controlUpdateInfo.addUpdatePlanExecuteRecord(originalPlanExecuteRecord)) {
                originalPlanExecuteRecord.updateAclRemainAmt(currentPlanExecuteRecord.getActAmount());
            }
        }
        if (EmptyUtil.isEmpty(relateRecordList = this.relateRecordMap.getOrDefault(currentPlanExecuteRecord.getId(), Collections.emptyList()).stream().filter(p -> p.getDeleteStatus() == false).collect(Collectors.toList()))) {
            return;
        }
        for (PlanExecuteRecord relateRecord : relateRecordList) {
            if (relateRecord.getExecuteStatus() == PlanExecuteStatus.WITHHOLDING) {
                this.consumerHoldingAmtIfAddUpdate(relateRecord);
                this.updatePlanExecuteStatus(relateRecord);
            }
            if (this.isDelete(currentPlanExecuteRecord)) {
                this.deleteAllRelateOfPlanExecuteRecord(relateRecord);
            }
            if (!this.isDelete(relateRecord)) continue;
            this.process(relateRecord);
            this.updateDeleteStatus(relateRecord);
            this.consumerHoldingAmtIfAddUpdate(relateRecord);
        }
    }

    protected void updateDeleteStatus(PlanExecuteRecord relateRecord) {
        relateRecord.setDeleteStatus(Boolean.TRUE);
    }

    protected void updatePlanExecuteStatus(PlanExecuteRecord relateRecord) {
        relateRecord.setExecuteStatus(PlanExecuteStatus.SUCCESSFUL);
    }

    public void deleteAllRelateOfPlanExecuteRecord(PlanExecuteRecord waitDeletePlanExecuteRecord) {
        List originalReleaseRecordList;
        if (waitDeletePlanExecuteRecord.getDeleteStatus().booleanValue()) {
            return;
        }
        this.updateDeleteStatus(waitDeletePlanExecuteRecord);
        this.controlUpdateInfo.addUpdatePlanExecuteRecord(waitDeletePlanExecuteRecord);
        if (this.isRelease(waitDeletePlanExecuteRecord)) {
            this.consumerHoldingAmtIfAddUpdate(waitDeletePlanExecuteRecord, true);
            return;
        }
        List relateRecordList = this.relateRecordMap.getOrDefault(waitDeletePlanExecuteRecord.getId(), Collections.emptyList()).stream().filter(p -> p.getDeleteStatus() == false).collect(Collectors.toList());
        if (!EmptyUtil.isEmpty(relateRecordList)) {
            for (PlanExecuteRecord relateRecord : relateRecordList) {
                this.updateDeleteStatus(relateRecord);
                this.consumerHoldingAmtIfAddUpdate(relateRecord, true);
            }
        }
        if (EmptyUtil.isEmpty(originalReleaseRecordList = this.planExecuteRecordMap.values().stream().filter(p -> Objects.equals(p.getOriginalRecordId(), waitDeletePlanExecuteRecord.getId())).filter(p -> p.getDeleteStatus() == false).collect(Collectors.toList()))) {
            return;
        }
        for (PlanExecuteRecord originalReleaseRecord : originalReleaseRecordList) {
            this.updateDeleteStatus(originalReleaseRecord);
            if (!this.controlUpdateInfo.addUpdatePlanExecuteRecord(originalReleaseRecord)) continue;
            this.consumerHoldingAmt(originalReleaseRecord, true);
        }
    }

    private boolean isRelease(PlanExecuteRecord waitDeletePlanExecuteRecord) {
        if (waitDeletePlanExecuteRecord.getExecuteOpType().isReleaseOrUpdate()) {
            return true;
        }
        return waitDeletePlanExecuteRecord.getExecuteOpType() == PlanExecuteOpType.PRE_OCCUPY_RELEASE;
    }

    private boolean isDelete(PlanExecuteRecord planExecuteRecord) {
        if (planExecuteRecord.getExecuteOpType() == PlanExecuteOpType.CANCEL) {
            return true;
        }
        return planExecuteRecord.getExecuteOpType() == PlanExecuteOpType.PRE_OCCUPY_DELETE;
    }

    private void consumerHoldingAmtIfAddUpdate(PlanExecuteRecord planExecuteRecord) {
        this.consumerHoldingAmtIfAddUpdate(planExecuteRecord, false);
    }

    private void consumerHoldingAmtIfAddUpdate(PlanExecuteRecord planExecuteRecord, boolean needPositive) {
        if (this.controlUpdateInfo.addUpdatePlanExecuteRecord(planExecuteRecord)) {
            this.consumerHoldingAmt(planExecuteRecord, needPositive);
            List<ReportData> matchedReportDataList = planExecuteRecord.getMatchedReportDataList();
            for (ReportData reportData : matchedReportDataList) {
                this.reportDataMap.putIfAbsent(reportData.getId(), reportData);
            }
        }
    }

    public void consumerHoldingAmt(PlanExecuteRecord planExecuteRecord) {
        this.consumerHoldingAmt(planExecuteRecord, false);
    }

    public void consumerHoldingAmt(PlanExecuteRecord planExecuteRecord, boolean needPositive) {
        this.controlAmountCache.init(planExecuteRecord.getMatchedReportDataList(), planExecuteRecord.getSystemId());
        List<RecordWithoutHoldingInfo> recordWithoutHoldingInfoList = planExecuteRecord.getRecordWithoutHoldingInfoList();
        for (RecordWithoutHoldingInfo recordWithoutHoldingInfo : recordWithoutHoldingInfoList) {
            Long reportDataId = recordWithoutHoldingInfo.getReportDataId();
            BigDecimal holdLockAmt = recordWithoutHoldingInfo.getHoldLockAmt();
            BigDecimal holdActAmt = recordWithoutHoldingInfo.getHoldActAmt();
            this.controlAmountCache.updateLockAmount(reportDataId, needPositive ? holdLockAmt.negate() : holdLockAmt);
            this.controlAmountCache.updateActAmount(reportDataId, needPositive ? holdActAmt.negate() : holdActAmt);
        }
    }
}

