/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.SourceIdQueryParam;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.service.IReportDataBizService;
import kd.tmc.fpm.business.mvc.service.dto.RDBizLoadDto;
import kd.tmc.fpm.business.mvc.service.strategy.ReportDataGetSourceIdStrategy;

public class ReportDataBizService
implements IReportDataBizService {
    private static Log logger = LogFactory.getLog(ReportDataBizService.class);
    private IReportDataQueryService queryService = new ReportDataQueryService();

    @Override
    public FpmOperateResult<List<ReportData>> loadReportData(RDBizLoadDto loadDto, FundPlanSystem system) {
        logger.info("ReportDataBizService-loadReportData-\u67e5\u8be2\u62a5\u8868\u6570\u636e");
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        queryObject.setDimIdList(loadDto.getDimIdList());
        queryObject.setDimValList(loadDto.getDimValList());
        queryObject.setEffectFlag(loadDto.getEffectFlag());
        queryObject.setMainTable(true);
        if (Objects.nonNull(loadDto.getMainTable())) {
            queryObject.setMainTable(loadDto.getMainTable());
        }
        queryObject.setReportPeriodId(loadDto.getReportPeriodId());
        queryObject.setReportStatuss(loadDto.getReportStatusList());
        queryObject.setTemplateType(loadDto.getTemplateType());
        List<ReportDataQueryResult> resultList = this.queryService.queryReportData(queryObject);
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(16);
        reportDataList.addAll(ReportHelper.convert(resultList));
        return FpmOperateResult.success(reportDataList);
    }

    @Override
    public FpmOperateResult<List<Long>> getSmartGetSourceIds(SourceIdQueryParam queryParam) {
        ReportDataGetSourceIdStrategy reportDataGetSourceIdStrategy = new ReportDataGetSourceIdStrategy(queryParam);
        return FpmOperateResult.success(reportDataGetSourceIdStrategy.getSourceIds());
    }
}

