/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.save.IReportDataSaveService;
import kd.tmc.fpm.business.dataproc.save.ReportDataSaveService;
import kd.tmc.fpm.business.domain.enums.ImportDataTypeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.ImportDataContext;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportFormHeader;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.service.IReportImportDataService;
import kd.tmc.fpm.business.domain.service.IReportService;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.service.IReportImportDataBizService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.business.utils.POIHelper;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;

public class ReportImportDataBizServiceImpl
implements IReportImportDataBizService {
    private static final Log logger = LogFactory.getLog(ReportImportDataBizServiceImpl.class);
    private IReportRepository reportRepository = FpmServiceFactory.getBizService(IReportRepository.class);
    private IDimensionRepository dimensionRepository;
    private IReportImportDataService reportImportDataService = FpmServiceFactory.getBizService(IReportImportDataService.class);
    private IReportDataSaveService dataSaveService;
    private IReportService reportService;
    private IReportDataQueryService dataQueryService;

    public ReportImportDataBizServiceImpl() {
        this.dimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);
        this.dataSaveService = new ReportDataSaveService();
        this.reportService = FpmServiceFactory.getBizService(IReportService.class);
        this.dataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
    }

    @Override
    public void importReportBatch(long reportId, List<Sheet> sheetList) {
        ImportDataContext context = new ImportDataContext();
        Report report = this.reportRepository.loadReportWithAllDimension(reportId);
        if (report.getTemplate().getTemplateType() == TemplateType.FIXED) {
            MetricValueUtils.splitMetric(report);
        }
        FundPlanSystem system = this.dimensionRepository.loadSystem(report.getSystemId());
        context.setReport(report);
        context.setSystem(system);
        TemplateInfoHelper.addSubjectFlowColIfDetailTemplateNeed(report.getTemplate(), system);
        IReportDataProcessExecutor executor = ReportDataProcessExecutorFactory.getReportDataExecutorOfImport(system, report);
        ReportModel reportModel = new ReportModel();
        try {
            executor.executeAction(reportModel);
        }
        catch (Exception e) {
            logger.error("\u8ba1\u5212\u7f16\u5236\u5bfc\u5165-\u6784\u5efareportModel\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(JSONObject.toJSONString((Object)e));
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(report.getTemplate().getPageDimList())) {
            context.setSheet(sheetList.get(0));
            context.setReportCalcModel(reportModel.getReportCalcModelList().get(0));
            this.importData(context);
        } else {
            HashMap<Set<Object>, ReportCalcModel> reportCalcModelMap = new HashMap<Set<Object>, ReportCalcModel>(8);
            for (ReportCalcModel reportCalcModel : reportModel.getReportCalcModelList()) {
                Set key = reportCalcModel.getPageDimValList().stream().map(ReportCalcVal::getValue).collect(Collectors.toSet());
                reportCalcModelMap.put(key, reportCalcModel);
            }
            for (Sheet sheet : sheetList) {
                ReportCalcModel reportCalcModel = this.findReportCalcModel(system, report, sheet, reportCalcModelMap);
                context.setSheet(sheet);
                context.setReportCalcModel(reportCalcModel);
                try {
                    this.importData(context);
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
        }
        TXHandle tx = TX.required();
        Object object = null;
        try {
            try {
                if (report.getTemplate().getTemplateType() == TemplateType.FIXED) {
                    MetricValueUtils.mergeMetric(report);
                }
                this.reportService.calculateReport(report, system);
                report.rebuildTree(system);
                this.reportService.reBuildReportData(report, system);
                ReportHelper.checkReportDataAmt(report);
                this.sumDataToParent(report, system);
                report.setInitFlag(Boolean.TRUE);
                this.dataSaveService.saveReportData(report);
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58reportData\u5931\u8d25");
                tx.markRollback();
                throw new KDBizException(JSONObject.toJSONString((Object)e));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void importData(ImportDataContext context) {
        this.checkSheet(context);
        this.doImportData(context);
    }

    private void doImportData(ImportDataContext context) {
        String pageDimName = context.getReportCalcModel().getPageDimValList().stream().map(ReportCalcVal::getDisplayVal).collect(Collectors.joining(","));
        logger.info(String.format("\u5f00\u59cb\u5bfc\u5165\u9875\u7b7e\u6570\u636e\uff1aSheet\u540d\u79f0:[%s], \u62a5\u8868:[%s,%s], \u9875\u9762\u7ef4:[%s]", context.getSheet().getSheetName(), context.getReport().getName(), context.getReport().getNumber(), pageDimName));
        this.reportImportDataService.convertToReport(context);
        logger.info(String.format("\u5bfc\u5165\u9875\u7b7e\u6570\u636e\u5b8c\u6210\uff1aSheet\u540d\u79f0:[%s]", context.getSheet().getSheetName()));
    }

    private void checkSheet(ImportDataContext context) {
        ReportCalcModel reportCalcModel = context.getReportCalcModel();
        Sheet sheet = context.getSheet();
        List<ReportCalcVal> rowDimValList = reportCalcModel.getRowDimValList();
        List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
        List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
        for (ReportCalcVal colDimVal : colDimValList) {
            int col = colDimVal.getCol();
            Object cellValue = POIHelper.getCellValue(colDimVal.getRow(), col, sheet);
            if (cellValue == null) continue;
            String cellValueStr = ((String)cellValue).replace("*", "");
            if (colDimVal.getDisplayVal().equals(cellValueStr.trim())) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u4f5c\u8868\u3010sheet\u9875\uff1a%1$s\u3011\u5185\u7684\u884c\u5217\u7ef4\u3001\u9875\u9762\u7ef4\u4fe1\u606f\u53ca\u7ef4\u5ea6\u6210\u5458\u6570\u91cf\u4e0e\u8be5\u7f16\u62a5\u671f\u95f4\u4e0b\u7cfb\u7edf\u5df2\u6709\u7684\u8ba1\u5212\u7f16\u5236\u5355\u636e\u7684\u8868\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportImportDataBizServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName()));
        }
        rowDimValList.forEach(rowDimVal -> {
            Object cellValue = POIHelper.getCellValue(rowDimVal.getRow(), rowDimVal.getCol(), sheet);
            if (cellValue != null && !rowDimVal.getDisplayVal().equals(cellValue.toString())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u4f5c\u8868\u3010sheet\u9875\uff1a%1$s\u3011\u5185\u7684\u884c\u5217\u7ef4\u3001\u9875\u9762\u7ef4\u4fe1\u606f\u53ca\u7ef4\u5ea6\u6210\u5458\u6570\u91cf\u4e0e\u8be5\u7f16\u62a5\u671f\u95f4\u4e0b\u7cfb\u7edf\u5df2\u6709\u7684\u8ba1\u5212\u7f16\u5236\u5355\u636e\u7684\u8868\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportImportDataBizServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName()));
            }
        });
        dataValList.stream().filter(c -> !c.isEnable()).forEach(dataVal -> {
            CellStyle cellStyle = POIHelper.getCellStyle(dataVal.getRow(), dataVal.getCol(), sheet);
            if (!cellStyle.getLocked()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0c\u5b58\u5728\u975e\u624b\u5de5\u5f55\u5165\u9879\u7684\u8ba1\u5212\u79d1\u76ee\u8282\u70b9\uff0c\u5bfc\u5165\u6570\u636e\u5931\u8d25\u3002", (String)"ReportImportDataBizServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), dataVal.getRow()));
            }
        });
        Report report = context.getReport();
        if (report.getTemplate().getTemplateType() == TemplateType.DETAIL) {
            ReportImportDataBizServiceImpl.validateDetailReport(context);
        }
    }

    private static void validateDetailReport(ImportDataContext context) {
        ReportCalcModel reportCalcModel = context.getReportCalcModel();
        Sheet sheet = context.getSheet();
        List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
        List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
        Report report = context.getReport();
        int rangeFrom = 99;
        int rangeTo = -1;
        for (ReportCalcVal reportCalcVal2 : dataValList) {
            if (reportCalcVal2.getDimensionId() == null && !reportCalcVal2.isDataCell()) continue;
            rangeFrom = Math.min(rangeFrom, reportCalcVal2.getCol());
            rangeTo = Math.max(rangeTo, reportCalcVal2.getCol());
        }
        Tuple range = new Tuple((Object)rangeFrom, (Object)rangeTo);
        context.setDataColRange((Tuple<Integer, Integer>)range);
        List<ReportCalcVal> validColDimValList = colDimValList.stream().filter(v -> v.getCol() >= (Integer)range.item1 && v.getCol() <= (Integer)range.item2).collect(Collectors.toList());
        Integer minRow = validColDimValList.stream().min(Comparator.comparing(ReportCalcVal::getRow)).map(ReportCalcVal::getRow).orElse(0);
        Map mustRecordColMap = validColDimValList.stream().filter(c -> c.getRow() == minRow.intValue()).filter(colDim -> colDim.getDisplayType() != null && colDim.getDisplayType() == DisplayTypeEnum.MUSTRECORD).collect(Collectors.toMap(ReportCalcVal::getCol, Function.identity(), (k1, k2) -> k1));
        context.setColHeight(ReportImportDataBizServiceImpl.calcColHeight(validColDimValList));
        int modelColHeight = validColDimValList.stream().max(Comparator.comparing(ReportCalcVal::getRow)).map(o -> o.getRow() + 1).orElse(0);
        int totalRow = report.getTemplate().getTotalRow();
        Set<Long> baseDataSet = validColDimValList.stream().filter(reportCalcVal -> reportCalcVal.getColSpan() == 1 && Arrays.asList("BD_NAME", "BD_NUMBER").contains(reportCalcVal.getDimensionName())).collect(Collectors.groupingBy(ReportCalcVal::getDimensionId, Collectors.toSet())).entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).flatMap(entry -> ((Set)entry.getValue()).stream()).map(ReportCalcVal::getDimensionId).collect(Collectors.toSet());
        context.setBaseDataSet(baseDataSet);
        int maxNum = report.getTemplate().getMaxLineCount();
        ArrayList<Integer> validLines = new ArrayList<Integer>();
        for (int j = 0; j < maxNum; ++j) {
            int rowIdx = modelColHeight + totalRow + j;
            if (POIHelper.isEmptyRow(sheet, rowIdx, (Integer)range.item1, (Integer)range.item2)) continue;
            validLines.add(rowIdx);
            for (Map.Entry entry2 : mustRecordColMap.entrySet()) {
                ReportCalcVal reportCalcVal3 = (ReportCalcVal)entry2.getValue();
                boolean isNull = true;
                if (reportCalcVal3.getColSpan() > 1) {
                    for (int i = reportCalcVal3.getCol(); i < reportCalcVal3.getCol() + reportCalcVal3.getColSpan(); ++i) {
                        Object cellValue = POIHelper.getCellValue(rowIdx, i, sheet);
                        if (cellValue == null || !StringUtils.isNotBlank((CharSequence)cellValue.toString())) continue;
                        isNull = false;
                    }
                } else {
                    Object cellValue = POIHelper.getCellValue(rowIdx, reportCalcVal3.getCol(), sheet);
                    if (cellValue != null && StringUtils.isNotBlank((CharSequence)cellValue.toString())) {
                        isNull = false;
                    }
                }
                if (!isNull) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\u201c%3$s\u201d\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"ReportImportDataBizServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), rowIdx + 1, reportCalcVal3.getDisplayVal()));
            }
        }
        context.setValidLines(validLines);
    }

    private static int calcColHeight(List<ReportCalcVal> validColDimValList) {
        return validColDimValList.stream().filter(reportCalcVal -> reportCalcVal.getDimensionName() != null).sorted(Comparator.comparing(ReportCalcVal::getDimensionName).reversed()).max(Comparator.comparing(ReportCalcVal::getRow)).map(ReportCalcVal::getRow).orElse(0);
    }

    private ReportCalcModel findReportCalcModel(FundPlanSystem system, Report report, Sheet sheet, Map<Set<Object>, ReportCalcModel> reportCalcModelMap) {
        List<ReportFormHeader> reportFormHeaderList = this.reportImportDataService.acquireHeader(report, system);
        List pageDimMetadata = reportFormHeaderList.stream().filter(metadata -> metadata.getImportDataTypeEnum() == ImportDataTypeEnum.PAGE_DIM).collect(Collectors.toList());
        Map<String, DimMember> dimMemberMap = system.getDimList().stream().flatMap(dimension -> dimension.getAllDimMemberList().stream().map(dimMember -> new AbstractMap.SimpleEntry<String, DimMember>(this.getDimensionMemberMapKey(dimension.getNumber(), dimMember.getNumber()), (DimMember)dimMember))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashSet<Long> keySet = new HashSet<Long>(pageDimMetadata.size());
        for (ReportFormHeader metadata2 : pageDimMetadata) {
            Object cellValue = POIHelper.getCellValue(metadata2.getRow(), metadata2.getCol(), sheet);
            if (cellValue == null) {
                logger.info(String.format("\u6839\u636e\u7f16\u7801\u5339\u914d\u9875\u9762\u7ef4\u5931\u8d25\uff0c\u5f53\u524dsheet\u9875\uff1a[%s]\uff0c\u884c\uff1a[%s]\uff0c\u5217\uff1a[%s]\uff0c\u83b7\u53d6\u5230\u7684\u5355\u5143\u683c\u6570\u636e\u4e3a\u7a7a", sheet.getSheetName(), metadata2.getRow(), metadata2.getCol()));
                continue;
            }
            String key = this.getDimensionMemberMapKey(metadata2.getDimensionNumber(), cellValue.toString());
            if (dimMemberMap.containsKey(key)) {
                DimMember dimMember = dimMemberMap.get(key);
                keySet.add(dimMember.getId());
                continue;
            }
            logger.info(String.format("\u6839\u636e\u7f16\u7801\u5339\u914d\u9875\u9762\u7ef4\u5931\u8d25\uff0c\u5f53\u524dsheet\u9875\uff1a[%s]\uff0c\u884c\uff1a[%s]\uff0c\u5217\uff1a[%s]\uff0c\u83b7\u53d6\u5230\u7684\u5355\u5143\u683c\u6570\u636e\uff1a[%s]", sheet.getSheetName(), metadata2.getRow(), metadata2.getCol(), cellValue));
        }
        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(keySet) || !reportCalcModelMap.containsKey(keySet)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u4f5c\u8868sheet\u9875\uff1a%1$s\uff0c\u9875\u9762\u7ef4\u4fe1\u606f\u4e0e\u8be5\u7f16\u62a5\u671f\u95f4\u4e0b\u7cfb\u7edf\u5df2\u6709\u7684\u8ba1\u5212\u7f16\u5236\u5355\u636e\u7684\u8868\u201c%2$s\u201d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportImportDataBizServiceImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), report.getNumber()));
        }
        ReportCalcModel reportCalcModel = reportCalcModelMap.get(keySet);
        return reportCalcModel;
    }

    private String getDimensionMemberMapKey(String dimensionNumber, String memberNumber) {
        return dimensionNumber + "_" + memberNumber;
    }

    private void sumDataToParent(Report report, FundPlanSystem system) {
        if (!report.getTemplate().isMainTable()) {
            Long parentReportId = this.reportRepository.queryParentReportId(report.getId());
            ReportNeedPropDTO propDTO = new ReportNeedPropDTO();
            TreeSet<Long> reportIdSet = new TreeSet<Long>();
            reportIdSet.add(parentReportId);
            propDTO.setNeedTemplate(true);
            propDTO.setNeedCompanyMember(true);
            propDTO.setNeedPeriodMember(true);
            Report parentReport = this.reportRepository.loadSimpleReport(reportIdSet, propDTO).get(0);
            boolean subDataEmpty = CollectionUtils.isEmpty(report.getReportDataList());
            if (subDataEmpty) {
                ReportDataQueryObject queryObject = new ReportDataQueryObject();
                queryObject.setReportIdS(Lists.newArrayList((Object[])new Long[]{report.getId()}));
                queryObject.setMainTable(false);
                List<ReportDataQueryResult> subReportDataResults = this.dataQueryService.queryReportData(queryObject);
                if (!CollectionUtils.isEmpty(subReportDataResults)) {
                    List<ReportData> subReportDataList = ReportHelper.convert(subReportDataResults);
                    subReportDataList.forEach(ReportData::clearAmt);
                    report.setReportDataList(subReportDataList);
                    logger.info("summarySubData2Main \u5b50\u8868\u6570\u636e\u6e05\u7a7a\uff0c\u6e05\u7a7a\u4e3b\u8868\u6570\u636e");
                }
            }
            this.reportService.sumToParent(parentReport, report, system);
            if (subDataEmpty) {
                report.setReportDataList(new ArrayList<ReportData>(0));
            }
            ReportHelper.checkReportDataAmt(parentReport);
            this.dataSaveService.saveReportData(parentReport.getReportDataList(), parentReport.getSystemId());
        }
    }
}

