/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.BasedataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ReportOpType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.BizReportQueryParam;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataWrapper;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateMetric;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.helper.ReportMutexHelper;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportQDTO;
import kd.tmc.fpm.business.mvc.repository.impl.ControlRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.IReportManageService;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.spread.datamanager.CellDataUpdateInfo;
import kd.tmc.fpm.business.spread.datamanager.CopyDataInfo;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.ReportDataManagerFactoryV2;
import kd.tmc.fpm.business.spread.datamanager.ReportDataReceiverFactory;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.impl.SpreadAuxiliaryDataReceiver;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.business.utils.MutexAuxiliarySaveHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.utils.CollectionBuildUtil;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.spread.command.event.AskExecuteEvent;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import org.apache.commons.collections.CollectionUtils;

public class ReportManageService
implements IReportManageService {
    private IDimensionRepository dimRepo = new DimensionRepository();
    private IReportBizService reportBizService = new ReportBizService();
    private IReportRepository reportRep = new ReportRepository();
    private IControlRepository controlRepository = new ControlRepository();
    private IReportRepository reportRepo = new ReportRepository();

    @Override
    public FpmOperateResult<IReportDataManagerV2> loadReport(Long reportId, Long systemId, boolean isSmartVersion, IFpmPageCacheService cacheService) {
        FundPlanSystem system = this.dimRepo.loadSystem(systemId);
        FpmOperateResult<Report> reportFpmOperateResult = this.reportBizService.loadReportContainRefData(reportId, system);
        if (!reportFpmOperateResult.isSuccess()) {
            return FpmOperateResult.error(reportFpmOperateResult.getMessageList());
        }
        Report report = reportFpmOperateResult.getData();
        ReportHelper.resetDetailReportRowWithoutDirtyFlag(report, system);
        ReportDataManagerV2 manager = this.buildManager(isSmartVersion, cacheService, system, report);
        return FpmOperateResult.success(manager);
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> loadReportByParam(BizReportQueryParam param, IFpmPageCacheService cacheService) {
        FpmAssertUtil.isNotNull((Object)param, (String)"query param is null");
        FpmAssertUtil.isNotNull((Object)param.getBodySysId(), (String)"query param body system id is null");
        FpmAssertUtil.isNotNull((Object)param.getReportId(), (String)"query param report id is null");
        FundPlanSystem system = this.dimRepo.loadSystem(param.getBodySysId());
        FpmOperateResult<Report> reportFpmOperateResult = this.reportBizService.loadReportContainRefData(param.getReportId(), system);
        if (!reportFpmOperateResult.isSuccess()) {
            return FpmOperateResult.error(reportFpmOperateResult.getMessageList());
        }
        Report report = reportFpmOperateResult.getData();
        this.filterByDim(param, report, system);
        ReportHelper.resetDetailReportRowWithoutDirtyFlag(report, system);
        ReportDataManagerV2 manager = this.buildManager(param.isSmartVersion(), cacheService, system, report);
        return FpmOperateResult.success(manager);
    }

    private void filterByDim(BizReportQueryParam param, Report report, FundPlanSystem system) {
        if (!param.isFilterByDimVal()) {
            return;
        }
        Map<Long, List<Object>> dimFilterMap = param.getDimFilterMap();
        List<ReportData> reportDataList = report.getReportDataList();
        if (CollectionUtils.isEmpty(reportDataList)) {
            return;
        }
        QueryIndexInfo indexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(reportDataList, system);
        ArrayList<Long> dimList = new ArrayList<Long>(dimFilterMap.size());
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(dimFilterMap.size());
        for (Map.Entry<Long, List<Object>> dimEntry : dimFilterMap.entrySet()) {
            dimList.add(dimEntry.getKey());
            dimValList.add(dimEntry.getValue());
        }
        List cartesianProduct = Lists.cartesianProduct(dimValList);
        List dimensionInfoBeans = cartesianProduct.stream().map(item -> DimensionInfoBean.of((List)dimList, (List)item)).collect(Collectors.toList());
        List<ReportData> result = dimensionInfoBeans.stream().map(indexInfo::findList).flatMap(Collection::stream).collect(Collectors.toList());
        report.setReportDataList(result);
    }

    @Override
    public FpmOperateResult<ReportCalcModel> loadReportCalcModelByPageDim(IReportDataManagerV2 manager, List<Long> pageDimS, boolean isSmartVersion, CellDataSource dataSource) {
        FpmOperateResult<Boolean> saveResult;
        FundPlanSystem system = manager.getSystem();
        Long reportId = manager.getReportId();
        ReportTemplate template = manager.getReportTemplate();
        DynamicObject reportObj = QueryServiceHelper.queryOne((String)"fpm_report", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
        Report report = null;
        if (BillStatusEnum.SAVE.getValue().equals(reportObj.getString("billstatus")) && !(saveResult = this.saveReport(manager, system, report = this.reportRep.loadReportWithAllDimension(reportId), dataSource)).isSuccess()) {
            return FpmOperateResult.error(saveResult.getMessageList());
        }
        FpmOperateResult<Report> reportFpmOperateResult = this.reportBizService.loadReportContainRefData(reportId, system);
        if (!reportFpmOperateResult.isSuccess()) {
            return FpmOperateResult.error(reportFpmOperateResult.getMessageList());
        }
        report = reportFpmOperateResult.getData();
        ReportHelper.resetDetailReportRowWithoutDirtyFlag(report, system);
        if (isSmartVersion) {
            report.setReferencePeriodType(null);
            List<TemplateMetric> metrics = template.getMetrics();
            metrics = metrics.stream().filter(item -> item.getMetricType() == TemplateMetricType.PLANAMT).collect(Collectors.toList());
            template.setMetrics(metrics);
            IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getReportSmartVersionExecutor(system, report, pageDimS);
            ReportModel reportModel = new ReportModel();
            reportExecutor.executeAction(reportModel);
            manager.setCurrCalcModel(reportModel.getReportCalcModelList().get(0));
            manager.updateFormulaManager();
        } else {
            IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getReportExecutor(system, report, pageDimS);
            ReportModel reportModel = reportExecutor.executeAction();
            manager.setCurrCalcModel(reportModel.getReportCalcModelList().get(0));
            manager.updateFormulaManager();
        }
        return FpmOperateResult.success(manager.getCurrCalcModel());
    }

    @Override
    public FpmOperateResult<Boolean> saveReport(IReportDataManagerV2 dataManager, CellDataSource dataSource) {
        Report report;
        FundPlanSystem system = dataManager.getSystem();
        FpmOperateResult<Boolean> saveResult = this.saveReport(dataManager, system, report = this.reportRep.loadReportWithAllDimension(dataManager.getReportId()), dataSource);
        if (!saveResult.isSuccess()) {
            return FpmOperateResult.error(saveResult.getMessageList());
        }
        dataSource.updateCellAndClearDirty(dataSource.getAllCell());
        return FpmOperateResult.success(true);
    }

    private FpmOperateResult<Boolean> saveReportWithLock(IReportDataManagerV2 dataManager, FundPlanSystem system, Report report, CellDataSource dataSource) {
        Long parentId;
        if (!report.getTemplate().isMainTable() && this.mainReportLockValidator(parentId = this.reportRepo.queryParentReportId(report.getId())).booleanValue()) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fpm_report", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentId)});
            String userName = ReportMutexHelper.getMutexUserNameByOpKey(StringHelper.getStringValue((Object)parentId), "lockMainReport", "fpm_report");
            String message = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6240\u5bf9\u5e94\u7684\u4e3b\u8868\u201c%2$s\u201d\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u9000\u51fa\u4e3b\u8868\u7f16\u8f91\u624d\u80fd\u63d0\u4ea4\u672c\u62a5\u8868\u3002", (String)"ReportManageService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), report.getName(), dynamicObject == null ? "" : dynamicObject.getString("name"));
            if (EmptyUtil.isNoEmpty((String)userName)) {
                message = String.format(ResManager.loadKDString((String)"\u7528\u6237\u3010%1$s\u3011\u6b63\u5728\u7f16\u8f91\u3010%2$s\u3011\u6240\u5bf9\u5e94\u7684\u4e3b\u8868\u3010%3$s\u3011\uff0c\u9000\u51fa\u4e3b\u8868\u7f16\u8f91\u65b9\u53ef\u63d0\u4ea4\u672c\u62a5\u8868\uff01", (String)"ReportManageService_4", (String)"tmc-fpm-business", (Object[])new Object[0]), userName, report.getName(), dynamicObject == null ? "" : dynamicObject.getString("name"));
            }
            return FpmOperateResult.error(message);
        }
        return this.saveReport(dataManager, system, report, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean mainReportLockValidator(Long mainReportId) {
        ArrayList<String> reportIdS = new ArrayList<String>(1);
        ArrayList<String> requestSuccessIds = new ArrayList<String>(1);
        ArrayList<String> requestFailIds = new ArrayList<String>(1);
        reportIdS.add(mainReportId.toString());
        try {
            Map request = MutexServiceHelper.batchRequest(reportIdS, (String)"fpm_report", (String)"lockMainReport");
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    requestSuccessIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                Boolean bl = true;
                return bl;
            }
        }
        finally {
            MutexServiceHelper.batchRelease(requestSuccessIds, (String)"fpm_report", (String)"lockMainReport");
        }
        return false;
    }

    private FpmOperateResult<Boolean> saveReport(IReportDataManagerV2 dataManager, FundPlanSystem system, Report report, CellDataSource dataSource) {
        report.setTemplate(dataManager.getReportTemplate());
        boolean isSplit = report.getTemplate().getMetricTplDim() != null && !report.getTemplate().getTemplateType().isDetail();
        DynamicObjectCollection metricDOS = null;
        if (isSplit) {
            metricDOS = MetricValueUtils.queryMetricMemberBySystemId(report.getSystemId());
            MetricValueUtils.splitReportMetric(report, metricDOS);
        }
        this.saveRefAuxData(dataManager, report, system, dataSource);
        dataManager.reverseDataToReportDataReceiver(dataSource, ReportDataReceiverFactory.createReportDataReceiver(report));
        ReportHelper.checkReportData(report, system);
        this.setInitFlagIfNeed(report, system, dataSource);
        report.setInformantErId(RequestContext.get().getCurrUserId());
        if (isSplit) {
            MetricValueUtils.mergeMetric(report, metricDOS);
            report.rebuildTree(system);
        }
        return this.reportBizService.saveReport(report, system);
    }

    private void saveRefAuxData(IReportDataManagerV2 dataManager, Report report, FundPlanSystem system, CellDataSource dataSource) {
        if (report.getTemplate().getTemplateType().isDetail()) {
            return;
        }
        PeriodMember referencePeriodMember = report.getReferencePeriodMember();
        if (report.getReferencePeriodType() == null || referencePeriodMember == null) {
            return;
        }
        ReportQDTO reportQDTO = new ReportQDTO();
        reportQDTO.setReportOrgId(report.getCompanyMemberList().get(0).getId());
        reportQDTO.setReportPeriodId(referencePeriodMember.getId());
        reportQDTO.setReportPlanType(ReportPlanType.REPORTPLAN);
        reportQDTO.setReportStatus(ReportStatus.ENABLE);
        List<Report> refReportList = this.reportRepo.loadSimpleReport(reportQDTO, propDTO -> {
            propDTO.setNeedReportStatus(true);
            propDTO.setNeedCompanyMember(true);
            propDTO.setNeedPeriodMember(true);
        });
        if (EmptyUtil.isEmpty(refReportList)) {
            return;
        }
        Report referenceReport = refReportList.get(0);
        ArrayList<ReportDataWrapper> reportDataWrapperList = new ArrayList<ReportDataWrapper>(16);
        MutexAuxiliarySaveHelper.MutexAuxiliarySaveInfo saveInfo = new MutexAuxiliarySaveHelper.MutexAuxiliarySaveInfo(referenceReport.getId(), report, MutexAuxiliarySaveHelper.InputType.REPORT);
        dataManager.reverseDataToReportDataReceiver(dataSource, new SpreadAuxiliaryDataReceiver(referenceReport, reportDataWrapperList, true));
        if (EmptyUtil.isNoEmpty(reportDataWrapperList)) {
            saveInfo.setInputType(MutexAuxiliarySaveHelper.InputType.REPORT_CONTAINS_REFERENCE);
            saveInfo.setId(referenceReport.getId());
            saveInfo.setReport(referenceReport);
        }
        MutexAuxiliarySaveHelper mutexAuxiliarySaveHelper = MutexAuxiliarySaveHelper.getInstance(saveInfo);
        mutexAuxiliarySaveHelper.saveOrUpdateAuxiliaryReportDataForFix(reportDataWrapperList);
    }

    private void setInitFlagIfNeed(Report report, FundPlanSystem system, CellDataSource cellDataSource) {
        if (report.getInitFlag().booleanValue()) {
            return;
        }
        List<TemplateDim> pageDimList = report.getTemplate().getPageDimList();
        report.setInitFlag(Boolean.TRUE);
        if (EmptyUtil.isEmpty(pageDimList)) {
            return;
        }
        ArrayList<Long> dimensionIdList = new ArrayList<Long>(16);
        ArrayList dimMemList = new ArrayList(16);
        ArrayList<List<Long>> pageDimMemIdList = new ArrayList<List<Long>>(16);
        for (TemplateDim templateDim : pageDimList) {
            pageDimMemIdList.add(templateDim.getMemberScope());
            dimensionIdList.add(templateDim.getDimensionId());
        }
        List pageDescartes = CollectionBuildUtil.descartes(pageDimMemIdList);
        if (pageDescartes.size() == 1) {
            return;
        }
        List<ReportCalcVal> pageCalcValList = cellDataSource.getMeta().getPageCalcValList();
        List<ReportData> dataList = this.buildRollData(report, system, pageCalcValList);
        report.getReportDataList().addAll(dataList);
        if (report.getTemplate().getTemplateType() == TemplateType.DETAIL) {
            this.batchSetReportDataId(report.getReportDataList());
            return;
        }
        DimensionInfoBean findBean = new DimensionInfoBean();
        findBean.setDimensionIdList(dimensionIdList);
        findBean.setMemberIdList(dimMemList);
        ArrayList colAndRowDimMemList = new ArrayList(16);
        report.getTemplate().getAllTemplateDim().stream().filter(item -> item.getLocation() != DimLocation.PAGE).forEach(item -> {
            if (item.getDimType() == DimensionType.PERIOD && report.getReportPeriodType().getDetailPeriodType() != null) {
                List<PeriodMember> periodMemberList;
                List<PeriodMember> memberList = periodMemberList = report.getPeriodMemberList();
                List rollPeriodMembers = Collections.emptyList();
                if (!report.isRollContainsDetail()) {
                    PeriodMember periodMember = periodMemberList.get(0);
                    memberList = Collections.singletonList(periodMember);
                    rollPeriodMembers = periodMemberList.subList(1, periodMemberList.size()).stream().map(DimMember::getId).collect(Collectors.toList());
                }
                List memberScope = memberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
                memberScope.addAll(rollPeriodMembers);
                colAndRowDimMemList.add(memberScope);
            } else {
                colAndRowDimMemList.add(item.getMemberScope());
            }
            dimensionIdList.add(item.getDimensionId());
        });
        List colAndRowDescartes = CollectionBuildUtil.descartes(colAndRowDimMemList);
        List currPageDimMemList = pageCalcValList.stream().map(o -> (Long)o.getValue()).collect(Collectors.toList());
        ArrayList<TemplateDim> allTemplateDim = new ArrayList<TemplateDim>(report.getTemplate().getAllTemplateDim());
        Map templateDimMap = allTemplateDim.stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
        ArrayList targetTplDimList = new ArrayList(allTemplateDim.size());
        for (Long dimId : findBean.getDimensionIdList()) {
            targetTplDimList.add(templateDimMap.remove(dimId));
        }
        ArrayList<ReportData> newReportDataList = new ArrayList<ReportData>(32);
        DimensionIndexTree indexTree = report.getIndexTree(system);
        for (List pageDimMemIdS : pageDescartes) {
            if (pageDimMemIdS.containsAll(currPageDimMemList)) continue;
            for (List colAndRowMemIdS : colAndRowDescartes) {
                dimMemList.clear();
                dimMemList.addAll(pageDimMemIdS);
                dimMemList.addAll(colAndRowMemIdS);
                TreeNode treeNode = indexTree.find(findBean);
                if (treeNode == null || !CollectionUtils.isEmpty(treeNode.getDataList())) continue;
                ReportData reportData = new ReportData();
                reportData.setVersion(1);
                reportData.setLinkedReportId(report.getId());
                reportData.setDimList(new ArrayList<TemplateDim>(targetTplDimList));
                reportData.setDimValList(new ArrayList<Object>(findBean.getMemberIdList()));
                reportData.setReportPeriodId(report.getPeriodMemberList().get(0).getId());
                reportData.setMainTable(report.getTemplate().isMainTable());
                reportData.setAmountUnit(report.getTemplate().getAmountUnit());
                reportData.setBigDecimalValueOrDefault(BigDecimal.ZERO);
                reportData.setPlanAmt(BigDecimal.ZERO);
                reportData.setActAmt(BigDecimal.ZERO);
                reportData.setLockAmt(BigDecimal.ZERO);
                reportData.setOffsetAmt(BigDecimal.ZERO);
                reportData.setReportPlanAmt(BigDecimal.ZERO);
                reportData.setOriginalPlanAmt(BigDecimal.ZERO);
                treeNode.addData(reportData);
                newReportDataList.add(reportData);
            }
        }
        report.getReportDataList().addAll(newReportDataList);
        this.batchSetReportDataId(report.getReportDataList());
    }

    private void batchSetReportDataId(List<ReportData> reportDataList) {
        long count = reportDataList.stream().filter(reportData -> reportData.getId() == null).count();
        LinkedList<Long> idQueue = new LinkedList<Long>();
        if (count > 0L) {
            long[] idArr;
            for (long id : idArr = DB.genGlobalLongIds((int)((int)count))) {
                idQueue.offer(id);
            }
        }
        for (ReportData reportData2 : reportDataList) {
            if (reportData2.getId() != null) continue;
            reportData2.setId((Long)idQueue.poll());
            reportData2.setDirty(true);
        }
    }

    private List<ReportData> buildRollData(Report report, FundPlanSystem system, List<ReportCalcVal> pageCalcValList) {
        Map dimMap = system.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        FpmOperateResult<List<ReportData>> rollDataResult = this.reportBizService.loadRollReportData(report, system, report.getTemplate().getTemplateType() == TemplateType.FIXED);
        List<ReportData> rollDataList = rollDataResult.getData();
        ArrayList<ReportData> needRemoveList = new ArrayList<ReportData>(16);
        for (ReportData reportData : rollDataList) {
            boolean needRemove = true;
            for (ReportCalcVal reportCalcVal : pageCalcValList) {
                Long dimensionId = reportCalcVal.getDimensionId();
                Object value = reportCalcVal.getValue();
                if (reportData.getDimValByDimType(((Dimension)dimMap.get(dimensionId)).getDimType(), null).equals(value)) continue;
                needRemove = false;
                break;
            }
            if (!needRemove) continue;
            needRemoveList.add(reportData);
        }
        rollDataList.removeAll(needRemoveList);
        needRemoveList.clear();
        if (report.getTemplate().getTemplateType() == TemplateType.FIXED) {
            DimensionIndexTree indexTree = report.getIndexTree(system);
            DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
            for (ReportData reportData : rollDataList) {
                List dimIdList = reportData.getDimList().stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
                List<Object> dimValList = reportData.getDimValList();
                dimensionInfoBean.setDimensionIdList(dimIdList);
                dimensionInfoBean.setMemberIdList(dimValList);
                TreeNode treeNode = indexTree.find(dimensionInfoBean);
                if (treeNode == null || !CollectionUtils.isNotEmpty(treeNode.getDataList())) continue;
                needRemoveList.add(reportData);
            }
            report.clearIndexTree();
        }
        rollDataList.removeAll(needRemoveList);
        return rollDataList;
    }

    @Override
    public FpmOperateResult<List<Cell>> updateReportData(IReportDataManagerV2 dataManager, CellDataSource cellDataSource, List<CellDataUpdateInfo> updateInfoList) {
        List<CellDataUpdateInfo> rebuildList = this.rebuildUpdateCellsIfNeed(updateInfoList, dataManager, cellDataSource);
        dataManager.updateCellData(rebuildList, cellDataSource);
        return FpmOperateResult.success(dataManager.getNeedUpdateValList());
    }

    @Override
    public FpmOperateResult<List<Cell>> updateTotalRows(IReportDataManagerV2 dataManager, CellDataSource cellDataSource, List<CellDataUpdateInfo> updateInfoList) {
        dataManager.updateTotalRows(updateInfoList, cellDataSource);
        return FpmOperateResult.success(dataManager.getNeedUpdateValList());
    }

    @Override
    public FpmOperateResult<List<Cell>> clearTotalRows(IReportDataManagerV2 dataManager, CellDataSource cellDataSource) {
        dataManager.clearTotalRows(cellDataSource);
        return FpmOperateResult.success(dataManager.getNeedUpdateValList());
    }

    @Override
    public FpmOperateResult<List<Cell>> copyDataHandle(IReportDataManagerV2 manager, CellDataSource cellDataSource, List<CopyDataInfo> copyDataInfoList) {
        Cell firstData;
        if (CollectionUtils.isEmpty(copyDataInfoList) || manager.getReportTemplate().getTemplateType() == TemplateType.FIXED) {
            return FpmOperateResult.success(new ArrayList(1));
        }
        copyDataInfoList.forEach(item -> {
            if (item.getVal() == null) {
                item.setVal("");
            }
        });
        CacheCellMeta meta = cellDataSource.getMeta();
        Map<Integer, Map<Integer, List<CopyDataInfo>>> colAndRowCopyDataMap = copyDataInfoList.stream().collect(Collectors.groupingBy(CopyDataInfo::getCol, Collectors.groupingBy(CopyDataInfo::getRow)));
        ArrayList needHandleDataList = new ArrayList(copyDataInfoList.size());
        copyDataInfoList.forEach(item -> needHandleDataList.add(cellDataSource.getCell(item.getRow(), item.getCol())));
        ArrayList<CellDataUpdateInfo> updateInfoList = new ArrayList<CellDataUpdateInfo>(needHandleDataList.size());
        FundPlanSystem system = manager.getSystem();
        Dimension opNameDim = system.getDetailDimensionByDetailType(DetailDimType.COUNTERPARTY_NAME);
        Dimension opTypeDim = system.getDetailDimensionByDetailType(DetailDimType.CONNTERPARTY_TYPE);
        List<ReportCalcVal> colDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        Optional<ReportCalcVal> opNameOptional = colDimValList.stream().filter(item -> opNameDim.getId().equals(item.getDimensionId())).findFirst();
        Optional<ReportCalcVal> opTypeOptional = colDimValList.stream().filter(item -> opTypeDim.getId().equals(item.getDimensionId())).findFirst();
        int opNameCol = -1;
        if (opNameOptional.isPresent()) {
            ReportCalcVal reportCalcVal = opNameOptional.get();
            opNameCol = reportCalcVal.getCol();
        }
        int opTypeColTep = -1;
        ReportCalcVal opTypeCalcVal = null;
        if (opTypeOptional.isPresent()) {
            opTypeCalcVal = opTypeOptional.get();
            opTypeColTep = opTypeCalcVal.getCol();
        }
        int opTypeCol = opTypeColTep;
        List opTypeDataList = needHandleDataList.stream().filter(item -> item.getCellType() == CellTypeEnum.MUTITYPEWIDGET && item.getCol() == opTypeCol).collect(Collectors.toList());
        for (Cell reportCalcVal : opTypeDataList) {
            CacheCell cell;
            int row = reportCalcVal.getRow();
            int col = reportCalcVal.getCol();
            if (opTypeCalcVal == null) continue;
            ReportValueType valueType = opTypeCalcVal.getValueType();
            Map extMap = (Map)valueType.getValue();
            Map<Integer, List<CopyDataInfo>> colDataMap = colAndRowCopyDataMap.get(col);
            List<CopyDataInfo> copyDataInfoS = colDataMap.get(row);
            if (!CollectionUtils.isNotEmpty(copyDataInfoS)) continue;
            CopyDataInfo copyDataInfo = copyDataInfoS.get(0);
            String copyDataVal = copyDataInfo.getVal().toString().trim();
            Object key = extMap.get(copyDataVal);
            if (!Objects.isNull(key)) {
                if (opNameCol >= 0) {
                    cell = cellDataSource.getCell(copyDataInfo.getRow(), opNameCol);
                    cell.setWidgetValue(key);
                }
            } else if (opNameCol >= 0) {
                cell = cellDataSource.getCell(copyDataInfo.getRow(), opNameCol);
                CellDataUpdateInfo cellDataUpdateInfo = new CellDataUpdateInfo(cell.getRow(), cell.getCol(), null);
                updateInfoList.add(cellDataUpdateInfo);
            }
            CellDataUpdateInfo cellDataUpdateInfo = new CellDataUpdateInfo(row, col, key);
            updateInfoList.add(cellDataUpdateInfo);
        }
        List f7DataList = needHandleDataList.stream().filter(item -> item.getCellType() == CellTypeEnum.F7WIDGET && !StringUtils.isEmpty((Object)item.getWidgetValue())).collect(Collectors.toList());
        Map<Integer, List<Cell>> f7ColMap = f7DataList.stream().collect(Collectors.groupingBy(item -> item.getCol()));
        for (Map.Entry<Integer, List<Cell>> next : f7ColMap.entrySet()) {
            List<Cell> currDataList = next.getValue();
            Map<Object, List<Cell>> f7TypeColMap = currDataList.stream().collect(Collectors.groupingBy(item -> item.getWidgetValue()));
            for (Map.Entry<Object, List<Cell>> f7TypeNext : f7TypeColMap.entrySet()) {
                String f7EntityType = f7TypeNext.getKey().toString();
                currDataList = f7TypeNext.getValue();
                firstData = currDataList.get(0);
                HashSet nameSet = new HashSet(16);
                currDataList.forEach(item -> {
                    Map copyDataColMap = (Map)colAndRowCopyDataMap.get(item.getCol());
                    List copyDataInfoS = (List)copyDataColMap.get(item.getRow());
                    nameSet.addAll(copyDataInfoS.stream().map(o -> o.getVal().toString().trim()).filter(str -> !StringUtils.isEmpty((Object)str)).collect(Collectors.toSet()));
                });
                if (nameSet.size() == 0) continue;
                List<QFilter> filter = this.getF7Filter(system, manager.getReportTemplate(), colDimValList, (CacheCell)firstData, null);
                BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)f7EntityType);
                String nameProperty = basedataEntityType.getNameProperty();
                if (StringUtils.isEmpty((Object)nameProperty)) continue;
                QFilter nameQFilter = new QFilter(nameProperty, "in", nameSet);
                filter.add(nameQFilter);
                DynamicObjectCollection dbDataColl = QueryServiceHelper.query((String)f7EntityType, (String)"id,name", (QFilter[])filter.toArray(new QFilter[0]));
                Map nameAndIdMap = dbDataColl.stream().collect(Collectors.toMap(item -> item.getString("name"), Function.identity(), (k1, k2) -> k1));
                currDataList.stream().forEach(item -> {
                    Map copyDataRowMap = (Map)colAndRowCopyDataMap.get(item.getCol());
                    List copyDataInfoS = (List)copyDataRowMap.get(item.getRow());
                    String val = ((CopyDataInfo)copyDataInfoS.get(0)).getVal().toString();
                    val = val.trim();
                    DynamicObject dbData = (DynamicObject)nameAndIdMap.get(val);
                    CellDataUpdateInfo cellDataUpdateInfo = null;
                    cellDataUpdateInfo = dbData != null ? new CellDataUpdateInfo(item.getRow(), item.getCol(), dbData.getLong("id")) : new CellDataUpdateInfo(item.getRow(), item.getCol(), null);
                    updateInfoList.add(cellDataUpdateInfo);
                });
            }
        }
        List f7NoTypeDataList = needHandleDataList.stream().filter(item -> item.getCellType() == CellTypeEnum.F7WIDGET && StringUtils.isEmpty((Object)item.getWidgetValue())).collect(Collectors.toList());
        for (Cell reportCalcVal : f7NoTypeDataList) {
            CellDataUpdateInfo cellDataUpdateInfo = new CellDataUpdateInfo(reportCalcVal.getRow(), reportCalcVal.getCol(), reportCalcVal.getValue());
            updateInfoList.add(cellDataUpdateInfo);
        }
        List enumDataList = needHandleDataList.stream().filter(item -> item.getCellType() == CellTypeEnum.DOWNBOXWIDGET).collect(Collectors.toList());
        Map<Integer, List<Cell>> enumDataColMap = enumDataList.stream().collect(Collectors.groupingBy(item -> item.getCol()));
        for (Map.Entry<Integer, List<Cell>> next : enumDataColMap.entrySet()) {
            List<Cell> currColDataList = next.getValue();
            firstData = currColDataList.get(0);
            Map enumValueMap = (Map)firstData.getWidgetValue();
            currColDataList.stream().forEach(item -> {
                Map copyDataRowMap = (Map)colAndRowCopyDataMap.get(item.getCol());
                List copyDataInfoS = (List)copyDataRowMap.get(item.getRow());
                String val = ((CopyDataInfo)copyDataInfoS.get(0)).getVal().toString();
                CellDataUpdateInfo cellDataUpdateInfo = null;
                cellDataUpdateInfo = enumValueMap.containsKey(val) ? new CellDataUpdateInfo(item.getRow(), item.getCol(), val) : new CellDataUpdateInfo(item.getRow(), item.getCol(), null);
                updateInfoList.add(cellDataUpdateInfo);
            });
        }
        List<CellDataUpdateInfo> rebuildUpdateInfoList = this.rebuildUpdateCellsIfNeed(updateInfoList, manager, cellDataSource);
        manager.updateCellData(rebuildUpdateInfoList, cellDataSource);
        return FpmOperateResult.success(manager.getNeedUpdateValList());
    }

    private List<CellDataUpdateInfo> rebuildUpdateCellsIfNeed(List<CellDataUpdateInfo> updateInfoList, IReportDataManagerV2 dataManager, CellDataSource cellDataSource) {
        ReportTemplate reportTemplate = dataManager.getReportTemplate();
        if (!reportTemplate.getTemplateType().isDetail()) {
            return updateInfoList;
        }
        int subjectCol4UpdateFlowCol = ReportHelper.getSubjectColIfNeedUpdateSubjectFlow(reportTemplate, cellDataSource.getMeta().getColDimTree());
        if (subjectCol4UpdateFlowCol < 0) {
            return updateInfoList;
        }
        List subjectUpdateInfoList = updateInfoList.stream().filter(info -> info.getCol() == subjectCol4UpdateFlowCol).collect(Collectors.toList());
        Set subjectMemberIdSet = subjectUpdateInfoList.stream().map(CellDataUpdateInfo::getVal).filter(Objects::nonNull).map(o -> (Long)o).collect(Collectors.toSet());
        Map<Object, Object> memberId2FlowMap = new HashMap(2, 1.0f);
        if (CollectionUtils.isNotEmpty(subjectMemberIdSet)) {
            FundPlanSystem system = dataManager.getSystem();
            Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
            memberId2FlowMap = subjectDim.getAllDimMemberList(AccountMember.class).stream().filter(item -> subjectMemberIdSet.contains(item.getId())).collect(Collectors.toMap(key -> key.getId(), val -> val.getFlowType(), (a, b) -> b));
        }
        ArrayList<CellDataUpdateInfo> subjectFlowUpdateInfoList = new ArrayList<CellDataUpdateInfo>(subjectUpdateInfoList.size());
        for (CellDataUpdateInfo info2 : subjectUpdateInfoList) {
            if (info2.getCol() != subjectCol4UpdateFlowCol) continue;
            CacheCell subjectCacheCell = cellDataSource.getCell(info2.getRow(), info2.getCol());
            info2.setOldVal(subjectCacheCell.getValue());
            int flowCellRow = info2.getRow();
            int flowCellCol = info2.getCol() + 1;
            CacheCell subjectFlowCacheCell = cellDataSource.getCell(flowCellRow, flowCellCol);
            Object flowOldVal = subjectFlowCacheCell.getValue();
            FlowType newFlowType = (FlowType)((Object)memberId2FlowMap.get(info2.getVal()));
            Long flowNewVal = Objects.isNull((Object)newFlowType) ? null : Long.valueOf(newFlowType.getVirtualId());
            CellDataUpdateInfo subjectFlowUpdateInfo = new CellDataUpdateInfo(flowCellRow, flowCellCol, (Object)flowNewVal, flowOldVal);
            subjectFlowUpdateInfoList.add(subjectFlowUpdateInfo);
        }
        ArrayList<CellDataUpdateInfo> rebuildList = new ArrayList<CellDataUpdateInfo>(updateInfoList.size() + subjectFlowUpdateInfoList.size());
        rebuildList.addAll(updateInfoList);
        rebuildList.addAll(subjectFlowUpdateInfoList);
        return rebuildList;
    }

    @Override
    public FpmOperateResult<List<QFilter>> getF7Filter(IReportDataManagerV2 manager, CellDataSource dataSource, int row, int col, String name) {
        FundPlanSystem system = manager.getSystem();
        ReportTemplate reportTemplate = manager.getReportTemplate();
        CacheCell cell = dataSource.getCell(row, col);
        CacheCellMeta meta = dataSource.getMeta();
        ReportCalcTree colDimTree = meta.getColDimTree();
        List<ReportCalcVal> dimCalcValList = colDimTree.getDimCalcValList(col, 0);
        return FpmOperateResult.success(this.getF7Filter(system, reportTemplate, dimCalcValList, cell, name));
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> audit(IReportDataManagerV2 manager, CellDataSource cellDataSource) {
        TmcOperateServiceHelper.execOperate((String)"audit", (String)"fpm_report", (Object[])new Object[]{manager.getReportId()}, (OperateOption)OperateOption.create());
        return FpmOperateResult.success(manager);
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> unAudit(IReportDataManagerV2 manager, CellDataSource cellDataSource) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ReportOpType", ReportOpType.OP.getNumber());
        TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"fpm_report", (Object[])new Object[]{manager.getReportId()}, (OperateOption)operateOption);
        return FpmOperateResult.success(manager);
    }

    @Override
    public FpmOperateResult<Boolean> submit(IReportDataManagerV2 manager, CellDataSource dataSource) {
        Report report = this.reportRep.loadReportWithAllDimension(manager.getReportId());
        ReportTemplate reportTemplate = manager.getReportTemplate();
        report.setTemplate(reportTemplate);
        FundPlanSystem system = manager.getSystem();
        FpmOperateResult<Boolean> saveResult = this.saveReportWithLock(manager, system, report, dataSource);
        if (!saveResult.isSuccess()) {
            return FpmOperateResult.warn(String.join((CharSequence)",", saveResult.getMessageList()));
        }
        dataSource.updateCellAndClearDirty(dataSource.getAllCell());
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ReportOpType", ReportOpType.OP.getNumber());
        TmcOperateServiceHelper.execOperate((String)"submitop", (String)"fpm_report", (Object[])new Object[]{manager.getReportId()}, (OperateOption)operateOption);
        return FpmOperateResult.success(true);
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> unSubmit(IReportDataManagerV2 manager, CellDataSource cellDataSource) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ReportOpType", ReportOpType.SERVICE.getNumber());
        TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"fpm_report", (Object[])new Object[]{manager.getReportId()}, (OperateOption)operateOption);
        return FpmOperateResult.success(manager);
    }

    @Override
    public FpmOperateResult<Void> closeReportPlan(IReportDataManagerV2 manager) {
        return FpmOperateResult.success();
    }

    @Override
    public FpmOperateResult<List<Cell>> deleteRows(IReportDataManagerV2 manager, CellDataSource dataSource, AskExecuteEvent event) {
        FpmOperateResult<List<Cell>> result = FpmOperateResult.success();
        List rows = ((List)event.getParams()).stream().filter(Objects::nonNull).filter(o -> o != 0).sorted().collect(Collectors.toList());
        ArrayList updateCells = new ArrayList(10);
        if (rows.size() == 0) {
            result.setData(updateCells);
            return result;
        }
        Integer maxLineCount = manager.getReportTemplate().getMaxLineCount();
        Integer totalRow = manager.getReportTemplate().getTotalRow();
        List rowsGTMaxRow = rows.stream().filter(index -> index > maxLineCount + totalRow).map(integer -> integer + 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rowsGTMaxRow)) {
            String moreThanMaxLines = rowsGTMaxRow.stream().map(Object::toString).collect(Collectors.joining("\u3001"));
            String errorMessage = String.format(ResManager.loadKDString((String)"\u5f85\u5220\u9664\u7684\u7b2c%1$s\u884c\u5927\u4e8e\u660e\u7ec6\u8868\u6a21\u677f\u8bbe\u7f6e\u7684\u6700\u5927\u884c\u6570\uff1a%2$s\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ReportManageService_1", (String)"tmc-fpm-business", (Object[])new Object[0]), moreThanMaxLines, maxLineCount);
            return FpmOperateResult.error(errorMessage);
        }
        CacheCellMeta meta = dataSource.getMeta();
        List colDimList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        Integer startRow = colDimList.stream().map(ReportCalcVal::getRow).max(Integer::compareTo).get();
        List rowsLTTotalTow = rows.stream().filter(index -> index <= totalRow + startRow).map(integer -> integer + 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rowsLTTotalTow)) {
            String ltLines = rowsLTTotalTow.stream().map(Object::toString).collect(Collectors.joining("\u3001"));
            String errorMessage = String.format(ResManager.loadKDString((String)"\u5f85\u5220\u9664\u7684\u7b2c%1$s\u884c\u4e3a\u5408\u8ba1\u884c\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c", (String)"ReportManageService_2", (String)"tmc-fpm-business", (Object[])new Object[0]), ltLines);
            return FpmOperateResult.error(errorMessage);
        }
        List<CacheCell> allCell = dataSource.getAllCell();
        Map<Integer, List<CacheCell>> rowMap = allCell.stream().collect(Collectors.groupingBy(CacheCell::getRow));
        ArrayList<CellDataUpdateInfo> updateCellDataList = new ArrayList<CellDataUpdateInfo>(16);
        ArrayList<Long> deleteDataIdList = new ArrayList<Long>();
        for (Integer deleteRow : rows) {
            List<CacheCell> cols = rowMap.get(deleteRow);
            if (cols == null) continue;
            for (CacheCell cell : cols) {
                if (cell.getDataId() != null) {
                    deleteDataIdList.add((Long)cell.getDataId());
                }
                updateCellDataList.add(new CellDataUpdateInfo(cell.getRow(), cell.getCol(), null, cell.getValue()));
            }
        }
        if (deleteDataIdList.size() > 0) {
            dataSource.addDeletedDataIdList(deleteDataIdList);
        }
        manager.updateCellData(updateCellDataList, dataSource);
        result.setData(manager.getNeedUpdateValList());
        return result;
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> smartGetVal(IReportDataManagerV2 manager, CellDataSource dataSource, boolean isSyncPlanAmt) {
        FundPlanSystem system = manager.getSystem();
        ReportTemplate reportTemplate = manager.getReportTemplate();
        BillMatchRule billMatchRule = this.controlRepository.loadPlanMatchRule("fpm_inoutcollect", system.getId());
        if (billMatchRule == null) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u4f53\u7cfb\u4e0b\u65e0\u53ef\u7528\u72b6\u6001\u7684\u8ba1\u5212\u7f16\u5236\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e", (String)"ReportManageService_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        List<TemplateDim> templateDimList = reportTemplate.getAllTemplateDim();
        Report report = this.reportRep.loadReport(manager.getReportId());
        FpmOperateResult<Boolean> saveResult = this.saveReport(manager, system, report, dataSource);
        if (!saveResult.isSuccess()) {
            return FpmOperateResult.error(saveResult.getMessageList());
        }
        FpmOperateResult<Void> smartGetValResult = this.reportBizService.smartGetVal(billMatchRule, report, system, templateDimList, isSyncPlanAmt);
        if (!smartGetValResult.isSuccess()) {
            return FpmOperateResult.error(smartGetValResult.getMessageList());
        }
        FpmOperateResult<Report> reportFpmOperateResult = this.reportBizService.loadReportContainRefData(manager.getReportId(), system);
        if (!reportFpmOperateResult.isSuccess()) {
            return FpmOperateResult.error(reportFpmOperateResult.getMessageList());
        }
        report = reportFpmOperateResult.getData();
        List<Long> pageDimS = dataSource.getMeta().getPageCalcValList().stream().map(item -> (Long)item.getValue()).collect(Collectors.toList());
        report.setProcessStatus(ReportProcessStatus.SAVE);
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getReportExecutor(system, report, pageDimS);
        ReportModel reportModel = new ReportModel();
        reportExecutor.executeAction(reportModel);
        manager.setCurrCalcModel(reportModel.getReportCalcModelList().get(0));
        manager.updateFormulaManager();
        return FpmOperateResult.success(manager);
    }

    private List<QFilter> getF7Filter(FundPlanSystem system, ReportTemplate template, List<ReportCalcVal> colDimValList, CacheCell cell, String name) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        List currColDimList = colDimValList.stream().filter(item -> cell.getCol() == item.getCol()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(colDimValList) && currColDimList.size() == 1) {
            ReportCalcVal currCol = (ReportCalcVal)currColDimList.get(0);
            List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
            TemplateDim currColTemplateDim = allTemplateDim.stream().filter(item -> item.getDimensionId().equals(currCol.getDimensionId())).findFirst().get();
            if (DimensionType.DETAILDIM != currColTemplateDim.getDimType()) {
                DimensionType dimType = currColTemplateDim.getDimType();
                List<Long> memberScope = currColTemplateDim.getMemberScope();
                if (DimensionType.PERIOD == dimType) {
                    List childMemberList;
                    List<Long> finalPeriodMemberScope = memberScope;
                    Dimension orgPeriodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
                    List<Object> periodMemberList = orgPeriodDim.getAllDimMemberList().stream().filter(item -> memberScope.contains(item.getId())).map(item -> (PeriodMember)item).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
                    PeriodMember periodMember = (PeriodMember)periodMemberList.get(0);
                    Long periodTypeId = periodMember.getPeriodTypeId();
                    Optional<TemplateReportType> templateReportTypeOptional = template.getReportTypeList().stream().filter(item -> periodTypeId.equals(item.getReportTypeId())).findFirst();
                    List rollMemberIdList = Collections.emptyList();
                    if (templateReportTypeOptional.isPresent() && !templateReportTypeOptional.get().isRollContainsDetail()) {
                        rollMemberIdList = periodMemberList.subList(1, periodMemberList.size()).stream().map(DimMember::getId).collect(Collectors.toList());
                        periodMemberList = Collections.singletonList(periodMember);
                    }
                    if (CollectionUtils.isNotEmpty(childMemberList = periodMemberList.stream().map(DimMember::getAllChildMember).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()))) {
                        finalPeriodMemberScope = childMemberList.stream().map(DimMember::getId).collect(Collectors.toList());
                    }
                    if (CollectionUtils.isNotEmpty(rollMemberIdList)) {
                        finalPeriodMemberScope.addAll(rollMemberIdList);
                    }
                    qFilterList.add(new QFilter("id", "in", finalPeriodMemberScope));
                } else {
                    qFilterList.add(new QFilter("id", "in", memberScope));
                }
                qFilterList.add(new QFilter("bodysystem", "=", (Object)template.getSystemId()));
                qFilterList.add(new QFilter("dimension", "=", (Object)currColTemplateDim.getDimensionId()));
                qFilterList.add(new QFilter("dimtype", "=", (Object)dimType.getNumber()));
            } else {
                CellTypeEnum cellType = cell.getCellType();
                if (cellType == CellTypeEnum.F7WIDGET && (currColTemplateDim.getDetailDimType() == DetailDimType.BANK_CATE || currColTemplateDim.getDetailDimType() == DetailDimType.BUSINESS_PARTNER)) {
                    qFilterList.add(new QFilter("enable", "=", (Object)"1"));
                }
            }
        }
        if (EmptyUtil.isNotEmpty((CharSequence)name)) {
            qFilterList.add(new QFilter("name", "like", (Object)("%" + name + "%")));
        }
        return qFilterList;
    }

    private ReportDataManagerV2 buildManager(boolean isSmartVersion, IFpmPageCacheService cacheService, FundPlanSystem system, Report report) {
        ReportDataManagerV2 manager;
        if (isSmartVersion) {
            report.setReferencePeriodType(null);
            ReportTemplate template = report.getTemplate();
            List<TemplateMetric> metrics = template.getMetrics();
            metrics = metrics.stream().filter(item -> item.getMetricType() == TemplateMetricType.PLANAMT).collect(Collectors.toList());
            template.setMetrics(metrics);
            IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getReportSmartVersionExecutor(system, report, 0);
            ReportModel reportModel = new ReportModel();
            reportExecutor.executeAction(reportModel);
            manager = new ReportDataManagerV2(report.getId(), cacheService, reportModel.getReportCalcModelList().get(0), report.getTemplate(), system, true);
        } else {
            manager = ReportDataManagerFactoryV2.getDataManager(system, report, cacheService);
        }
        return manager;
    }
}

