/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class SubjectCheckPostProcessorImpl
implements IControlExecuteParamPostProcessor {
    private static final Log logger = LogFactory.getLog(SubjectCheckPostProcessorImpl.class);

    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        if (!controlContext.getPlanExecuteOpType().isPositiveOp()) {
            return;
        }
        logger.info("SubjectCheckPostProcessorImpl\u79d1\u76ee\u68c0\u9a8c\u524d\u5927\u5c0f\uff1a{}", (Object)controlExecuteParamList.size());
        if (controlContext.getPlanExecuteOpType() == PlanExecuteOpType.WRITE) {
            Iterator<ControlExecuteParam> iterator = controlExecuteParamList.iterator();
            while (iterator.hasNext()) {
                ControlExecuteParam controlExecuteParam = iterator.next();
                if (EmptyUtil.isNoEmpty((Long)controlExecuteParam.getSubjectId())) continue;
                String errorMsg = SubjectCheckPostProcessorImpl.getErrorMsg(controlContext, controlExecuteParam);
                controlExecuteParam.setFailedCause(errorMsg);
                controlContext.addFailedControlExecuteParam(controlExecuteParam);
                iterator.remove();
            }
        }
        logger.info("SubjectCheckPostProcessorImpl\u79d1\u76ee\u68c0\u9a8c\u540e\u5927\u5c0f\uff1a{}", (Object)controlExecuteParamList.size());
        String errorMsg = SubjectCheckPostProcessorImpl.checkSubject(controlContext, controlExecuteParamList);
        if (EmptyUtil.isNoEmpty((String)errorMsg)) {
            throw new KDBizException(errorMsg);
        }
    }

    private static String checkSubject(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        Optional<ControlExecuteParam> first = controlExecuteParamList.stream().filter(controlExecuteParam -> EmptyUtil.isEmpty((Long)controlExecuteParam.getSubjectId())).findFirst();
        return first.map(controlExecuteParam -> SubjectCheckPostProcessorImpl.getErrorMsg(controlContext, controlExecuteParam)).orElse(null);
    }

    private static String getErrorMsg(ControlContext controlContext, ControlExecuteParam controlExecuteParam) {
        BillMatchRule matchRule = controlExecuteParam.getMatchRule();
        FundPlanSystem system = controlContext.getSystem(controlExecuteParam.getSystemId());
        String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%1$s\u3011\u4f7f\u7528\u4f53\u7cfb\u3010%2$s\u3011\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u3010%3$s\u3011\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba1\u5212\u79d1\u76ee", (String)"SubjectCheckPostProcessorImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), controlExecuteParam.getBillBizInfo().getBillNo(), system.getName(), matchRule.getNumber());
        return errorMsg;
    }

    @Override
    public int getOrder() {
        return 5;
    }
}

