/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportDataWrapper;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecordCount;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IAnalysisReportBizService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportBizService;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.ISumPlanManageService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManager;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.ReportDataManagerFactory;
import kd.tmc.fpm.business.spread.datamanager.ReportDataManagerFactoryV2;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManager;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.impl.SpreadAuxiliaryDataReceiver;
import kd.tmc.fpm.business.utils.MutexAuxiliarySaveHelper;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;

public class SumPlanManageServiceImpl
implements ISumPlanManageService {
    private static Log logger = LogFactory.getLog(SumPlanManageServiceImpl.class);
    private IDimensionRepository dimRepo = new DimensionRepository();
    private ISumPlanBizService bizService = new SumPlanBizServiceImpl();
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private IAnalysisReportBizService analysisReportBizService = new AnalysisReportBizService();
    private IReportRepository reportRepository = FpmServiceFactory.getBizService(IReportRepository.class);
    private ISumPlanRepository sumPlanRepository = new SumPlanRepository();

    @Override
    public FpmOperateResult<IReportDataManagerV2> load(Long id, Long systemId, SumPlanHeader sumPlanHeader, IFpmPageCacheService cacheService) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SumPlanManageServiceImpl.class.getSimpleName());){
            span.addTag("load sumPlanReport step1: load system");
            FundPlanSystem system = this.dimRepo.loadSystem(systemId);
            span.addTag("load sumPlanReport step2: load SumPlanRecord");
            FpmOperateResult<SumPlanRecord> load = this.bizService.load(id, system, sumPlanHeader);
            if (!load.isSuccess()) {
                FpmOperateResult<IReportDataManagerV2> fpmOperateResult = FpmOperateResult.error(load.getMessageList());
                return fpmOperateResult;
            }
            SumPlanReport sumPlanReport = load.getData().getSumPlanReportList().get(0);
            span.addTag("load sumPlanReport step3: create manager");
            ReportDataManagerV2 manager = ReportDataManagerFactoryV2.getSumReportDataManager(system, sumPlanReport, sumPlanHeader.getPageDimMemberIds(), cacheService);
            FpmOperateResult<IReportDataManagerV2> fpmOperateResult = FpmOperateResult.success(manager);
            return fpmOperateResult;
        }
    }

    @Override
    public FpmOperateResult<IReportDataManager> load(Long id, Long systemId, List<Long> pageDimS, String pageId, SumPlanHeader sumPlanHeader) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SumPlanManageServiceImpl.class.getSimpleName());){
            span.addTag("load sumPlanReport step1: load system");
            FundPlanSystem system = this.dimRepo.loadSystem(systemId);
            span.addTag("load sumPlanReport step2: load SumPlanRecord");
            FpmOperateResult<SumPlanRecord> load = this.bizService.load(id, system, sumPlanHeader);
            if (!load.isSuccess()) {
                FpmOperateResult<IReportDataManager> fpmOperateResult = FpmOperateResult.error(load.getMessageList());
                return fpmOperateResult;
            }
            SumPlanReport sumPlanReport = load.getData().getSumPlanReportList().get(0);
            span.addTag("load sumPlanReport step3: create manager");
            ReportDataManager manager = (ReportDataManager)ReportDataManagerFactory.createDataManagerForFirstSumPlanReportByPageDim(system, sumPlanReport, pageDimS, pageId);
            FpmOperateResult<IReportDataManager> fpmOperateResult = FpmOperateResult.success(manager);
            return fpmOperateResult;
        }
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> save(IReportDataManagerV2 manager, CellDataSource cellDataSource) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SumPlanManageServiceImpl.class.getSimpleName());){
            Serializable referenceReport;
            span.addTag("saveSumReport step2\uff1a getSumPlanReports");
            span.addTag("saveSumReport step3\uff1a updateBillHead");
            Long reportId = manager.getReportId();
            List<Report> reports = this.reportRepository.loadSimpleReport(Collections.singleton(reportId), t -> {
                t.setNeedCompanyMember(true);
                t.setNeedPeriodMember(true);
                t.setNeedReportStatus(true);
            });
            if (EmptyUtil.isEmpty(reports)) {
                FpmOperateResult<IReportDataManagerV2> fpmOperateResult = FpmOperateResult.success();
                return fpmOperateResult;
            }
            Report report = reports.get(0);
            SumPlanRecord referenceRecord = this.getReferenceSumPlanRecord(report);
            MutexAuxiliarySaveHelper.MutexAuxiliarySaveInfo saveInfo = new MutexAuxiliarySaveHelper.MutexAuxiliarySaveInfo(reportId, report, MutexAuxiliarySaveHelper.InputType.SUM_PLAN);
            ArrayList<ReportDataWrapper> reportDataWrapperList = new ArrayList<ReportDataWrapper>(16);
            if (referenceRecord != null && EmptyUtil.isNoEmpty(referenceRecord.getSumPlanReportList())) {
                referenceReport = referenceRecord.getSumPlanReportList().get(0);
                manager.reverseDataToReportDataReceiver(cellDataSource, new SpreadAuxiliaryDataReceiver((Report)referenceReport, (List<ReportDataWrapper>)reportDataWrapperList, true));
                if (EmptyUtil.isNoEmpty(reportDataWrapperList)) {
                    saveInfo.setInputType(MutexAuxiliarySaveHelper.InputType.SUM_PLAN_CONTAINS_REFERENCE);
                    saveInfo.setId(referenceRecord.getId());
                    saveInfo.setReport((Report)referenceReport);
                }
            }
            manager.reverseDataToReportDataReceiver(cellDataSource, new SpreadAuxiliaryDataReceiver(report, reportDataWrapperList));
            if (EmptyUtil.isEmpty(reportDataWrapperList)) {
                referenceReport = FpmOperateResult.success(manager);
                return referenceReport;
            }
            MutexAuxiliarySaveHelper mutexAuxiliarySaveHelper = MutexAuxiliarySaveHelper.getInstance(saveInfo);
            mutexAuxiliarySaveHelper.saveOrUpdateAuxiliaryReportDataForFix(reportDataWrapperList);
            FpmOperateResult<IReportDataManagerV2> fpmOperateResult = FpmOperateResult.success(manager);
            return fpmOperateResult;
        }
    }

    private SumPlanRecord getReferenceSumPlanRecord(Report report) {
        PeriodMember referencePeriodMember = report.getReferencePeriodMember();
        if (EmptyUtil.isEmpty((Object)referencePeriodMember)) {
            return null;
        }
        SumPlanRecord sumPlanRecord = this.sumPlanRepository.loadSumPlanRecord(report.getCompanyMemberList().get(0).getId(), referencePeriodMember.getId());
        if (EmptyUtil.isEmpty((Object)sumPlanRecord)) {
            return null;
        }
        List<Report> reports = this.reportRepository.loadSimpleReport(new HashSet<Long>(sumPlanRecord.getOriginalReportIdList()), t -> {
            t.setNeedCompanyMember(true);
            t.setNeedPeriodMember(true);
            t.setNeedReportStatus(true);
        });
        if (EmptyUtil.isEmpty(reports)) {
            return null;
        }
        SumPlanReport report1 = (SumPlanReport)reports.get(0);
        sumPlanRecord.setSumPlanReportList(Collections.singletonList(report1));
        return sumPlanRecord;
    }

    @Override
    public FpmOperateResult<SumPlanRecord> innerCancelAmt(Long sumId) {
        return this.bizService.innerCancelAmt(sumId);
    }

    @Override
    public FpmOperateResult<SumPlanRecordCount> countSumPlan(Long sumRecordId) {
        SumPlanRecordCount result = this.bizService.countSumPlan(sumRecordId);
        return FpmOperateResult.success(result);
    }
}

