/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.compare;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.InspectionCompareType;
import kd.tmc.fpm.business.domain.enums.InspectionExecResult;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.inspection.BatchDataSet;
import kd.tmc.fpm.business.domain.model.inspection.InspectQueryParam;
import kd.tmc.fpm.business.domain.model.inspection.SimpleReportData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.control.factory.RelateReportDataManagerFactory;
import kd.tmc.fpm.business.mvc.service.inspection.compare.AbstractCompareHandler;
import kd.tmc.fpm.business.mvc.service.inspection.compare.InspectChainContext;
import kd.tmc.fpm.business.mvc.service.inspection.compare.InspectHandlerChain;
import kd.tmc.fpm.business.mvc.service.inspection.query.impl.SimpleReportDataQueryService;

public class RelateCompareHandler
extends AbstractCompareHandler {
    private final Log logger = LogFactory.getLog(RelateCompareHandler.class);

    @Override
    public void doHandle(InspectChainContext context, InspectHandlerChain chain) {
        if (!this.isSkip(context)) {
            this.doCompare(context);
        }
        chain.doHandle(context);
    }

    private void doCompare(InspectChainContext context) {
        List<ReportData> correctReportDataList = context.getMatchedReportDataList();
        this.logger.info("[RelateCompareHandler] >>>> correctReportDataList size:[{}] ", (Object)correctReportDataList.size());
        IRelateReportDataManager matchedReportDataManager = RelateReportDataManagerFactory.getRelateReportDataManager(correctReportDataList);
        Dimension subjectDim = context.getSystem().getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<DimMember> memberList = subjectDim.getAllDimMemberList();
        List<Long> beginEndAccountMemberList = memberList.stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection())).map(DimMember::getId).collect(Collectors.toList());
        List<ReportData> relateReportDataList = matchedReportDataManager.getRelateReportDataListBySourceIfExclude(correctReportDataList, beginEndAccountMemberList);
        List relateReportDataIdList = relateReportDataList.stream().map(ReportData::getId).collect(Collectors.toList());
        this.logger.info("[RelateCompareHandler] >>>> relateReportDataList size:[{}] ", (Object)relateReportDataList.size());
        relateReportDataList.addAll(correctReportDataList);
        List<ReportData> allCorrectReportDataList = matchedReportDataManager.reCalculateRelateDataByDAG(relateReportDataList);
        Map<Long, ReportData> upperCorrectReportDataMap = allCorrectReportDataList.stream().filter(reportData -> relateReportDataIdList.contains(reportData.getId())).collect(Collectors.toMap(ReportData::getId, v -> v, (k1, k2) -> k1));
        SimpleReportDataQueryService inspectDataQueryService = new SimpleReportDataQueryService();
        try (BatchDataSet batchDataSet = inspectDataQueryService.query(null, new InspectQueryParam().addParam("reportDataIdList", relateReportDataIdList));){
            while (batchDataSet.hasNext()) {
                List batchData = batchDataSet.getBatchData();
                for (SimpleReportData dbReportData : batchData) {
                    if (!upperCorrectReportDataMap.containsKey(dbReportData.getId())) continue;
                    ReportData correctReportData = upperCorrectReportDataMap.get(dbReportData.getId());
                    this.doCompareAndRecord(dbReportData, correctReportData, context);
                }
            }
        }
    }

    private void doCompareAndRecord(SimpleReportData dbRD, ReportData correctRD, InspectChainContext context) {
        boolean actAmtIsEq;
        boolean lockAmtIsEq = correctRD.getLockAmt().compareTo(dbRD.getLockAmt()) == 0;
        boolean bl = actAmtIsEq = correctRD.getActAmt().compareTo(dbRD.getActAmt()) == 0;
        if (lockAmtIsEq && actAmtIsEq) {
            return;
        }
        context.setExecResult(InspectionExecResult.EXCEPTION);
        if (!lockAmtIsEq) {
            context.getRawErrorInfoList().add(new InspectChainContext.RawErrorInfo(correctRD, this.getErrorInfo(InspectionCompareType.PRE_OCCUPY.getDesc(), dbRD, correctRD)));
        }
        if (!actAmtIsEq) {
            context.getRawErrorInfoList().add(new InspectChainContext.RawErrorInfo(correctRD, this.getErrorInfo(InspectionCompareType.ACTUAL_OCCUPY.getDesc(), dbRD, correctRD)));
        }
    }

    private String getErrorInfo(String compareTypeDesc, SimpleReportData dbRD, ReportData correctRD) {
        if (InspectionCompareType.PRE_OCCUPY.getDesc().equals(compareTypeDesc)) {
            this.logger.info("\u4e0e\u5173\u8054\u8ba1\u5212\u79d1\u76ee\u7ef4\u5ea6\u7ec4\u5408\u7684{}\u989d\u5ea6\u8ba1\u7b97\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8ba1\u5212\u8868\u989d\u5ea6{}\uff1b\u4e0b\u7ea7\u8ba1\u7b97\u6240\u5f97\u989d\u5ea6{}\uff0creportDataId\uff1b[{}]", new Object[]{compareTypeDesc, dbRD.getLockAmt(), correctRD.getLockAmt(), correctRD.getId()});
        } else {
            this.logger.info("\u4e0e\u5173\u8054\u8ba1\u5212\u79d1\u76ee\u7ef4\u5ea6\u7ec4\u5408\u7684{}\u989d\u5ea6\u8ba1\u7b97\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8ba1\u5212\u8868\u989d\u5ea6{}\uff1b\u4e0b\u7ea7\u8ba1\u7b97\u6240\u5f97\u989d\u5ea6{}\uff0creportDataId\uff1b[{}]", new Object[]{compareTypeDesc, dbRD.getActAmt(), correctRD.getActAmt(), correctRD.getId()});
        }
        return String.format(ResManager.loadKDString((String)"\u4e0e\u5173\u8054\u8ba1\u5212\u79d1\u76ee\u7ef4\u5ea6\u7ec4\u5408\u7684%s\u989d\u5ea6\u8ba1\u7b97\u7ed3\u679c\u4e0d\u4e00\u81f4", (String)"AmountConsistencyInspectService_1", (String)"tmc-fpm-business", (Object[])new Object[0]), compareTypeDesc);
    }
}

