/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillControlTraceIdInfo;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import org.apache.commons.collections4.MapUtils;

public class BusinessBillExecuteRecordInfo {
    private BitMap<ControlBOTPInfo, Long> upperInfoBitMap;
    private BitMap<ControlBOTPInfo, Long> downBillInfoBitMap;
    private Map<BillEntryInfo, Map<PlanExecuteOpType, Set<Long>>> billPlanRecordListMap;
    private Map<Long, Set<BillEntryInfo>> billEntryInfoSetMap;
    private Map<Long, PlanExecuteRecord> planExecuteRecordMap;
    private Map<Long, BillControlTraceIdInfo> billControlTraceIdInfoMap;
    private Set<Long> multiSourceBillIds;

    public BusinessBillExecuteRecordInfo() {
        this.reset();
    }

    public List<ControlBOTPInfo> getDownBillBizInfoList(Long billId) {
        if (Objects.isNull(this.downBillInfoBitMap) || this.downBillInfoBitMap.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<ControlBOTPInfo>(this.downBillInfoBitMap.getKeys(billId));
    }

    public List<ControlBOTPInfo> getUpperBillBIzInfoList(Long billId) {
        if (Objects.isNull(this.upperInfoBitMap) || this.upperInfoBitMap.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<ControlBOTPInfo>(this.upperInfoBitMap.getKeys(billId));
    }

    public void addDownBillBizInfo(Long billId, List<ControlBOTPInfo> controlBOTPInfoList) {
        if (EmptyUtil.isEmpty(controlBOTPInfoList)) {
            return;
        }
        this.downBillInfoBitMap.addValue(new HashSet<ControlBOTPInfo>(controlBOTPInfoList), billId);
    }

    public void addUpperBillBizInfo(Long billId, List<ControlBOTPInfo> controlBOTPInfoList) {
        if (EmptyUtil.isEmpty(controlBOTPInfoList)) {
            return;
        }
        this.upperInfoBitMap.addValue(new HashSet<ControlBOTPInfo>(controlBOTPInfoList), billId);
    }

    public void addPlanExecuteRecord(PlanExecuteRecord planExecuteRecord) {
        if (Objects.isNull(planExecuteRecord)) {
            return;
        }
        BillBizInfo billBizInfo = planExecuteRecord.getBillBizInfo();
        if (!this.billControlTraceIdInfoMap.containsKey(billBizInfo.getBillId())) {
            BillControlTraceIdInfo billControlTraceIdInfo = new BillControlTraceIdInfo();
            billControlTraceIdInfo.setBusinessBillId(billBizInfo.getBillId());
            billControlTraceIdInfo.setEntityType(billBizInfo.getEntityType());
            billControlTraceIdInfo.setControlTraceId(planExecuteRecord.getControlTraceId());
            this.billControlTraceIdInfoMap.put(billBizInfo.getBillId(), billControlTraceIdInfo);
        }
        BillEntryInfo billEntryInfo = new BillEntryInfo(billBizInfo);
        Map planExecuteOpTypeListMap = this.billPlanRecordListMap.computeIfAbsent(billEntryInfo, k -> new HashMap(8));
        Set planExecuteRecordList = planExecuteOpTypeListMap.computeIfAbsent(planExecuteRecord.getExecuteOpType(), k -> new HashSet(128));
        planExecuteRecordList.add(planExecuteRecord.getId());
        this.planExecuteRecordMap.putIfAbsent(planExecuteRecord.getId(), planExecuteRecord);
        Set billEntryInfos = this.billEntryInfoSetMap.computeIfAbsent(billBizInfo.getBillId(), k -> new HashSet(10));
        billEntryInfos.add(billEntryInfo);
    }

    public List<PlanExecuteRecord> getPlanExecuteRecordByOp(BillBizInfo billBizInfo, PlanExecuteOpType planExecuteOpType) {
        Map<PlanExecuteOpType, Set<Long>> planExecuteOpTypeSetMap = this.billPlanRecordListMap.get(new BillEntryInfo(billBizInfo));
        if (MapUtils.isEmpty(planExecuteOpTypeSetMap)) {
            return Collections.emptyList();
        }
        return planExecuteOpTypeSetMap.getOrDefault(planExecuteOpType, Collections.emptySet()).stream().map(this.planExecuteRecordMap::get).collect(Collectors.toList());
    }

    public List<PlanExecuteRecord> getPlanExecuteRecordByOp(ControlBOTPInfo controlBOTPInfo, PlanExecuteOpType planExecuteOpType) {
        Set<BillEntryInfo> billEntryInfos = this.billEntryInfoSetMap.get(controlBOTPInfo.getId());
        if (EmptyUtil.isEmpty(billEntryInfos)) {
            return Collections.emptyList();
        }
        return billEntryInfos.stream().map(this.billPlanRecordListMap::get).filter(Objects::nonNull).map(planExecuteOpTypeSetMap -> (Set)planExecuteOpTypeSetMap.get(planExecuteOpType)).filter(Objects::nonNull).flatMap(Collection::stream).filter(EmptyUtil::isNoEmpty).map(this.planExecuteRecordMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<PlanExecuteRecord> getPlanExecuteRecordByRelateRecordIds(Set<Long> relateRecordIds) {
        if (MapUtils.isEmpty(this.planExecuteRecordMap)) {
            return Collections.emptyList();
        }
        return this.planExecuteRecordMap.values().stream().filter(planExecuteRecord -> EmptyUtil.isNoEmpty((Long)planExecuteRecord.getRelateRecordId())).filter(planExecuteRecord -> relateRecordIds.contains(planExecuteRecord.getRelateRecordId())).distinct().collect(Collectors.toList());
    }

    public List<PlanExecuteRecord> getOriginalExecuteRecordByRelease(List<PlanExecuteRecord> planExecuteRecordList) {
        if (EmptyUtil.isEmpty(planExecuteRecordList)) {
            return Collections.emptyList();
        }
        return planExecuteRecordList.stream().map(PlanExecuteRecord::getOriginalRecordId).filter(EmptyUtil::isNoEmpty).map(this.planExecuteRecordMap::get).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<PlanExecuteRecord> getAllReleaseExecuteRecordByOriginalRecords(List<PlanExecuteRecord> originalRecords) {
        if (EmptyUtil.isEmpty(originalRecords)) {
            return Collections.emptyList();
        }
        Set ids = originalRecords.stream().map(PlanExecuteRecord::getId).collect(Collectors.toSet());
        return this.planExecuteRecordMap.values().stream().filter(p -> EmptyUtil.isNoEmpty((Long)p.getOriginalRecordId())).filter(p -> ids.contains(p.getOriginalRecordId())).distinct().collect(Collectors.toList());
    }

    public void addBillControlTraceIdInfoList(List<BillControlTraceIdInfo> billControlTraceIdInfoList) {
        if (EmptyUtil.isEmpty(billControlTraceIdInfoList)) {
            return;
        }
        billControlTraceIdInfoList.forEach(billControlTraceIdInfo -> this.billControlTraceIdInfoMap.putIfAbsent(billControlTraceIdInfo.getBusinessBillId(), (BillControlTraceIdInfo)billControlTraceIdInfo));
    }

    public void addMultiSourceBillId(Long billId) {
        this.multiSourceBillIds.add(billId);
    }

    public boolean isMultiSourceBillId(Long billId) {
        return this.multiSourceBillIds.contains(billId);
    }

    public Long getControlTraceId(Long billId) {
        BillControlTraceIdInfo billControlTraceIdInfo = this.billControlTraceIdInfoMap.get(billId);
        if (EmptyUtil.isEmpty((Object)billControlTraceIdInfo)) {
            return 0L;
        }
        return billControlTraceIdInfo.getControlTraceId();
    }

    public void removeDownBill(ControlBOTPInfo controlBOTPInfo, Long billId) {
        this.downBillInfoBitMap.remove(controlBOTPInfo, billId);
    }

    public final void reset() {
        int capacity = 512;
        this.upperInfoBitMap = new BitMap(capacity);
        this.downBillInfoBitMap = new BitMap(capacity);
        this.billPlanRecordListMap = new HashMap<BillEntryInfo, Map<PlanExecuteOpType, Set<Long>>>(capacity);
        this.planExecuteRecordMap = new HashMap<Long, PlanExecuteRecord>(256);
        this.billControlTraceIdInfoMap = new HashMap<Long, BillControlTraceIdInfo>(capacity);
        this.multiSourceBillIds = new HashSet<Long>(16);
        this.billEntryInfoSetMap = new HashMap<Long, Set<BillEntryInfo>>(capacity);
    }

    public static class BillEntryInfo {
        private Long billId;
        private Long entryId;
        private String entityType;

        public BillEntryInfo(BillBizInfo billBizInfo) {
            this.billId = billBizInfo.getBillId();
            this.entityType = billBizInfo.getEntityType();
            this.entryId = billBizInfo.getEntryId();
        }

        public BillEntryInfo(ControlBOTPInfo controlBOTPInfo) {
            this.billId = controlBOTPInfo.getId();
            this.entityType = controlBOTPInfo.getEntityType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BillEntryInfo that = (BillEntryInfo)o;
            return Objects.equals(this.billId, that.billId) && Objects.equals(this.entryId, that.entryId) && Objects.equals(this.entityType, that.entityType);
        }

        public int hashCode() {
            return Objects.hash(this.billId, this.entryId, this.entityType);
        }
    }
}

