/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.InspectionExecType;
import kd.tmc.fpm.business.domain.enums.InspectionHandleType;
import kd.tmc.fpm.business.domain.enums.InspectionScope;
import kd.tmc.fpm.business.domain.enums.InspectionType;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.inspection.InspectDateRange;
import kd.tmc.fpm.business.domain.model.inspection.InspectionConfig;
import kd.tmc.fpm.business.mvc.service.inspection.context.BusinessBillExecuteRecordInfo;

public class InspectContext {
    private InspectionConfig inspectionConfig;
    private InspectionType inspectionType;
    private InspectionScope inspectionScope;
    private InspectionHandleType handleType;
    private FundPlanSystem system;
    private Map<Long, BillMatchRule> billMatchRuleMap = new HashMap<Long, BillMatchRule>(16);
    private ControlTime controlTime;
    private InspectDateRange inspectDateRange;
    private Set<Long> inspectReportOrgScope = new HashSet<Long>(16);
    private boolean controlTraceInspect;
    private InspectionExecType execType;
    private BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = new BusinessBillExecuteRecordInfo();
    private List<OrgMember> orgMemberList;

    public List<OrgMember> getOrgMemberList() {
        return this.orgMemberList;
    }

    public void setOrgMemberList(List<OrgMember> orgMemberList) {
        this.orgMemberList = orgMemberList;
    }

    public InspectionConfig getInspectionConfig() {
        return this.inspectionConfig;
    }

    public void setInspectionConfig(InspectionConfig inspectionConfig) {
        this.inspectionConfig = inspectionConfig;
    }

    public InspectionType getInspectionType() {
        return this.inspectionType;
    }

    public void setInspectionType(InspectionType inspectionType) {
        this.inspectionType = inspectionType;
    }

    public InspectionScope getInspectionScope() {
        return this.inspectionScope;
    }

    public void setInspectionScope(InspectionScope inspectionScope) {
        this.inspectionScope = inspectionScope;
    }

    public InspectionHandleType getHandleType() {
        return this.handleType;
    }

    public void setHandleType(InspectionHandleType handleType) {
        this.handleType = handleType;
    }

    public FundPlanSystem getSystem() {
        return this.system;
    }

    public void setSystem(FundPlanSystem system) {
        this.system = system;
    }

    public void addMatchRule(BillMatchRule billMatchRule) {
        this.billMatchRuleMap.putIfAbsent(billMatchRule.getId(), billMatchRule);
    }

    public BillMatchRule getMatchRule(Long matchRuleId) {
        return this.billMatchRuleMap.get(matchRuleId);
    }

    public ControlTime getControlTime() {
        return this.controlTime;
    }

    public void setControlTime(ControlTime controlTime) {
        this.controlTime = controlTime;
    }

    public InspectDateRange getInspectDateRange() {
        return this.inspectDateRange;
    }

    public void setInspectDateRange(InspectDateRange inspectDateRange) {
        this.inspectDateRange = inspectDateRange;
    }

    public Set<Long> getInspectReportOrgScope() {
        return this.inspectReportOrgScope;
    }

    public void addInspectReportOrgScope(Long orgId) {
        if (EmptyUtil.isEmpty((Long)orgId)) {
            return;
        }
        this.inspectReportOrgScope.add(orgId);
    }

    public void addAllInspectReportOrgScope(Collection<Long> orgIds) {
        if (EmptyUtil.isEmpty(orgIds)) {
            return;
        }
        orgIds.forEach(this::addInspectReportOrgScope);
    }

    public InspectionExecType getExecType() {
        return this.execType;
    }

    public void setExecType(InspectionExecType execType) {
        this.execType = execType;
    }

    public BusinessBillExecuteRecordInfo getBusinessBillExecuteRecordInfo() {
        return this.businessBillExecuteRecordInfo;
    }

    public boolean isControlTraceInspect() {
        return this.controlTraceInspect;
    }

    public void setControlTraceInspect(boolean controlTraceInspect) {
        this.controlTraceInspect = controlTraceInspect;
    }
}

