/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.factory;

import kd.bos.exception.KDBizException;
import kd.tmc.fpm.business.domain.model.inspection.InspectionConfig;
import kd.tmc.fpm.business.domain.model.inspection.header.InspectHeader;
import kd.tmc.fpm.business.domain.model.inspection.log.BaseLog;
import kd.tmc.fpm.business.mvc.service.inspection.IDataInspectService;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.factory.InspectContextFactory;
import kd.tmc.fpm.business.mvc.service.inspection.impl.AmountConsistencyInspectService;
import kd.tmc.fpm.business.mvc.service.inspection.impl.BusinessBillCompareInspectService;
import kd.tmc.fpm.business.mvc.service.inspection.impl.ExecuteRecordSourceBillNotExistsDataInspectService;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.ControlTraceReleaseOverageCheckDataInspectStrategy;

public class DataInspectServiceFactory {
    public static <T extends BaseLog> IDataInspectService<T> getDataInspectService(InspectHeader inspectHeader) {
        InspectContext inspectContext = InspectContextFactory.getInspectContext(inspectHeader);
        return DataInspectServiceFactory.getDataInspectService(inspectContext);
    }

    public static <T extends BaseLog> IDataInspectService<T> getDataInspectService(InspectContext inspectContext) {
        InspectionConfig inspectionConfig = inspectContext.getInspectionConfig();
        switch (inspectionConfig.getInspectionScope()) {
            case BILL_INSPECTION: {
                return new BusinessBillCompareInspectService(inspectContext, inspectContext.isControlTraceInspect() ? new ControlTraceReleaseOverageCheckDataInspectStrategy(inspectContext) : null);
            }
            case BILL_NOT_EXIST: {
                return new ExecuteRecordSourceBillNotExistsDataInspectService(inspectContext);
            }
            case REPORT_INSPECTION: {
                return new AmountConsistencyInspectService(inspectContext);
            }
        }
        throw new KDBizException("unknown InspectionScope " + inspectionConfig.getInspectionScope().getNumber());
    }
}

