/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.factory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.inspection.InspectDateRange;
import kd.tmc.fpm.business.domain.model.inspection.InspectionActualOccupyRule;
import kd.tmc.fpm.business.domain.model.inspection.InspectionConfig;
import kd.tmc.fpm.business.domain.model.inspection.InspectionPreOccupyRule;
import kd.tmc.fpm.business.domain.model.inspection.header.InspectHeader;
import kd.tmc.fpm.business.domain.model.inspection.header.RepairHeader;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.inspection.IInspectionConfigRepository;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.context.RepairContext;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class InspectContextFactory {
    private static IInspectionConfigRepository inspectionConfigRepository = FpmServiceFactory.getBizService(IInspectionConfigRepository.class);
    private static IDimensionRepository dimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);
    private static IControlRepository controlRepository = FpmServiceFactory.getBizService(IControlRepository.class);

    public static InspectContext getInspectContext(Long inspectConfigId) {
        InspectionConfig inspectionConfig = inspectionConfigRepository.load(inspectConfigId);
        return InspectContextFactory.getInspectContext(inspectionConfig);
    }

    public static InspectContext getInspectContext(InspectHeader header) {
        InspectionConfig inspectionConfig = inspectionConfigRepository.load(header.getInspectionConfigId());
        InspectContext inspectContext = InspectContextFactory.getInspectContext(inspectionConfig);
        inspectContext.setInspectDateRange(InspectDateRange.getInstance(header, inspectContext.getSystem()));
        inspectContext.addAllInspectReportOrgScope(header.getOrgScope());
        inspectContext.setExecType(header.getExecType());
        inspectContext.setControlTraceInspect(header.isControlTraceInspect());
        return inspectContext;
    }

    public static RepairContext getRepairContext(RepairHeader header) {
        InspectionConfig inspectionConfig = inspectionConfigRepository.load(header.getInspectionConfigId());
        RepairContext inspectContext = InspectContextFactory.getRepairContext(inspectionConfig);
        inspectContext.setInspectionLogId(header.getInspectionLogId());
        inspectContext.setInspectDateRange(InspectDateRange.getInstance(header, inspectContext.getSystem()));
        inspectContext.addAllInspectReportOrgScope(header.getOrgScope());
        inspectContext.setInspectionType(header.getInspectionType());
        inspectContext.setInspectionScope(header.getInspectionScope());
        inspectContext.setExecRecordIdList(header.getExecRecordIdList());
        inspectContext.setControlRepairInfoList(header.getControlRepairInfoList());
        return inspectContext;
    }

    private static RepairContext getRepairContext(InspectionConfig inspectionConfig) {
        RepairContext repairContext = new RepairContext();
        repairContext.setInspectionConfig(inspectionConfig);
        repairContext.setInspectionScope(inspectionConfig.getInspectionScope());
        repairContext.setInspectionType(inspectionConfig.getInspectionType());
        repairContext.setSystem(dimensionRepository.loadSystem(inspectionConfig.getSystemId()));
        return repairContext;
    }

    public static InspectContext getInspectContext(InspectionConfig inspectionConfig) {
        List<InspectionActualOccupyRule> actualOccupyRuleList;
        InspectContext inspectContext = new InspectContext();
        inspectContext.setInspectionConfig(inspectionConfig);
        inspectContext.setInspectionScope(inspectionConfig.getInspectionScope());
        inspectContext.setInspectionType(inspectionConfig.getInspectionType());
        inspectContext.setHandleType(inspectionConfig.getHandleType());
        inspectContext.setSystem(dimensionRepository.loadSystem(inspectionConfig.getSystemId()));
        if (!inspectContext.getInspectionScope().isCompareBusinessBill()) {
            return inspectContext;
        }
        HashSet matchRuleIds = new HashSet(16);
        List<InspectionPreOccupyRule> preOccupyRuleList = inspectionConfig.getPreOccupyRuleList();
        if (EmptyUtil.isNoEmpty(preOccupyRuleList)) {
            preOccupyRuleList.stream().map(InspectionPreOccupyRule::getMatchRuleId).forEach(matchRuleIds::add);
        }
        if (EmptyUtil.isNoEmpty(actualOccupyRuleList = inspectionConfig.getActualOccupyRuleList())) {
            actualOccupyRuleList.stream().map(InspectionActualOccupyRule::getMatchRuleId).forEach(matchRuleIds::add);
        }
        if (EmptyUtil.isEmpty(matchRuleIds)) {
            return inspectContext;
        }
        List<BillMatchRule> billMatchRules = controlRepository.loadBillMatchRule(new ArrayList<Long>(matchRuleIds));
        billMatchRules.forEach(inspectContext::addMatchRule);
        List<ControlTime> controlTimes = controlRepository.loadControlTime(inspectionConfig.getSystemId(), true);
        if (EmptyUtil.isNoEmpty(controlTimes)) {
            inspectContext.setControlTime(controlTimes.get(0));
            InspectContextFactory.filterDisableReportType(inspectContext);
        }
        return inspectContext;
    }

    private static void filterDisableReportType(InspectContext inspectContext) {
        ControlTime controlTime = inspectContext.getControlTime();
        if (EmptyUtil.isEmpty((Object)controlTime)) {
            return;
        }
        FundPlanSystem system = inspectContext.getSystem();
        Set reportTypeIds = system.getReportTypeList().stream().filter(ReportPeriodType::isEnable).map(ReportPeriodType::getReportPeriodId).collect(Collectors.toSet());
        List<Long> controlledReportTypeIds = controlTime.getControledReportTypeIds();
        if (EmptyUtil.isEmpty(controlledReportTypeIds)) {
            return;
        }
        controlledReportTypeIds.removeIf(rtId -> !reportTypeIds.contains(rtId));
    }
}

