/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectErrorType;
import kd.tmc.fpm.business.domain.enums.InspectionExecResult;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.InspectionTargetType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.ControlActTime;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.inspection.BatchDataSet;
import kd.tmc.fpm.business.domain.model.inspection.InspectControlConfig;
import kd.tmc.fpm.business.domain.model.inspection.InspectControlResult;
import kd.tmc.fpm.business.domain.model.inspection.InspectQueryParam;
import kd.tmc.fpm.business.domain.model.inspection.InspectionActualOccupyRule;
import kd.tmc.fpm.business.domain.model.inspection.InspectionConfig;
import kd.tmc.fpm.business.domain.model.inspection.InspectionPreOccupyRule;
import kd.tmc.fpm.business.domain.model.inspection.PlanRecordInfo;
import kd.tmc.fpm.business.domain.model.inspection.log.BillInspectionDetail;
import kd.tmc.fpm.business.domain.model.inspection.log.BillInspectionLog;
import kd.tmc.fpm.business.mvc.service.dto.ControlExcuteServiceLogParamDTO;
import kd.tmc.fpm.business.mvc.service.inspection.IDataInspectParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.factory.DataInspectStrategyFactory;
import kd.tmc.fpm.business.mvc.service.inspection.impl.AbstractDataInspectService;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;
import kd.tmc.fpm.business.mvc.service.inspection.postprocessor.BillControlTraceFilterPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.postprocessor.DataInspectParamBillNullPropFilterPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.postprocessor.DataInspectParamInfoDateFilterPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.postprocessor.DataInspectParamInfoFillPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.postprocessor.DateInspectParamReportOrgFilterPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.postprocessor.InspectParamConditionPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.postprocessor.PlanExecuteRecordInfoFillPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.query.IInspectDataQueryService;
import kd.tmc.fpm.business.mvc.service.inspection.query.impl.BusinessBillInspectDataQueryService;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.IDataInspectStrategy;
import kd.tmc.fpm.business.service.rpc.helper.GenerateControlExecLogParamHelper;
import kd.tmc.fpm.common.enums.ExecutePlanOpTypeEnum;

public class BusinessBillCompareInspectService
extends AbstractDataInspectService<BillInspectionLog> {
    private IInspectDataQueryService<Long> inspectDataQueryService = new BusinessBillInspectDataQueryService();
    private List<IDataInspectParamPostProcessor> dataInspectParamPostProcessorList = new ArrayList<IDataInspectParamPostProcessor>(16);
    private IDataInspectStrategy dataInspectStrategy;

    public BusinessBillCompareInspectService(InspectContext inspectContext) {
        this(inspectContext, null);
    }

    public BusinessBillCompareInspectService(InspectContext inspectContext, IDataInspectStrategy dataInspectStrategy) {
        super(inspectContext);
        this.dataInspectStrategy = dataInspectStrategy;
        this.registerDefault();
    }

    @Override
    public void doDataInspect(BillInspectionLog billInspectionLog) {
        InspectionConfig inspectionConfig = this.inspectContext.getInspectionConfig();
        List<InspectControlConfig> inspectControlConfigList = this.convert(inspectionConfig);
        if (EmptyUtil.isEmpty(inspectControlConfigList)) {
            return;
        }
        BillInspectionLog log = this.getLogInstance();
        for (InspectControlConfig inspectControlConfig : inspectControlConfigList) {
            ControlTime controlTime;
            BillMatchRule matchRule;
            Set<InspectControlConfig.InspectControlConfigItem> inspectControlConfigItems = inspectControlConfig.getInspectControlConfigItems();
            if (EmptyUtil.isEmpty(inspectControlConfigItems) || Objects.isNull(matchRule = this.inspectContext.getMatchRule(inspectControlConfig.getMatchRuleId())) || !matchRule.isEnable() || EmptyUtil.isEmpty((Object)(controlTime = this.inspectContext.getControlTime()))) continue;
            String entityType = matchRule.getEntityType();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityType);
            BatchDataSet<Long> batchDataSet = this.inspectDataQueryService.query(this.inspectContext, new InspectQueryParam().addParam("entityType", entityType).addParam("matchRule", matchRule));
            Throwable throwable = null;
            try {
                if (!batchDataSet.hasNext()) continue;
                HashMap<InspectControlConfig.InspectControlConfigItem, BillInspectionDetail> billInspectionDetailMap = new HashMap<InspectControlConfig.InspectControlConfigItem, BillInspectionDetail>(inspectControlConfigItems.size());
                while (batchDataSet.hasNext()) {
                    List<Long> batchData = batchDataSet.getBatchData();
                    DynamicObject[] load = TmcDataServiceHelper.load((Object[])batchData.toArray(), (DynamicObjectType)dataEntityType);
                    List<ControlExcuteServiceLogParamDTO> paramList = GenerateControlExecLogParamHelper.generateInspectParamList(this.inspectContext, matchRule, load);
                    if (EmptyUtil.isEmpty(paramList)) continue;
                    Map<Long, DynamicObject> dynamicObjectMap = Arrays.stream(load).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (a, b) -> a));
                    List billBizInfoList = paramList.stream().map(ControlExcuteServiceLogParamDTO::getBillBizInfo).collect(Collectors.toList());
                    InspectParam inspectParam = new InspectParam(new ArrayList<BillBizInfo>(billBizInfoList), new InspectControlConfig.InspectControlConfigItem(matchRule.getId(), null, null));
                    this.invokeInspectParamPostProcessor(this.dataInspectParamPostProcessorList, inspectParam);
                    if (Objects.isNull(this.dataInspectStrategy)) {
                        this.doBusinessInspect(billInspectionLog, inspectControlConfigItems, billInspectionDetailMap, dynamicObjectMap, inspectParam);
                    } else {
                        this.traceDataInspect(inspectParam, log);
                    }
                    this.inspectContext.getBusinessBillExecuteRecordInfo().reset();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (batchDataSet == null) continue;
                if (throwable != null) {
                    try {
                        batchDataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                batchDataSet.close();
            }
        }
        billInspectionLog.getBillInspectionDetailList().addAll(log.getBillInspectionDetailList());
        if (log.getExecResult() == InspectionExecResult.EXCEPTION) {
            billInspectionLog.setExecResult(log.getExecResult());
            billInspectionLog.setInspectionRepairResult(InspectionRepairResult.PENDING);
        }
    }

    private void doBusinessInspect(BillInspectionLog billInspectionLog, Set<InspectControlConfig.InspectControlConfigItem> inspectControlConfigItems, Map<InspectControlConfig.InspectControlConfigItem, BillInspectionDetail> billInspectionDetailMap, Map<Long, DynamicObject> dynamicObjectMap, InspectParam inspectParam) {
        for (InspectControlConfig.InspectControlConfigItem inspectControlConfigItem : inspectControlConfigItems) {
            InspectParam copy = inspectParam.copy();
            copy.setInspectControlConfigItem(inspectControlConfigItem);
            InspectParamConditionPostProcessor inspectParamConditionPostProcessor = new InspectParamConditionPostProcessor(dynamicObjectMap);
            inspectParamConditionPostProcessor.postProcess(this.inspectContext, copy);
            if (copy.isEmpty()) continue;
            IDataInspectStrategy dataInspectStrategy = DataInspectStrategyFactory.getDataInspectStrategy(this.inspectContext, inspectControlConfigItem);
            InspectControlResult inspectControlResult = dataInspectStrategy.handler(copy);
            BillInspectionDetail billInspectionDetail = this.getBillInspectionDetail(billInspectionLog, billInspectionDetailMap, inspectControlConfigItem);
            if (inspectControlResult.hasError()) {
                String repairMethod = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5f02\u5e38\u4e1a\u52a1\u5355\u636e\u5e76\u91cd\u65b0\u6267\u884c\u3010%1$s\u3011\u670d\u52a1", (String)"BusinessBillCompareInspectService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), ExecutePlanOpTypeEnum.getName((String)inspectControlResult.getPlanExecuteOpType().getValue()));
                billInspectionDetail.setRepairMethod(repairMethod);
            }
            this.handResult(inspectControlResult, billInspectionDetail);
            if (!inspectControlResult.hasError() || !billInspectionLog.getExecResult().isSuccess()) continue;
            billInspectionLog.setExecResult(InspectionExecResult.EXCEPTION);
        }
    }

    private void traceDataInspect(InspectParam inspectParam, BillInspectionLog log) {
        ArrayList<PlanExecuteOpType> planExecuteOpTypeList = new ArrayList<PlanExecuteOpType>(2);
        planExecuteOpTypeList.add(PlanExecuteOpType.WRITE);
        planExecuteOpTypeList.add(PlanExecuteOpType.PRE_OCCUPY_WRITE);
        List<BillInspectionDetail> billInspectionDetailList = log.getBillInspectionDetailList();
        Map billInspectionDetailMap = billInspectionDetailList.stream().collect(Collectors.toMap(BillInspectionDetail::getMatchRuleId, Function.identity(), (a, b) -> a));
        BillInspectionDetail billInspectionDetail = billInspectionDetailMap.computeIfAbsent(inspectParam.getInspectControlConfigItem().getMatchRuleId(), matchRuleId -> {
            BillInspectionDetail bid = new BillInspectionDetail();
            bid.setBizBill(this.inspectContext.getMatchRule(inspectParam.getInspectControlConfigItem().getMatchRuleId()).getEntityType());
            bid.setInspectTarget(InspectionTargetType.INSPECT_BUSINESS_TRACE);
            bid.setInspectRange("-");
            bid.setMatchRuleId(inspectParam.getInspectControlConfigItem().getMatchRuleId());
            billInspectionDetailList.add(bid);
            return bid;
        });
        for (PlanExecuteOpType planExecuteOpType : planExecuteOpTypeList) {
            InspectParam copy = inspectParam.copy();
            copy.setInspectControlConfigItem(new InspectControlConfig.InspectControlConfigItem(inspectParam.getInspectControlConfigItem().getMatchRuleId(), planExecuteOpType, null));
            InspectControlResult inspectControlResult = this.dataInspectStrategy.handler(copy);
            if (EmptyUtil.isEmpty((String)billInspectionDetail.getRepairMethod()) && inspectControlResult.hasError()) {
                String repairMethod = ResManager.loadKDString((String)"\u786e\u8ba4\u5f02\u5e38\u6267\u884c\u8bb0\u5f55\u5e76\u6267\u884c\u989d\u5ea6\u66f4\u65b0", (String)"BusinessBillCompareInspectService_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
                billInspectionDetail.setRepairMethod(repairMethod);
                log.setExecResult(InspectionExecResult.EXCEPTION);
            }
            this.handResult(inspectControlResult, billInspectionDetail);
        }
    }

    @Override
    protected BillInspectionLog getLogInstance() {
        return new BillInspectionLog();
    }

    private BillInspectionDetail getBillInspectionDetail(BillInspectionLog billInspectionLog, Map<InspectControlConfig.InspectControlConfigItem, BillInspectionDetail> billInspectionDetailMap, InspectControlConfig.InspectControlConfigItem inspectControlConfigItem) {
        BillMatchRule matchRule = this.inspectContext.getMatchRule(inspectControlConfigItem.getMatchRuleId());
        String conditionStr = inspectControlConfigItem.getCondition();
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionStr, CRCondition.class);
        return billInspectionDetailMap.computeIfAbsent(inspectControlConfigItem, k -> {
            BillInspectionDetail bid = new BillInspectionDetail();
            bid.setBizBill(matchRule.getEntityType());
            bid.setInspectTarget(ITypeEnum.getByNumber(k.getPlanExecuteOpType().getNumber(), InspectionTargetType.class));
            bid.setInspectRange(condition.getExprDesc());
            bid.setMatchRuleId(inspectControlConfigItem.getMatchRuleId());
            billInspectionLog.addBillInspectionDetail(bid);
            return bid;
        });
    }

    private void handResult(InspectControlResult inspectControlResult, BillInspectionDetail billInspectionDetail) {
        Set<BillBizInfo> billBizInfos = inspectControlResult.getBillBizInfos();
        if (EmptyUtil.isNoEmpty(billBizInfos) && !billInspectionDetail.hasError()) {
            billInspectionDetail.setExecResult(InspectionExecResult.EXCEPTION);
            billInspectionDetail.setRepairResult(InspectionRepairResult.PENDING);
        }
        for (BillBizInfo billBizInfo : billBizInfos) {
            billInspectionDetail.addErrorBizBill(new BillInspectionDetail.BillObject(billBizInfo.getBillId(), billBizInfo.getBillNo(), InspectErrorType.getInspectErrorTypeByPlanExecuteOp(inspectControlResult.getPlanExecuteOpType())));
        }
        Set<PlanRecordInfo> planRecordInfos = inspectControlResult.getPlanRecordInfos();
        if (EmptyUtil.isNoEmpty(planRecordInfos) && !billInspectionDetail.hasError()) {
            billInspectionDetail.setExecResult(InspectionExecResult.EXCEPTION);
            billInspectionDetail.setRepairResult(InspectionRepairResult.PENDING);
        }
        for (PlanRecordInfo planRecordInfo : planRecordInfos) {
            billInspectionDetail.addErrorExecRecordList(new BillInspectionDetail.BillObject(planRecordInfo.getId(), planRecordInfo.getRecordNumber(), planRecordInfo.getErrorType()));
        }
    }

    private List<InspectControlConfig> convert(InspectionConfig inspectionConfig) {
        List<InspectionActualOccupyRule> actualOccupyRuleList;
        ControlTime controlTime = this.inspectContext.getControlTime();
        if (Objects.isNull(controlTime)) {
            return Collections.emptyList();
        }
        HashMap<Long, InspectControlConfig> controlConfigMap = new HashMap<Long, InspectControlConfig>(16);
        List<InspectionPreOccupyRule> preOccupyRuleList = inspectionConfig.getPreOccupyRuleList();
        if (EmptyUtil.isNoEmpty(preOccupyRuleList)) {
            for (InspectionPreOccupyRule inspectionPreOccupyRule : preOccupyRuleList) {
                String releasePreOccupyCondition;
                String cancelPreOccupyCondition;
                Long matchRuleId = inspectionPreOccupyRule.getMatchRuleId();
                InspectControlConfig inspectControlConfig = controlConfigMap.computeIfAbsent(matchRuleId, k -> new InspectControlConfig(matchRuleId));
                String preOccupyCondition = inspectionPreOccupyRule.getPreOccupyCondition();
                if (EmptyUtil.isNoEmpty((String)preOccupyCondition)) {
                    inspectControlConfig.addInspectControlConfigItem(new InspectControlConfig.InspectControlConfigItem(matchRuleId, PlanExecuteOpType.PRE_OCCUPY_WRITE, preOccupyCondition));
                }
                if (EmptyUtil.isNoEmpty((String)(cancelPreOccupyCondition = inspectionPreOccupyRule.getCancelPreOccupyCondition()))) {
                    inspectControlConfig.addInspectControlConfigItem(new InspectControlConfig.InspectControlConfigItem(matchRuleId, PlanExecuteOpType.PRE_OCCUPY_DELETE, cancelPreOccupyCondition));
                }
                if (!EmptyUtil.isNoEmpty((String)(releasePreOccupyCondition = inspectionPreOccupyRule.getReleasePreOccupyCondition()))) continue;
                inspectControlConfig.addInspectControlConfigItem(new InspectControlConfig.InspectControlConfigItem(matchRuleId, PlanExecuteOpType.PRE_OCCUPY_RELEASE, releasePreOccupyCondition));
            }
        }
        if (EmptyUtil.isEmpty(actualOccupyRuleList = inspectionConfig.getActualOccupyRuleList())) {
            return new ArrayList<InspectControlConfig>(controlConfigMap.values());
        }
        List<ControlActTime> controlActTimeList = controlTime.getControlActTimeList();
        Map<String, List<ControlActTime>> controlActTimeMap = controlActTimeList.stream().collect(Collectors.groupingBy(ControlActTime::getBizBill));
        for (InspectionActualOccupyRule inspectionActualOccupyRule : actualOccupyRuleList) {
            String entityType;
            Optional<ControlActTime> any;
            String releaseActualOccupyCondition;
            String cancelActualOccupyCondition;
            Long matchRuleId = inspectionActualOccupyRule.getMatchRuleId();
            BillMatchRule matchRule = this.inspectContext.getMatchRule(matchRuleId);
            if (Objects.isNull(matchRule) || !matchRule.isEnable()) continue;
            InspectControlConfig inspectControlConfig = controlConfigMap.computeIfAbsent(matchRuleId, k -> new InspectControlConfig(matchRuleId));
            String actualOccupyCondition = inspectionActualOccupyRule.getActualOccupyCondition();
            if (EmptyUtil.isNoEmpty((String)actualOccupyCondition)) {
                inspectControlConfig.addInspectControlConfigItem(new InspectControlConfig.InspectControlConfigItem(matchRuleId, PlanExecuteOpType.WRITE, actualOccupyCondition));
            }
            if (EmptyUtil.isNoEmpty((String)(cancelActualOccupyCondition = inspectionActualOccupyRule.getCancelActualOccupyCondition()))) {
                inspectControlConfig.addInspectControlConfigItem(new InspectControlConfig.InspectControlConfigItem(matchRuleId, PlanExecuteOpType.CANCEL, cancelActualOccupyCondition));
            }
            if (!EmptyUtil.isNoEmpty((String)(releaseActualOccupyCondition = inspectionActualOccupyRule.getReleaseActualOccupyCondition())) || !(any = controlActTimeMap.getOrDefault(entityType = matchRule.getEntityType(), Collections.emptyList()).stream().filter(controlActTime -> EmptyUtil.isNoEmpty(controlActTime.getReleaseActTime()) && EmptyUtil.isNoEmpty((String)controlActTime.getFactBackAmtField()) || EmptyUtil.isNoEmpty(controlActTime.getActUpdateTime()) && EmptyUtil.isNoEmpty((String)controlActTime.getAclUpdateAmtField())).findAny()).isPresent()) continue;
            ControlActTime controlActTime2 = any.get();
            inspectControlConfig.addInspectControlConfigItem(new InspectControlConfig.InspectControlConfigItem(matchRuleId, EmptyUtil.isNoEmpty(controlActTime2.getReleaseActTime()) ? PlanExecuteOpType.RELEASE : PlanExecuteOpType.UPDATE, releaseActualOccupyCondition));
        }
        return new ArrayList<InspectControlConfig>(controlConfigMap.values());
    }

    private void invokeInspectParamPostProcessor(List<IDataInspectParamPostProcessor> dataInspectParamPostProcessorList, InspectParam inspectParam) {
        for (IDataInspectParamPostProcessor dataInspectParamPostProcessor : dataInspectParamPostProcessorList) {
            dataInspectParamPostProcessor.postProcess(this.inspectContext, inspectParam);
        }
    }

    private void registerDefault() {
        this.dataInspectParamPostProcessorList.add(new DataInspectParamBillNullPropFilterPostProcessor());
        this.dataInspectParamPostProcessorList.add(new DataInspectParamInfoDateFilterPostProcessor());
        this.dataInspectParamPostProcessorList.add(new DateInspectParamReportOrgFilterPostProcessor());
        this.dataInspectParamPostProcessorList.add(new DataInspectParamInfoFillPostProcessor());
        this.dataInspectParamPostProcessorList.add(new BillControlTraceFilterPostProcessor());
        this.dataInspectParamPostProcessorList.add(new PlanExecuteRecordInfoFillPostProcessor());
    }
}

