/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.InspectionExecResult;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.inspection.BatchDataSet;
import kd.tmc.fpm.business.domain.model.inspection.BillNotExistExecRecord;
import kd.tmc.fpm.business.domain.model.inspection.log.BillNotExistInfo;
import kd.tmc.fpm.business.domain.model.inspection.log.BillNotExistLog;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.impl.AbstractDataInspectService;
import kd.tmc.fpm.business.mvc.service.inspection.query.impl.PlanExecuteRecordInspectDataQueryService;
import org.apache.commons.collections.CollectionUtils;

public class ExecuteRecordSourceBillNotExistsDataInspectService
extends AbstractDataInspectService<BillNotExistLog> {
    public ExecuteRecordSourceBillNotExistsDataInspectService(InspectContext inspectContext) {
        super(inspectContext);
    }

    @Override
    public void doDataInspect(BillNotExistLog billNotExistLog) {
        PlanExecuteRecordInspectDataQueryService inspectDataQueryService = new PlanExecuteRecordInspectDataQueryService();
        ArrayList<Long> notExistBillExecRecordIdList = new ArrayList<Long>(256);
        try (BatchDataSet batchDataSet = inspectDataQueryService.query(this.inspectContext, null);){
            while (batchDataSet.hasNext()) {
                List execRecordList = batchDataSet.getBatchData();
                execRecordList.removeIf(billNotExistExecRecord -> billNotExistExecRecord.isAllRelease() || billNotExistExecRecord.getExecuteOpType() == PlanExecuteOpType.RELEASE || billNotExistExecRecord.getExecuteOpType() == PlanExecuteOpType.PRE_OCCUPY_RELEASE);
                List<BillNotExistExecRecord> recordsWithEntryId = execRecordList.stream().filter(billNotExistExecRecord -> EmptyUtil.isNoEmpty((Long)billNotExistExecRecord.getEntryId())).collect(Collectors.toList());
                List<BillNotExistExecRecord> recordsWithoutEntryId = execRecordList.stream().filter(billNotExistExecRecord -> EmptyUtil.isEmpty((Long)billNotExistExecRecord.getEntryId())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(recordsWithEntryId)) {
                    this.checkoutRecordWithEntryId(recordsWithEntryId, notExistBillExecRecordIdList);
                }
                if (!CollectionUtils.isNotEmpty(recordsWithoutEntryId)) continue;
                this.checkoutRecordWithoutEntryId(recordsWithoutEntryId, notExistBillExecRecordIdList);
            }
        }
        if (!CollectionUtils.isEmpty(notExistBillExecRecordIdList)) {
            billNotExistLog.setExecResult(InspectionExecResult.EXCEPTION);
            billNotExistLog.setInspectionRepairResult(InspectionRepairResult.PENDING);
            List<BillNotExistInfo> billNotExistInfos = notExistBillExecRecordIdList.stream().map(BillNotExistInfo::createExceptionInfo).collect(Collectors.toList());
            billNotExistLog.setExecRecordErrorInfoList(billNotExistInfos);
        }
    }

    private void checkoutRecordWithoutEntryId(List<BillNotExistExecRecord> execRecordList, List<Long> notExistBillExecRecordIdList) {
        Map<String, List<BillNotExistExecRecord>> bizRecordMap = execRecordList.stream().collect(Collectors.groupingBy(BillNotExistExecRecord::getEntityType));
        for (Map.Entry<String, List<BillNotExistExecRecord>> entityTypeEntry : bizRecordMap.entrySet()) {
            String entityType = entityTypeEntry.getKey();
            List<BillNotExistExecRecord> recordsInGroup = entityTypeEntry.getValue();
            Set billIdListINGroup = recordsInGroup.stream().map(BillNotExistExecRecord::getBillId).collect(Collectors.toSet());
            DynamicObjectCollection existBillIdColl = QueryServiceHelper.query((String)entityType, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdListINGroup)});
            Set existBillIdSet = existBillIdColl.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            List billNotExistRecordIdsInGroup = recordsInGroup.stream().filter(record -> !existBillIdSet.contains(record.getBillId())).map(BillNotExistExecRecord::getExecRecordId).collect(Collectors.toList());
            notExistBillExecRecordIdList.addAll(billNotExistRecordIdsInGroup);
        }
    }

    private void checkoutRecordWithEntryId(List<BillNotExistExecRecord> execRecordList, List<Long> notExistBillExecRecordIdList) {
        Map<String, List<BillNotExistExecRecord>> bizRecordMap = execRecordList.stream().collect(Collectors.groupingBy(BillNotExistExecRecord::getEntityType));
        for (Map.Entry<String, List<BillNotExistExecRecord>> entityTypeEntry : bizRecordMap.entrySet()) {
            String entityType = entityTypeEntry.getKey();
            List<BillNotExistExecRecord> recordsInGroup = entityTypeEntry.getValue();
            Set billIdListINGroup = recordsInGroup.stream().map(BillNotExistExecRecord::getBillId).collect(Collectors.toSet());
            Set billEntryNumberList = recordsInGroup.stream().map(rc -> rc.getEntryNumber() + ".id").collect(Collectors.toSet());
            String selectedProps = "id," + String.join((CharSequence)",", billEntryNumberList);
            DynamicObjectCollection existBillIdColl = QueryServiceHelper.query((String)entityType, (String)selectedProps, (QFilter[])new QFilter[]{new QFilter("id", "in", billIdListINGroup)});
            HashMap billIdEntryIdMap = new HashMap();
            for (DynamicObject dynamicObject : existBillIdColl) {
                long billId = dynamicObject.getLong("id");
                Set entryIdSet = billEntryNumberList.stream().map(arg_0 -> ((DynamicObject)dynamicObject).getLong(arg_0)).collect(Collectors.toSet());
                if (billIdEntryIdMap.containsKey(billId)) {
                    ((Set)billIdEntryIdMap.get(billId)).addAll(entryIdSet);
                    continue;
                }
                billIdEntryIdMap.put(billId, entryIdSet);
            }
            for (BillNotExistExecRecord execRecord : recordsInGroup) {
                if (!billIdEntryIdMap.containsKey(execRecord.getBillId())) {
                    notExistBillExecRecordIdList.add(execRecord.getExecRecordId());
                    continue;
                }
                Set entryIdSet = (Set)billIdEntryIdMap.get(execRecord.getBillId());
                if (entryIdSet.contains(execRecord.getEntryId())) continue;
                notExistBillExecRecordIdList.add(execRecord.getExecRecordId());
            }
        }
    }

    @Override
    protected BillNotExistLog getLogInstance() {
        return new BillNotExistLog();
    }
}

