/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.postprocessor;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.DimensionMemberMappingParam;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.mvc.service.dimmapping.impl.AbstractDimensionMemberMappingManager;
import kd.tmc.fpm.business.mvc.service.dimmapping.impl.DimensionMemberMappingManager;
import kd.tmc.fpm.business.mvc.service.inspection.IDataInspectParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;

public class DateInspectParamReportOrgFilterPostProcessor
implements IDataInspectParamPostProcessor {
    private static final Log logger = LogFactory.getLog(DateInspectParamReportOrgFilterPostProcessor.class);

    @Override
    public void postProcess(InspectContext inspectContext, InspectParam dataInspectParam) {
        List<BillBizInfo> billBizInfoList = dataInspectParam.getBillBizInfoList();
        FundPlanSystem system = inspectContext.getSystem();
        Dimension orgDim = system.getMainDimensionByDimType(DimensionType.ORG);
        BillMatchRule matchRule = inspectContext.getMatchRule(dataInspectParam.getInspectControlConfigItem().getMatchRuleId());
        AbstractDimensionMemberMappingManager<Long> dimensionMemberMappingManager = new DimensionMemberMappingManager().addDimensionId(orgDim.getId());
        Set<Long> inspectReportOrgScope = inspectContext.getInspectReportOrgScope();
        logger.info("DateInspectParamReportOrgFilterPostProcessor\u8fc7\u6ee4\u524d\u5927\u5c0f\uff0c\u7f16\u62a5\u4e3b\u4f53\u8303\u56f4\u5927\u5c0f\uff1a{}\uff0c\uff1a{}", (Object)(EmptyUtil.isEmpty(inspectReportOrgScope) ? 0 : inspectReportOrgScope.size()), (Object)billBizInfoList.size());
        Iterator<BillBizInfo> iterator = billBizInfoList.iterator();
        while (iterator.hasNext()) {
            BillBizInfo billBizInfo = iterator.next();
            AtomicLong reportOrgId = new AtomicLong(0L);
            DimensionMemberMappingParam<Long> dimensionMemberMappingParam = DimensionMemberMappingParam.builder().fundPlanSystem(system).billMatchRule(matchRule).billBizInfo(billBizInfo).callBack((dimension, aLong) -> reportOrgId.set((long)aLong)).build();
            dimensionMemberMappingManager.process(dimensionMemberMappingParam);
            if (EmptyUtil.isEmpty((Long)reportOrgId.get())) {
                iterator.remove();
                continue;
            }
            if (!EmptyUtil.isNoEmpty(inspectReportOrgScope) || inspectReportOrgScope.contains(reportOrgId.get())) continue;
            iterator.remove();
        }
        logger.info("DateInspectParamReportOrgFilterPostProcessor\u8fc7\u6ee4\u540e\u5927\u5c0f\uff1a{}", (Object)billBizInfoList.size());
    }
}

