/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.postprocessor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.inspection.InspectControlConfig;
import kd.tmc.fpm.business.domain.model.inspection.InspectionConfig;
import kd.tmc.fpm.business.mvc.service.inspection.IDataInspectParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;
import kd.tmc.fpm.business.utils.BillUtils;
import kd.tmc.fpm.business.utils.DynamicObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class InspectParamConditionPostProcessor
implements IDataInspectParamPostProcessor {
    private static final Log logger = LogFactory.getLog(InspectParamConditionPostProcessor.class);
    private Map<Long, DynamicObject> dynamicObjectMap;

    public InspectParamConditionPostProcessor(Map<Long, DynamicObject> dynamicObjectMap) {
        this.dynamicObjectMap = dynamicObjectMap;
    }

    @Override
    public void postProcess(InspectContext inspectContext, InspectParam dataInspectParam) {
        List<BillBizInfo> billBizInfoList = dataInspectParam.getBillBizInfoList();
        InspectControlConfig.InspectControlConfigItem inspectControlConfigItem = dataInspectParam.getInspectControlConfigItem();
        BillMatchRule matchRule = inspectContext.getMatchRule(inspectControlConfigItem.getMatchRuleId());
        InspectionConfig inspectionConfig = inspectContext.getInspectionConfig();
        String entityType = matchRule.getEntityType();
        String conditionStr = inspectControlConfigItem.getCondition();
        logger.info("InspectParamConditionPostProcessor \u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}\uff0c\u64cd\u4f5c\uff1a{},\u5de1\u68c0\u6761\u4ef6:{}\uff0c\u5bf9\u5e94\u7684\u5de1\u68c0\u914d\u7f6e\uff1a{}\uff0c\u8fc7\u6ee4\u524d\u5927\u5c0f:{}", new Object[]{entityType, inspectControlConfigItem.getPlanExecuteOpType(), conditionStr, inspectionConfig.getNumber(), billBizInfoList.size()});
        ConditionCheck conditionCheck = new ConditionCheck(entityType, conditionStr);
        Iterator<BillBizInfo> iterator = billBizInfoList.iterator();
        while (iterator.hasNext()) {
            BillBizInfo billBizInfo = iterator.next();
            Long billId = billBizInfo.getBillId();
            DynamicObject dynamicObject = this.dynamicObjectMap.get(billId);
            if (conditionCheck.checkCondition(dynamicObject)) continue;
            iterator.remove();
        }
        logger.info("InspectParamConditionPostProcessor \u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}\uff0c\u64cd\u4f5c\uff1a{},\u5de1\u68c0\u6761\u4ef6:{}\uff0c\u5bf9\u5e94\u7684\u5de1\u68c0\u914d\u7f6e\uff1a{} \u8fc7\u6ee4\u540e\u5927\u5c0f\uff1a{}", new Object[]{entityType, inspectControlConfigItem.getPlanExecuteOpType(), conditionStr, inspectionConfig.getNumber(), billBizInfoList.size()});
    }

    static class ConditionCheck {
        private String entityType;
        private String conditionStr;
        private Set<String> conditionFields;
        private CRCondition condition;
        private ISingleTaskContext taskContext;
        private MainEntityType mainEntityType;
        private String filterStr;

        public ConditionCheck(String entityType, String conditionStr) {
            this.entityType = entityType;
            this.conditionStr = conditionStr;
            this.init();
        }

        private void init() {
            this.condition = (CRCondition)SerializationUtils.fromJsonString((String)this.conditionStr, CRCondition.class);
            this.conditionFields = BillUtils.parseFieldsFormCondition(this.conditionStr, this.entityType);
            this.mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityType);
            this.filterStr = this.condition.buildFullFormula(this.mainEntityType);
            this.taskContext = new SingleTaskContext();
            this.taskContext.setSrcEntityType(this.mainEntityType);
        }

        private boolean checkCondition(DynamicObject sourceBill) {
            Boolean value;
            List<DynamicObject> dynamicObjectList = DynamicObjectUtils.toPlainDynamicObjectCollection(new DynamicObject[]{sourceBill}, this.conditionFields);
            if (EmptyUtil.isEmpty(dynamicObjectList)) {
                return false;
            }
            DynamicObjectType dynamicObjectType = dynamicObjectList.get(0).getDynamicObjectType();
            String entryName = DynamicObjectUtils.getEntryNameIfHas(sourceBill, this.conditionFields);
            HashMap filterProperties = new HashMap(this.conditionFields.size());
            this.conditionFields.forEach(field -> filterProperties.put(DynamicObjectUtils.getEntryPropertyWithOutEntryName(entryName, field), dynamicObjectType.getProperty(DynamicObjectUtils.getEntryPropertyWithOutEntryName(entryName, field))));
            try {
                FormulaGetHandle baseBillFilterHandle = new FormulaGetHandle(this.taskContext, this.filterStr, (Object)Boolean.FALSE);
                value = (Boolean)baseBillFilterHandle.GetVchFldValue(filterProperties, dynamicObjectList.get(0), null);
            }
            catch (Exception e) {
                String errorMsg = String.format("%s%s => %s", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u9519\u8bef\uff1a", (String)"InspectParamConditionPostProcessor_0", (String)"tmc-fpm-business", (Object[])new Object[0]), this.condition.getExpression(), ExceptionUtils.getStackTrace((Throwable)e));
                throw new KDBizException(errorMsg);
            }
            if (value == null) {
                return false;
            }
            return value;
        }
    }
}

