/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.query.impl;

import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.inspection.BatchDataSet;
import kd.tmc.fpm.business.domain.model.inspection.InspectDateRange;
import kd.tmc.fpm.business.domain.model.inspection.InspectQueryParam;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.query.IInspectDataQueryService;

public class BusinessBillInspectDataQueryService
implements IInspectDataQueryService<Long> {
    @Override
    public BatchDataSet<Long> query(InspectContext inspectContext, InspectQueryParam inspectQueryParam) {
        BillMatchRule billMatchRule = (BillMatchRule)inspectQueryParam.getValue("matchRule");
        FundPlanSystem system = inspectContext.getSystem();
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        MatchMapping periodMatchMapping = billMatchRule.getMappings().stream().filter(matchMapping -> Objects.equals(matchMapping.getDimId(), periodDim.getId())).findFirst().get();
        InspectDateRange inspectDateRange = inspectContext.getInspectDateRange();
        QFilter qFilter = new QFilter(periodMatchMapping.getBizProp(), ">=", (Object)inspectDateRange.getMinStartDate()).and(periodMatchMapping.getBizProp(), "<=", (Object)inspectDateRange.getMaxEndDate());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BusinessBillInspectDataQueryService.query", (String)inspectQueryParam.getStringValue("entityType"), (String)"id", (QFilter[])new QFilter[]{qFilter}, null);
        return new BatchDataSet<Long>(Long.class, dataSet, 1000);
    }
}

