/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.query.impl;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.inspection.BatchDataSet;
import kd.tmc.fpm.business.domain.model.inspection.BillNotExistExecRecord;
import kd.tmc.fpm.business.domain.model.inspection.InspectDateRange;
import kd.tmc.fpm.business.domain.model.inspection.InspectQueryParam;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.query.IInspectDataQueryService;

public class PlanExecuteRecordInspectDataQueryService
implements IInspectDataQueryService<BillNotExistExecRecord> {
    @Override
    public BatchDataSet<BillNotExistExecRecord> query(InspectContext inspectContext, InspectQueryParam inspectQueryParam) {
        InspectDateRange inspectDateRange = inspectContext.getInspectDateRange();
        Set<Long> allPeriodMemberIdList = inspectDateRange.getAllPeriodMemberIdList();
        if (allPeriodMemberIdList.size() == 0) {
            return new BatchDataSet<BillNotExistExecRecord>(BillNotExistExecRecord.class, null, 0);
        }
        QFilter qFilter = new QFilter("bodysys", "=", (Object)inspectContext.getSystem().getId());
        qFilter.and(new QFilter("reportperiod", "in", allPeriodMemberIdList));
        Set<Long> inspectReportOrgScope = inspectContext.getInspectReportOrgScope();
        if (inspectReportOrgScope.size() == 0) {
            Dimension orgDimension = inspectContext.getSystem().getMainDimensionByDimType(DimensionType.ORG);
            inspectReportOrgScope = orgDimension.getAllDimMemberList().stream().map(DimMember::getId).collect(Collectors.toSet());
        }
        qFilter.and(new QFilter("reportorg", "in", inspectReportOrgScope));
        qFilter.and(new QFilter("deleteflag", "=", (Object)Character.valueOf('0')));
        String selectFields = String.join((CharSequence)",", "bizbillid", "billbizetype", "bizbillcode", "id", "entryid", "entrytypenumber", "realamt", "releasedamt", "planexecuteop");
        DataSet rows = QueryServiceHelper.queryDataSet((String)"inspectionLog.queryBillNotExist", (String)"fpm_executeplan", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");
        return new BatchDataSet<BillNotExistExecRecord>(BillNotExistExecRecord.class, rows, 1000);
    }
}

