/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.strategy.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.inspection.InspectControlResult;
import kd.tmc.fpm.business.mvc.service.inspection.context.BusinessBillExecuteRecordInfo;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.AbstractDataInspectStrategy;

public class ActualCancelDataInspectStrategy
extends AbstractDataInspectStrategy {
    public ActualCancelDataInspectStrategy(InspectContext inspectContext) {
        super(inspectContext);
    }

    @Override
    public InspectControlResult handler(InspectParam inspectParam) {
        InspectControlResult inspectControlResult = super.handler(inspectParam);
        List<BillBizInfo> billBizInfoList = inspectParam.getBillBizInfoList();
        logger.info("\u5b9e\u5360\u53d6\u6d88\u5de1\u68c0\u5f85\u5904\u7406\u4e1a\u52a1\u5355\u636e\u8bb0\u5f55\u6761\u6570\uff1a{}", (Object)billBizInfoList.size());
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = this.inspectContext.getBusinessBillExecuteRecordInfo();
        for (BillBizInfo billBizInfo : billBizInfoList) {
            List<PlanExecuteRecord> actualPlanExecuteRecordList;
            if (inspectControlResult.isError(billBizInfo) || EmptyUtil.isEmpty(actualPlanExecuteRecordList = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, PlanExecuteOpType.WRITE))) continue;
            List<PlanExecuteRecord> planExecuteRecordByOp = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, PlanExecuteOpType.UPDATE);
            Map<Long, List<PlanExecuteRecord>> originalListMap = planExecuteRecordByOp.stream().collect(Collectors.groupingBy(PlanExecuteRecord::getOriginalRecordId));
            Optional<PlanExecuteRecord> any = actualPlanExecuteRecordList.stream().filter(p -> EmptyUtil.isEmpty((Collection)((Collection)originalListMap.get(p.getId()))) ? p.isNotAllRelease() : p.isNotAllReleaseForActual()).findAny();
            if (!any.isPresent()) continue;
            inspectControlResult.addBillBizInfo(billBizInfo);
        }
        return inspectControlResult;
    }
}

