/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.strategy.impl;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.ControlActTime;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.inspection.InspectControlResult;
import kd.tmc.fpm.business.mvc.service.inspection.context.BusinessBillExecuteRecordInfo;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.AbstractDataInspectStrategy;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.utils.NumberUtils;

public class ActualUpdateDataInspectStrategy
extends AbstractDataInspectStrategy {
    public ActualUpdateDataInspectStrategy(InspectContext inspectContext) {
        super(inspectContext);
    }

    @Override
    public InspectControlResult handler(InspectParam inspectParam) {
        InspectControlResult inspectControlResult = super.handler(inspectParam);
        List<BillBizInfo> billBizInfoList = inspectParam.getBillBizInfoList();
        logger.info("\u5b9e\u5360\u8fd4\u8fd8\u5de1\u68c0\u5f85\u5904\u7406\u4e1a\u52a1\u5355\u636e\u8bb0\u5f55\u6761\u6570\uff1a{}", (Object)billBizInfoList.size());
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = this.inspectContext.getBusinessBillExecuteRecordInfo();
        ControlTime controlTime = this.inspectContext.getControlTime();
        Optional<ControlActTime> first = controlTime.getControlActTimeList().stream().filter(t -> Objects.equals(t.getBizBill(), inspectParam.getEntityType())).filter(controlActTime -> EmptyUtil.isNoEmpty(controlActTime.getActUpdateTime())).findFirst();
        if (!first.isPresent()) {
            logger.warn("\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{} \u672a\u914d\u7f6e\u6267\u884c\u65f6\u673a\u5b9e\u5360\u5206\u5f55\u5b9e\u5360\u66f4\u65b0\u914d\u7f6e", (Object)inspectParam.getEntityType());
            return inspectControlResult;
        }
        ControlActTime controlActTime2 = first.get();
        String updateAmtField = controlActTime2.getAclUpdateAmtField();
        if (EmptyUtil.isEmpty((String)updateAmtField)) {
            logger.warn("\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{} \u672a\u914d\u7f6e\u5b9e\u5360\u66f4\u65b0\u5b57\u6bb5", (Object)inspectParam.getEntityType());
            return inspectControlResult;
        }
        for (BillBizInfo billBizInfo : billBizInfoList) {
            if (inspectControlResult.isError(billBizInfo)) continue;
            List<PlanExecuteRecord> actualPlanExecuteRecordList = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, PlanExecuteOpType.WRITE);
            if (EmptyUtil.isEmpty(actualPlanExecuteRecordList)) {
                logger.info("{}\u4e0d\u5b58\u5728\u5b9e\u5360\u8bb0\u5f55\uff0c\u6b63\u5e38\u3002", (Object)billBizInfo.getBillNo());
                continue;
            }
            List<PlanExecuteRecord> actualUpdatePlanExecuteRecordList = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, PlanExecuteOpType.UPDATE);
            if (EmptyUtil.isEmpty(actualUpdatePlanExecuteRecordList)) {
                inspectControlResult.addBillBizInfo(billBizInfo);
                continue;
            }
            Optional<BizProps> bizPropsOptional = billBizInfo.getBizProps().stream().filter(bizProps -> Objects.equals(bizProps.getBizProp(), updateAmtField)).findFirst();
            if (!bizPropsOptional.isPresent()) {
                logger.warn("\u4e1a\u52a1\u5355\u636e:{}\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u7c7b\u578b\uff1a{}\uff0c\u6267\u884c\u59cb\u7ec8\u4e2d\u914d\u7f6e\u7684\u8fd4\u8fd8\u5b57\u6bb5\uff1a{}\u672a\u5339\u914d\u4e0a", new Object[]{billBizInfo.getBillNo(), billBizInfo.getEntityType(), updateAmtField});
                continue;
            }
            actualUpdatePlanExecuteRecordList.sort(Comparator.comparing(PlanExecuteRecord::getCreateTime).reversed());
            BigDecimal actAmount = actualUpdatePlanExecuteRecordList.get(0).getAclRemainAmt();
            BigDecimal bigDecimalValue = CommonUtils.getBigDecimalValue(bizPropsOptional.get().getValue());
            if (NumberUtils.equals((BigDecimal)actAmount, (BigDecimal)bigDecimalValue)) continue;
            inspectControlResult.addBillBizInfo(billBizInfo);
        }
        return inspectControlResult;
    }
}

