/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.strategy.impl;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.InspectErrorType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.inspection.InspectControlResult;
import kd.tmc.fpm.business.domain.model.inspection.PlanRecordInfo;
import kd.tmc.fpm.business.mvc.service.inspection.context.BusinessBillExecuteRecordInfo;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.AbstractDataInspectStrategy;
import kd.tmc.fpm.common.utils.NumberUtils;

public class ControlTraceRelationDataInspectStrategy
extends AbstractDataInspectStrategy {
    public ControlTraceRelationDataInspectStrategy(InspectContext inspectContext) {
        super(inspectContext);
    }

    @Override
    public InspectControlResult handler(InspectParam inspectParam) {
        InspectControlResult result = super.handler(inspectParam);
        PlanExecuteOpType planExecuteOpType = inspectParam.getInspectControlConfigItem().getPlanExecuteOpType();
        if (!planExecuteOpType.isPositiveOp()) {
            return result;
        }
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = this.inspectContext.getBusinessBillExecuteRecordInfo();
        List<BillBizInfo> billBizInfoList = inspectParam.getBillBizInfoList();
        for (BillBizInfo billBizInfo : billBizInfoList) {
            List<PlanExecuteRecord> planExecuteRecordByOp;
            Long controlTraceId;
            List<ControlBOTPInfo> upperBillBIzInfoList = businessBillExecuteRecordInfo.getUpperBillBIzInfoList(billBizInfo.getBillId());
            if (EmptyUtil.isEmpty(upperBillBIzInfoList) || EmptyUtil.isEmpty((Long)(controlTraceId = businessBillExecuteRecordInfo.getControlTraceId(billBizInfo.getBillId()))) || EmptyUtil.isEmpty(planExecuteRecordByOp = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, planExecuteOpType).stream().filter(PlanExecuteRecord::isNotAllRelease).collect(Collectors.toList()))) continue;
            Set<Long> recordIds = planExecuteRecordByOp.stream().map(PlanExecuteRecord::getId).collect(Collectors.toSet());
            List<PlanExecuteRecord> planExecuteRecordByRelateRecordIds = businessBillExecuteRecordInfo.getPlanExecuteRecordByRelateRecordIds(recordIds);
            if (EmptyUtil.isEmpty(planExecuteRecordByRelateRecordIds)) {
                this.upperReleaseIfHasError(result, billBizInfo, inspectParam, planExecuteRecordByOp);
                continue;
            }
            Map<Long, List<PlanExecuteRecord>> relateRecordGroupMap = planExecuteRecordByRelateRecordIds.stream().filter(p -> p.getExecuteOpType() == ControlTraceRelationDataInspectStrategy.getReleaseOpTypeForControlTraceDataInspect(planExecuteOpType)).collect(Collectors.groupingBy(PlanExecuteRecord::getRelateRecordId));
            for (PlanExecuteRecord planExecuteRecord : planExecuteRecordByOp) {
                BigDecimal bigDecimal;
                List<PlanExecuteRecord> planExecuteRecordList = relateRecordGroupMap.get(planExecuteRecord.getId());
                if (EmptyUtil.isEmpty(planExecuteRecordList)) {
                    this.upperReleaseIfHasError(result, billBizInfo, inspectParam, Collections.singletonList(planExecuteRecord));
                    continue;
                }
                BigDecimal actAmount = planExecuteRecord.getActAmount().abs();
                if (NumberUtils.equals((BigDecimal)actAmount, (BigDecimal)(bigDecimal = planExecuteRecordList.stream().map(PlanExecuteRecord::getActAmount).map(BigDecimal::negate).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)))) continue;
                this.upperReleaseIfHasError(result, billBizInfo, inspectParam, Collections.singletonList(planExecuteRecord));
            }
        }
        return result;
    }

    private void upperReleaseIfHasError(InspectControlResult result, BillBizInfo billBizInfo, InspectParam inspectParam, List<PlanExecuteRecord> planExecuteRecordList) {
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = this.inspectContext.getBusinessBillExecuteRecordInfo();
        List<ControlBOTPInfo> upperBillBIzInfoList = businessBillExecuteRecordInfo.getUpperBillBIzInfoList(billBizInfo.getBillId());
        boolean multiSource = businessBillExecuteRecordInfo.isMultiSourceBillId(billBizInfo.getBillId());
        Long controlTraceId = businessBillExecuteRecordInfo.getControlTraceId(billBizInfo.getBillId());
        for (ControlBOTPInfo controlBOTPInfo : upperBillBIzInfoList) {
            Long upperControlTraceId;
            List executeRecordByOp = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(controlBOTPInfo, inspectParam.getInspectControlConfigItem().getPlanExecuteOpType()).stream().filter(PlanExecuteRecord::isNotAllRelease).collect(Collectors.toList());
            if (!EmptyUtil.isNoEmpty(executeRecordByOp) || !Objects.equals(upperControlTraceId = businessBillExecuteRecordInfo.getControlTraceId(controlBOTPInfo.getId()), controlTraceId) && !multiSource) continue;
            result.addPlanRecordInfos(planExecuteRecordList.stream().map(p -> PlanRecordInfo.getInstance(p, InspectErrorType.REPEAT_OCCUPY_WRITE)).collect(Collectors.toList()));
        }
    }

    public static PlanExecuteOpType getReleaseOpTypeForControlTraceDataInspect(PlanExecuteOpType planExecuteOpType) {
        return PlanExecuteOpType.PRE_OCCUPY_RELEASE;
    }
}

