/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.strategy.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.InspectErrorType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.inspection.InspectControlResult;
import kd.tmc.fpm.business.domain.model.inspection.PlanRecordInfo;
import kd.tmc.fpm.business.mvc.service.impl.ControlStrategyDelegate;
import kd.tmc.fpm.business.mvc.service.inspection.context.BusinessBillExecuteRecordInfo;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.AbstractDataInspectStrategy;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.ControlTraceRelationDataInspectStrategy;
import kd.tmc.fpm.common.utils.NumberUtils;

public class ControlTraceReleaseOverageCheckDataInspectStrategy
extends AbstractDataInspectStrategy {
    public ControlTraceReleaseOverageCheckDataInspectStrategy(AbstractDataInspectStrategy abstractDataInspectStrategy) {
        super(abstractDataInspectStrategy);
    }

    public ControlTraceReleaseOverageCheckDataInspectStrategy(InspectContext inspectContext) {
        super(new ControlTraceRelationDataInspectStrategy(inspectContext));
    }

    @Override
    public InspectControlResult handler(InspectParam inspectParam) {
        InspectControlResult inspectControlResult = super.handler(inspectParam);
        List<BillBizInfo> billBizInfoList = inspectParam.getBillBizInfoList();
        PlanExecuteOpType planExecuteOpType = inspectParam.getInspectControlConfigItem().getPlanExecuteOpType();
        if (!planExecuteOpType.isPositiveOp()) {
            return inspectControlResult;
        }
        OverageReleaseCheck overageReleaseCheck = new OverageReleaseCheck(this.inspectContext, inspectControlResult);
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = this.inspectContext.getBusinessBillExecuteRecordInfo();
        for (BillBizInfo billBizInfo : billBizInfoList) {
            List<PlanExecuteRecord> planExecuteRecordByOp = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, planExecuteOpType);
            overageReleaseCheck.check(planExecuteRecordByOp);
            List<ControlBOTPInfo> upperBillBIzInfoList = businessBillExecuteRecordInfo.getUpperBillBIzInfoList(billBizInfo.getBillId());
            if (EmptyUtil.isEmpty(upperBillBIzInfoList)) continue;
            for (ControlBOTPInfo controlBOTPInfo : upperBillBIzInfoList) {
                List<PlanExecuteRecord> upperPlanExecuteRecords = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(controlBOTPInfo, planExecuteOpType);
                overageReleaseCheck.check(upperPlanExecuteRecords);
            }
        }
        return inspectControlResult;
    }

    static class OverageReleaseCheck {
        protected InspectContext inspectContext;
        protected PlanExecuteOpType planExecuteOpType;
        protected InspectControlResult inspectControlResult;
        protected ControlStrategyDelegate controlStrategyDelegate;

        public OverageReleaseCheck(InspectContext inspectContext, InspectControlResult inspectControlResult) {
            this.inspectContext = inspectContext;
            this.inspectControlResult = inspectControlResult;
            this.planExecuteOpType = inspectControlResult.getPlanExecuteOpType();
            this.controlStrategyDelegate = new ControlStrategyDelegate(null);
        }

        public void check(List<PlanExecuteRecord> planExecuteRecordByOp) {
            if (EmptyUtil.isEmpty(planExecuteRecordByOp)) {
                return;
            }
            List actualUpdateRecordList = this.planExecuteOpType.isWrite() ? this.inspectContext.getBusinessBillExecuteRecordInfo().getPlanExecuteRecordByOp(planExecuteRecordByOp.get(0).getBillBizInfo(), PlanExecuteOpType.UPDATE) : Collections.emptyList();
            Map<Long, List<PlanExecuteRecord>> originalRecordListMap = actualUpdateRecordList.stream().collect(Collectors.groupingBy(PlanExecuteRecord::getOriginalRecordId));
            planExecuteRecordByOp.stream().filter(p -> EmptyUtil.isEmpty((Collection)((Collection)originalRecordListMap.get(p.getId()))) ? this.controlStrategyDelegate.largeThan(p.getReleasedAmt(), p.getActAmount()) : ((List)originalRecordListMap.get(p.getId())).stream().anyMatch(pp -> NumberUtils.isOnePlusAndOneMinus((BigDecimal)pp.getAclRemainAmt(), (BigDecimal)pp.getActAmount()))).map(p -> PlanRecordInfo.getInstance(p, this.getInspectErrorType())).forEach(this.inspectControlResult::addPlanRecordInfo);
        }

        private InspectErrorType getInspectErrorType() {
            if (this.planExecuteOpType.isOccupy()) {
                return InspectErrorType.OVERAGE_OCCUPY_RELEASE;
            }
            return InspectErrorType.OVERAGE_ACTUAL_RELEASE;
        }
    }
}

