/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.strategy.impl;

import java.util.List;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.inspection.InspectControlResult;
import kd.tmc.fpm.business.mvc.service.inspection.context.BusinessBillExecuteRecordInfo;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.AbstractDataInspectStrategy;

public class OccupyDataInspectStrategy
extends AbstractDataInspectStrategy {
    public OccupyDataInspectStrategy(InspectContext inspectContext) {
        super(inspectContext);
    }

    @Override
    public InspectControlResult handler(InspectParam inspectParam) {
        InspectControlResult inspectControlResult = super.handler(inspectParam);
        List<BillBizInfo> billBizInfoList = inspectParam.getBillBizInfoList();
        logger.info("\u9884\u5360\u5de1\u68c0\u5f85\u5904\u7406\u4e1a\u52a1\u5355\u636e\u8bb0\u5f55\u6761\u6570\uff1a{}", (Object)billBizInfoList.size());
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = this.inspectContext.getBusinessBillExecuteRecordInfo();
        block0: for (BillBizInfo billBizInfo : billBizInfoList) {
            if (inspectControlResult.isError(billBizInfo)) continue;
            Long billId = billBizInfo.getBillId();
            if (!this.billExecuteRecordExistsError(billBizInfo)) continue;
            List<ControlBOTPInfo> downBillBizInfos = businessBillExecuteRecordInfo.getDownBillBizInfoList(billId);
            if (EmptyUtil.isEmpty(downBillBizInfos)) {
                inspectControlResult.addBillBizInfo(billBizInfo);
                continue;
            }
            for (ControlBOTPInfo controlBOTPInfo : downBillBizInfos) {
                if (this.billExecuteRecordExistsError(controlBOTPInfo)) continue;
                continue block0;
            }
            inspectControlResult.addBillBizInfo(billBizInfo);
        }
        return inspectControlResult;
    }

    private boolean billExecuteRecordExistsError(BillBizInfo billBizInfo) {
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = this.inspectContext.getBusinessBillExecuteRecordInfo();
        List occupyRecordList = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, PlanExecuteOpType.PRE_OCCUPY_WRITE).stream().filter(PlanExecuteRecord::isNotAllRelease).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(occupyRecordList)) {
            List<PlanExecuteRecord> actualRecordList = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, PlanExecuteOpType.WRITE);
            return EmptyUtil.isEmpty(actualRecordList);
        }
        return false;
    }

    private boolean billExecuteRecordExistsError(ControlBOTPInfo controlBOTPInfo) {
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = this.inspectContext.getBusinessBillExecuteRecordInfo();
        List occupyRecordList = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(controlBOTPInfo, PlanExecuteOpType.PRE_OCCUPY_WRITE).stream().filter(PlanExecuteRecord::isNotAllRelease).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(occupyRecordList)) {
            List<PlanExecuteRecord> actualRecordList = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(controlBOTPInfo, PlanExecuteOpType.WRITE);
            return EmptyUtil.isEmpty(actualRecordList);
        }
        return false;
    }
}

