/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.controlmatch.impl;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchResultInfo;
import kd.tmc.fpm.business.domain.model.match.MatchValue;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.business.mvc.service.match.controlmatch.impl.AbstractControlMatch;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public abstract class AbstractSingleGroupControlMatch
extends AbstractControlMatch {
    @Override
    MatchResultInfo doMatch(MatchInfo matchInfo, List<GroupReportData> groupReportDataList) {
        ArrayList<GroupReportData> groupReportDataResultList = new ArrayList<GroupReportData>(groupReportDataList.size());
        for (GroupReportData groupReportData : groupReportDataList) {
            if (groupReportData.hasException()) {
                groupReportDataResultList.add(groupReportData);
                continue;
            }
            GroupReportData groupReportDataResult = this.doMatch(matchInfo, groupReportData);
            if (groupReportDataResult.isAbort()) {
                return this.error(groupReportDataResult.getMatchException());
            }
            groupReportDataResultList.add(groupReportDataResult);
        }
        return this.success(groupReportDataResultList);
    }

    protected abstract GroupReportData doMatch(MatchInfo var1, GroupReportData var2);

    protected void processIfNotMatch(DimMatch dimMatch, MatchValue matchValue) {
        MatchException matchException = new MatchException(dimMatch.matchInfo, matchValue.getDimension(), true);
        GroupReportData result = dimMatch.getResult();
        DimensionInfoBean dimensionInfoBean = result.getDimensionInfoBean();
        dimensionInfoBean.removeDimensionInfo(matchValue.getDimension().getId());
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a{}\uff0c\u5339\u914d\u5230\u7684\u503c\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\u662f\u5426\u5339\u914d\uff1a{}", new Object[]{matchException.getErrorMsg(), matchValue.getMatchValue(), matchValue.isMatched(), matchException});
        result.setMatchException(matchException);
    }

    public static class DimMatch {
        private MatchInfo matchInfo;
        private GroupReportData groupReportData;
        private GroupReportData result;
        private AbstractSingleGroupControlMatch abstractSingleGroupControlMatch;

        public DimMatch(AbstractSingleGroupControlMatch abstractSingleGroupControlMatch, MatchInfo matchInfo, GroupReportData groupReportData) {
            this.abstractSingleGroupControlMatch = abstractSingleGroupControlMatch;
            this.matchInfo = matchInfo;
            this.groupReportData = groupReportData;
            this.result = groupReportData.copy();
        }

        public GroupReportData getResult() {
            return this.result;
        }

        public GroupReportData getGroupReportData() {
            return this.groupReportData;
        }

        public MatchInfo getMatchInfo() {
            return this.matchInfo;
        }

        public GroupReportData matchDim(MatchValue matchValue) {
            Dimension dimension = matchValue.getDimension();
            if (dimension.getDimType().isDetailDim()) {
                return this.result;
            }
            if (!matchValue.isMatched()) {
                this.abstractSingleGroupControlMatch.processIfNotMatch(this, matchValue);
                return this.result;
            }
            QueryIndexInfo<Long, ReportData> queryIndexInfo = this.groupReportData.getQueryIndexInfo(this.matchInfo.getFundPlanSystem());
            DimensionInfoBean dimensionInfoBean = this.result.getDimensionInfoBean();
            dimensionInfoBean.addDimensionInfo(dimension.getId(), matchValue.getMatchValue());
            List<ReportData> list = queryIndexInfo.findList(dimensionInfoBean);
            if (EmptyUtil.isNoEmpty(list)) {
                this.result.setReportDataList(list);
                if (matchValue.getDimension().getDimType().isCurrencyDim() && !this.result.isSumData()) {
                    this.result.setOptionalReportDataList(list);
                }
                return this.result;
            }
            this.abstractSingleGroupControlMatch.processIfNotMatch(this, matchValue);
            return this.result;
        }
    }
}

