/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.controlmatch.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchValue;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.business.mvc.service.match.controlmatch.impl.AbstractSingleGroupControlMatch;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.helper.StringHelper;

public class DetailDimControlMatch
extends AbstractSingleGroupControlMatch {
    @Override
    protected GroupReportData doMatch(MatchInfo matchInfo, GroupReportData groupReportData) {
        List<MatchValue> detailDimMatchValues = matchInfo.getDetailDimMatchValues();
        if (EmptyUtil.isEmpty(detailDimMatchValues)) {
            return groupReportData;
        }
        if (!Objects.equals(matchInfo.getReportOrgId(), groupReportData.getReportOrgId())) {
            return groupReportData;
        }
        if (!groupReportData.isDetailPeriodData()) {
            return groupReportData;
        }
        List<ReportData> reportDataList = groupReportData.getReportDataList();
        GroupReportData copy = groupReportData.copy();
        DetailDimValueMatch detailDimValueMatch = new DetailDimValueMatch(copy, matchInfo);
        detailDimValueMatch.matchDetail(reportDataList);
        return copy;
    }

    static DetailFieldMatch getDetailFieldMatchChain() {
        return new DetailFieldMatchChainNode(new AmountFieldMatch()).addFirst(new DateFieldMatch()).addFirst(new BaseDataFieldMatch()).addFirst(new StringFieldMatch());
    }

    static class DetailFieldMatchChainNode
    implements DetailFieldMatch {
        private DetailFieldMatch detailFieldMatch;
        private DetailFieldMatchChainNode next;

        public DetailFieldMatchChainNode(DetailFieldMatch detailFieldMatch) {
            this.detailFieldMatch = detailFieldMatch;
        }

        public DetailFieldMatchChainNode(DetailFieldMatch detailFieldMatch, DetailFieldMatchChainNode next) {
            this.detailFieldMatch = detailFieldMatch;
            this.next = next;
        }

        public DetailFieldMatchChainNode addFirst(DetailFieldMatch detailFieldMatch) {
            return new DetailFieldMatchChainNode(detailFieldMatch, this);
        }

        @Override
        public boolean isMatch(MatchValue matchValue, Object targetVal) {
            boolean match = this.detailFieldMatch.isMatch(matchValue, targetVal);
            if (match) {
                return true;
            }
            if (Objects.nonNull(this.next)) {
                return this.next.isMatch(matchValue, targetVal);
            }
            return false;
        }
    }

    static class StringFieldMatch
    implements DetailFieldMatch {
        StringFieldMatch() {
        }

        @Override
        public boolean isMatch(MatchValue matchValue, Object targetVal) {
            if (Objects.isNull(targetVal)) {
                return true;
            }
            if (matchValue.isMatched()) {
                return Objects.equals(StringHelper.getStringValue((Object)matchValue.getMatchValue()), StringHelper.getStringValue((Object)targetVal));
            }
            return false;
        }
    }

    static class BaseDataFieldMatch
    implements DetailFieldMatch {
        BaseDataFieldMatch() {
        }

        @Override
        public boolean isMatch(MatchValue matchValue, Object targetVal) {
            Object val = matchValue.getMatchValue();
            if (Objects.equals(val, targetVal)) {
                return true;
            }
            if (!(val instanceof List)) {
                return false;
            }
            List valList = (List)val;
            for (Object pk : valList) {
                if (!Objects.equals(pk, targetVal)) continue;
                return true;
            }
            return false;
        }
    }

    static class DateFieldMatch
    implements DetailFieldMatch {
        private static final String format = "yyyy-MM-dd";

        DateFieldMatch() {
        }

        @Override
        public boolean isMatch(MatchValue matchValue, Object targetVal) {
            if (matchValue.getDimension().getMemberType() != MemberType.DATE) {
                return false;
            }
            Object val = matchValue.getMatchValue();
            String dateStringVal = this.getDateStringVal(val);
            String dateStringTargetVal = this.getDateStringVal(targetVal);
            return Objects.equals(dateStringVal, dateStringTargetVal);
        }

        private String getDateStringVal(Object val) {
            if (EmptyUtil.isEmpty((Object)val)) {
                return "";
            }
            if (val instanceof Date) {
                Date date = (Date)val;
                return DateUtils.formatString((Date)date, (String)format);
            }
            Date date = DateUtils.stringToDate((String)StringHelper.getStringValue((Object)val), (String)format);
            if (Objects.isNull(date)) {
                return "";
            }
            return DateUtils.formatString((Date)date, (String)format);
        }
    }

    static class AmountFieldMatch
    implements DetailFieldMatch {
        AmountFieldMatch() {
        }

        @Override
        public boolean isMatch(MatchValue matchValue, Object targetVal) {
            BigDecimal bigDecimalTargetVal;
            if (matchValue.getDimension().getMemberType() != MemberType.AMOUNT) {
                return false;
            }
            Object val = matchValue.getMatchValue();
            if (Objects.isNull(val) || Objects.isNull(targetVal)) {
                return false;
            }
            if (Objects.equals(val, targetVal)) {
                return true;
            }
            if (val instanceof BigDecimal && targetVal instanceof BigDecimal) {
                return ((BigDecimal)val).compareTo((BigDecimal)targetVal) == 0;
            }
            BigDecimal bigDecimalVal = new BigDecimal(StringHelper.getStringValue((Object)val));
            return bigDecimalVal.compareTo(bigDecimalTargetVal = new BigDecimal(StringHelper.getStringValue((Object)targetVal))) == 0;
        }
    }

    static interface DetailFieldMatch {
        public boolean isMatch(MatchValue var1, Object var2);
    }

    static class DetailDimValueMatch {
        private GroupReportData groupReportData;
        private List<MatchValue> matchValueList;
        private MatchInfo matchInfo;
        private Map<Long, Dimension> dimensionMap;
        private DetailFieldMatch detailFieldMatch;

        public DetailDimValueMatch(GroupReportData groupReportData, MatchInfo matchInfo) {
            this.groupReportData = groupReportData;
            this.matchInfo = matchInfo;
            this.matchValueList = matchInfo.getDetailDimMatchValues();
            this.dimensionMap = this.matchValueList.stream().map(MatchValue::getDimension).filter(dimension -> dimension.getDimType().isDetailDim()).collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a));
            this.detailFieldMatch = DetailDimControlMatch.getDetailFieldMatchChain();
        }

        public void matchDetail(List<ReportData> reportDataList) {
            ReportData matchedRd = null;
            HashMap<Long, MatchValue> notMatchedMap = new HashMap<Long, MatchValue>(16);
            ArrayList<ReportData> reportDataResult = new ArrayList<ReportData>(reportDataList.size());
            if (reportDataList.stream().allMatch(ReportData::isMainTable)) {
                this.groupReportData.setReportDataList(reportDataList);
                return;
            }
            for (ReportData reportData : reportDataList) {
                if (reportData.isMainTable()) {
                    reportDataResult.add(reportData);
                    continue;
                }
                Map<Long, Object> targetDetailDimValueMap = DimensionInfoHelper.getDetailDimValueMap(reportData, this.dimensionMap.keySet(), false);
                ArrayList<MatchValue> matchedMatchValueList = new ArrayList<MatchValue>(this.matchValueList.size());
                boolean matched = true;
                for (MatchValue matchValue2 : this.matchValueList) {
                    Long dimensionId = matchValue2.getDimension().getId();
                    Object targetVal = targetDetailDimValueMap.get(dimensionId);
                    if (targetVal == null) continue;
                    if (!matchValue2.isMatched() && matchValue2.isNotSkipIfEmpty()) {
                        notMatchedMap.put(dimensionId, matchValue2);
                        continue;
                    }
                    if (this.detailFieldMatch.isMatch(matchValue2, targetVal) && EmptyUtil.isNoEmpty((Object)targetVal)) {
                        matchedMatchValueList.add(matchValue2);
                        continue;
                    }
                    if (!matchValue2.isNotSkipIfEmpty()) continue;
                    matched = false;
                    notMatchedMap.putIfAbsent(dimensionId, matchValue2);
                    break;
                }
                if (!matched) continue;
                reportDataResult.add(reportData);
                matchedMatchValueList.forEach(matchValue -> this.groupReportData.addDetailMatchValue((MatchValue)matchValue, reportData));
                if (matchedRd != null) continue;
                matchedRd = reportData;
            }
            if (matchedRd != null) {
                this.groupReportData.setReportDataList(reportDataResult);
                return;
            }
            MatchValue matchValue3 = (MatchValue)notMatchedMap.values().iterator().next();
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u3010%1$s\u3011\u4f53\u7cfb\u3010%2$s\u3011\u4f7f\u7528\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u3010%3$s\u3011\u5339\u914d\u4e0d\u5230\u660e\u7ec6\u7ef4\u5ea6\u3010%4$s\u3011", (String)"DetailDimControlMatch_0", (String)"tmc-fpm-business", (Object[])new Object[0]), this.matchInfo.getBillBizInfo().getBillNo(), this.matchInfo.getFundPlanSystem().getName(), this.matchInfo.getMatchRule().getNumber(), matchValue3.getDimension().getName());
            MatchException matchException = new MatchException(this.matchInfo, errorMsg);
            this.groupReportData.setMatchException(matchException);
        }
    }
}

