/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.controlmatch.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchValue;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.service.match.controlmatch.impl.AbstractSingleGroupControlMatch;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class OptionEmptySkipDimControlMatch
extends AbstractSingleGroupControlMatch {
    @Override
    protected GroupReportData doMatch(MatchInfo matchInfo, GroupReportData groupReportData) {
        List<MatchValue> matchValueList = matchInfo.getOptionalDimMatchValues().stream().filter(MatchValue::isSkipIfEmpty).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(matchValueList)) {
            return groupReportData;
        }
        AbstractSingleGroupControlMatch.DimMatch dimMatch = new AbstractSingleGroupControlMatch.DimMatch(this, matchInfo, groupReportData);
        matchValueList.forEach(dimMatch::matchDim);
        GroupReportData result = dimMatch.getResult();
        return result;
    }

    @Override
    protected void processIfNotMatch(AbstractSingleGroupControlMatch.DimMatch dimMatch, MatchValue matchValue) {
        GroupReportData groupReportData = dimMatch.getGroupReportData();
        List<ReportData> reportDataList = groupReportData.getReportDataList();
        GroupReportData result = dimMatch.getResult();
        if (EmptyUtil.isEmpty(result.getReportDataList())) {
            result.setReportDataList(reportDataList);
        }
        result.setOptionalReportDataList(groupReportData.getOptionalReportDataList());
        if (!matchValue.isMatched()) {
            Dimension dimension = matchValue.getDimension();
            List<DimMember> allDimMemberList = dimension.getAllDimMemberList();
            DimensionInfoBean copy = groupReportData.getDimensionInfoBean().copy();
            for (DimMember dimMember : allDimMemberList) {
                copy.replaceValueIfContains(dimension.getId(), (Object)dimMember.getId());
                QueryIndexInfo<Long, ReportData> queryIndexInfo = groupReportData.getQueryIndexInfo(dimMatch.getMatchInfo().getFundPlanSystem());
                ReportData one = queryIndexInfo.findOne(copy);
                if (!EmptyUtil.isNoEmpty((Object)one)) continue;
                super.processIfNotMatch(dimMatch, matchValue);
                return;
            }
        }
        Map<Long, List<ReportData>> reportDataGroupReportId = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        for (Map.Entry<Long, List<ReportData>> entry : reportDataGroupReportId.entrySet()) {
            List<ReportData> dataList = entry.getValue();
            if (EmptyUtil.isEmpty(dataList)) continue;
            ReportData reportData = dataList.get(0);
            List<TemplateDim> dimList = reportData.getDimList();
            for (int i = 0; i < dimList.size(); ++i) {
                Object val;
                if (!Objects.equals(dimList.get(i).getDimensionId(), matchValue.getDimension().getId()) || !EmptyUtil.isNoEmpty((Object)(val = reportData.getDimValList().get(i)))) continue;
                super.processIfNotMatch(dimMatch, matchValue);
                return;
            }
        }
        result.getDimensionInfoBean().removeDimensionInfo(matchValue.getDimension().getId());
    }

    private void addNotMatchOptionalDimReportData(AbstractSingleGroupControlMatch.DimMatch dimMatch, ReportData reportData) {
        GroupReportData result = dimMatch.getResult();
        GroupReportData groupReportData = dimMatch.getGroupReportData();
        if (Objects.isNull(result.getReportData()) && Objects.nonNull(groupReportData.getReportData())) {
            result.setReportData(groupReportData.getReportData());
        }
        result.addReportData(reportData);
    }
}

