/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.controlmatch.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchResultInfo;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.match.controlmatch.impl.AbstractControlMatch;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import org.apache.commons.collections.CollectionUtils;

public class ReportOrgAndPeriodCheckControlMatch
extends AbstractControlMatch {
    private AbstractControlMatch controlMatch;
    private IReportRepository reportRepository;

    public ReportOrgAndPeriodCheckControlMatch(AbstractControlMatch controlMatch) {
        this.controlMatch = controlMatch;
        this.reportRepository = new ReportRepository();
    }

    @Override
    MatchResultInfo doMatch(MatchInfo matchInfo, List<GroupReportData> groupReportDataList) {
        MatchResultInfo matchResultInfo = this.controlMatch.doMatch(matchInfo, groupReportDataList);
        if (!matchResultInfo.hasException()) {
            return matchResultInfo;
        }
        QFilter qFilter = new QFilter("reportorg", "=", (Object)matchInfo.getReportOrgId()).and("reportperiod", "in", matchInfo.getPeriodMemIds()).and("planstatus", "=", (Object)ReportPlanStatusEnum.EFFECTIVE.getValue());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_report", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
            return matchResultInfo;
        }
        List reportIds = query.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List<Report> reports = this.reportRepository.loadSimpleReport(Collections.singleton(reportIds.get(0)), t -> t.setNeedTemplate(true));
        if (CollectionUtils.isEmpty(reports)) {
            return matchResultInfo;
        }
        Report report = reports.get(0);
        Dimension currencyDim = matchInfo.getDimensionByType(DimensionType.CURRENCY);
        TemplateDim dimension = report.getTemplate().getAllTemplateDim().stream().filter(templateDim -> Objects.equals(templateDim.getDimensionId(), currencyDim.getId())).findFirst().get();
        boolean match = dimension.getMemberScope().contains(matchInfo.getCurrencyId());
        Dimension notMatchDimension = match ? matchInfo.getDimensionByType(DimensionType.SUBJECTS) : currencyDim;
        MatchException matchException = new MatchException(matchInfo, notMatchDimension);
        logger.error(matchException.getErrorMsg(), (Throwable)((Object)matchException));
        matchResultInfo.setMatchException(matchException);
        return matchResultInfo;
    }
}

