/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.controlmatch.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchResultInfo;
import kd.tmc.fpm.business.mvc.service.match.controlmatch.impl.AbstractControlMatch;

public class ReportTypeHasDetailPeriodFillBackControlMatch
extends AbstractControlMatch {
    private AbstractControlMatch controlMatch;

    public ReportTypeHasDetailPeriodFillBackControlMatch(AbstractControlMatch controlMatch) {
        this.controlMatch = controlMatch;
    }

    @Override
    MatchResultInfo doMatch(MatchInfo matchInfo, List<GroupReportData> groupReportDataList) {
        MatchResultInfo matchResultInfo = this.controlMatch.doMatch(matchInfo, groupReportDataList);
        if (matchResultInfo.hasException()) {
            return matchResultInfo;
        }
        List<GroupReportData> groupReportDataListResult = matchResultInfo.getGroupReportDataList();
        FundPlanSystem fundPlanSystem = matchInfo.getFundPlanSystem();
        Dimension periodDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        Map periodMemberMap = periodDim.getAllDimMemberList().stream().map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        Map reportPeriodTypeMap = fundPlanSystem.getReportTypeList().stream().collect(Collectors.toMap(ReportPeriodType::getReportPeriodId, Function.identity(), (a, b) -> a));
        for (GroupReportData groupReportData : groupReportDataListResult) {
            if (groupReportData.hasException()) continue;
            Long reportPeriodId = groupReportData.getReportPeriodId();
            PeriodMember periodMember = (PeriodMember)periodMemberMap.get(reportPeriodId);
            Long periodTypeId = periodMember.getPeriodTypeId();
            ReportPeriodType reportPeriodType = (ReportPeriodType)reportPeriodTypeMap.get(periodTypeId);
            groupReportData.setHasDetailPeriod(Objects.nonNull((Object)reportPeriodType.getDetailPeriodType()));
        }
        return matchResultInfo;
    }
}

