/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.controlmatch.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.match.controlmatch.impl.AbstractSingleDecorationGroupControlMatch;
import kd.tmc.fpm.business.mvc.service.match.controlmatch.impl.AbstractSingleGroupControlMatch;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class SubjectNotMatchControlMatch
extends AbstractSingleDecorationGroupControlMatch {
    public SubjectNotMatchControlMatch(AbstractSingleGroupControlMatch abstractSingleGroupControlMatch) {
        super(abstractSingleGroupControlMatch);
    }

    @Override
    protected GroupReportData doMatch(MatchInfo matchInfo, GroupReportData groupReportData) {
        GroupReportData groupReportDataResult = super.doMatch(matchInfo, groupReportData);
        if (!groupReportDataResult.hasException()) {
            return groupReportDataResult;
        }
        return this.doMatchParentAndBrother(matchInfo, groupReportData, groupReportDataResult);
    }

    private GroupReportData doMatchParentAndBrother(MatchInfo matchInfo, GroupReportData groupReportData, GroupReportData groupReportDataResult) {
        FundPlanSystem fundPlanSystem = matchInfo.getFundPlanSystem();
        Long subjectId = matchInfo.getSubjectId();
        Dimension subjectDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        Map accountMemberMap = subjectDim.getAllDimMemberList().stream().map(AccountMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        AccountMember accountMember = (AccountMember)accountMemberMap.get(subjectId);
        DimMember parent = accountMember.getParent();
        if (Objects.isNull(parent)) {
            logger.warn("\u4e1a\u52a1\u5355\u636e\uff1a{}\uff0c\u4f53\u7cfb\uff1a{}\uff0c\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\uff1a{}\uff0c\u5339\u914d\u4e0d\u5230\u5f53\u524d\u8ba1\u5212\u79d1\u76ee\uff1a{}\uff0c\u4e14\u5f53\u524d\u79d1\u76ee\u6ca1\u6709\u7236\u7ea7\u79d1\u76ee", new Object[]{fundPlanSystem.getName(), matchInfo.getMatchRule().getNumber(), accountMember.getName()});
            return groupReportDataResult;
        }
        List brotherIds = parent.getChildren().stream().filter(c -> !Objects.equals(c.getId(), subjectId)).map(DimMember::getId).distinct().collect(Collectors.toList());
        GroupReportData copy = groupReportData.copy();
        QueryIndexInfo<Long, ReportData> queryIndexInfo = groupReportData.getQueryIndexInfo(fundPlanSystem);
        DimensionInfoBean dimensionInfoBean = copy.getDimensionInfoBean();
        for (Long brotherId : brotherIds) {
            dimensionInfoBean.replaceValueIfContains(subjectDim.getId(), (Object)brotherId);
            ReportData one = queryIndexInfo.findOne(dimensionInfoBean);
            if (!EmptyUtil.isNoEmpty((Object)one)) continue;
            logger.warn("\u4e1a\u52a1\u5355\u636e\uff1a{}\uff0c\u4f53\u7cfb\uff1a{}\uff0c\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\uff1a{}\uff0c\u5339\u914d\u4e0d\u5230\u5f53\u524d\u8ba1\u5212\u79d1\u76ee\uff1a{}\uff0c\u4f46\u5339\u914d\u5230\u4e86\u5f53\u524d\u8ba1\u5212\u79d1\u76ee\u7684\u5144\u5f1f\u79d1\u76ee\uff1a{}\uff0c\u6309\u539f\u903b\u8f91\u5904\u7406\u3002", new Object[]{fundPlanSystem.getName(), matchInfo.getMatchRule().getNumber(), accountMember.getName(), ((AccountMember)accountMemberMap.get(brotherId)).getName()});
            return groupReportDataResult;
        }
        dimensionInfoBean.replaceValueIfContains(subjectDim.getId(), (Object)parent.getId());
        List<ReportData> list = queryIndexInfo.findList(dimensionInfoBean);
        if (EmptyUtil.isEmpty(list)) {
            logger.warn("\u4e1a\u52a1\u5355\u636e\uff1a{}\uff0c\u4f53\u7cfb\uff1a{}\uff0c\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\uff1a{}\uff0c\u5339\u914d\u4e0d\u5230\u5f53\u524d\u8ba1\u5212\u79d1\u76ee\uff1a{}\uff0c\u4e5f\u5339\u914d\u4e0d\u5230\u5f53\u524d\u8ba1\u5212\u79d1\u76ee\u7684\u7236\u7ea7\u79d1\u76ee\uff1a{}\uff0c\u6309\u539f\u903b\u8f91\u5904\u7406\u3002", new Object[]{matchInfo.getBillBizInfo().getBillNo(), fundPlanSystem.getName(), matchInfo.getMatchRule().getNumber(), accountMember.getName(), parent.getName()});
            return groupReportDataResult;
        }
        logger.warn("\u4e1a\u52a1\u5355\u636e\uff1a{}\uff0c\u4f53\u7cfb\uff1a{}\uff0c\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\uff1a{}\uff0c\u5339\u914d\u4e0d\u5230\u5f53\u524d\u8ba1\u5212\u79d1\u76ee\uff1a{}\uff0c\u4f46\u5339\u914d\u5230\u5f53\u524d\u8ba1\u5212\u79d1\u76ee\u7684\u7236\u7ea7\u79d1\u76ee\uff1a{}\uff0c\u4f7f\u7528\u7236\u7ea7\u79d1\u76ee\u6570\u636e\u505a\u63a7\u5236\u3002", new Object[]{matchInfo.getBillBizInfo().getBillNo(), fundPlanSystem.getName(), matchInfo.getMatchRule().getNumber(), accountMember.getName(), parent.getName()});
        copy.setReportDataList(list);
        copy.setMatchException(null);
        return copy;
    }
}

