/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.generate.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchResult;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.match.generate.impl.AbstractMatchResultGenerator;

public class AbstractDecorationMatchResultGenerator
extends AbstractMatchResultGenerator {
    private AbstractDecorationMatchResultGenerator matchResultGenerator;

    public AbstractDecorationMatchResultGenerator(AbstractDecorationMatchResultGenerator matchResultGenerator) {
        this.matchResultGenerator = matchResultGenerator;
    }

    public AbstractDecorationMatchResultGenerator() {
    }

    @Override
    List<MatchResult> doGenerate(MatchInfo matchInfo, Map<Long, List<GroupReportData>> reportPeriodGroupReportDataMap) {
        if (Objects.nonNull(this.matchResultGenerator)) {
            return this.matchResultGenerator.doGenerate(matchInfo, reportPeriodGroupReportDataMap);
        }
        List<MatchResult> matchResultList = this.getMatchResultList(matchInfo, reportPeriodGroupReportDataMap);
        return matchResultList;
    }

    protected List<MatchResult> getMatchResultList(MatchInfo matchInfo, Map<Long, List<GroupReportData>> reportPeriodGroupReportDataMap) {
        ArrayList<MatchResult> matchResultList = new ArrayList<MatchResult>(8);
        for (Map.Entry<Long, List<GroupReportData>> entry : reportPeriodGroupReportDataMap.entrySet()) {
            MatchResult matchResult = new MatchResult();
            matchResult.setReportPeriod(entry.getKey());
            matchResult.setUniqueKey(matchInfo.getUniqueId());
            matchResult.setMatchRule(matchInfo.getMatchRule());
            matchResult.setBillBizInfo(matchInfo.getBillBizInfo());
            List<GroupReportData> groupReportDataList = entry.getValue();
            for (GroupReportData groupReportData : groupReportDataList) {
                if (groupReportData.hasException()) {
                    matchResult.setMatchException(groupReportData.getMatchException());
                    break;
                }
                ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(groupReportData.getReportDataList());
                if (EmptyUtil.isEmpty(reportDataList)) continue;
                ReportData reportData = groupReportData.getReportData();
                matchResult.addMatchedReportData(reportData);
                reportDataList.remove(reportData);
                matchResult.addSameDimReportDataList(reportDataList);
                groupReportData.getOptionalReportDataList().forEach(matchResult::addOptionalReportData);
            }
            matchResultList.add(matchResult);
        }
        return matchResultList;
    }
}

