/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.generate.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchResult;
import kd.tmc.fpm.business.domain.model.match.MatchResultInfo;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.business.mvc.service.match.generate.IMatchResultGenerator;

public abstract class AbstractMatchResultGenerator
implements IMatchResultGenerator {
    protected static final Log logger = LogFactory.getLog(AbstractMatchResultGenerator.class);

    @Override
    public List<MatchResult> generate(MatchInfo matchInfo, MatchResultInfo matchResultInfo) {
        if (matchResultInfo.hasException()) {
            MatchResult matchResult = new MatchResult();
            matchResult.setUniqueKey(matchInfo.getUniqueId());
            matchResult.setMatchRule(matchInfo.getMatchRule());
            matchResult.setBillBizInfo(matchInfo.getBillBizInfo());
            MatchException matchException = matchResultInfo.getMatchException();
            matchResult.setMatchException(matchException);
            return Collections.singletonList(matchResult);
        }
        List<GroupReportData> groupReportDataList = matchResultInfo.getGroupReportDataList();
        if (EmptyUtil.isEmpty(groupReportDataList)) {
            return Collections.emptyList();
        }
        Map<Long, List<GroupReportData>> reportPeriodGroupReportDataMap = groupReportDataList.stream().collect(Collectors.groupingBy(GroupReportData::getReportPeriodId));
        return this.doGenerate(matchInfo, reportPeriodGroupReportDataMap);
    }

    abstract List<MatchResult> doGenerate(MatchInfo var1, Map<Long, List<GroupReportData>> var2);
}

