/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.service.match.query.impl.AbstractReportDataQueryStrategy;

public class RollReportDataFilterReportDataQueryStrategy
extends AbstractReportDataQueryStrategy {
    public RollReportDataFilterReportDataQueryStrategy(AbstractReportDataQueryStrategy abstractReportDataQueryStrategy) {
        super(abstractReportDataQueryStrategy);
    }

    @Override
    public List<ReportData> getMaybeMatchReportData(List<MatchInfo> matchInfoList) {
        List<ReportData> maybeMatchReportData = super.getMaybeMatchReportData(matchInfoList);
        ArrayList<ReportData> realReportDataList = new ArrayList<ReportData>(maybeMatchReportData.size());
        Map periodMemberMap = matchInfoList.stream().map(MatchInfo::getFundPlanSystem).filter(Objects::nonNull).map(system -> system.getMainDimensionByDimType(DimensionType.PERIOD)).filter(Objects::nonNull).map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        for (ReportData reportData : maybeMatchReportData) {
            int periodIndex = this.getPeriodIndex(reportData);
            if (periodIndex == -1) continue;
            Long periodMemberId = (Long)reportData.getDimValList().get(periodIndex);
            PeriodMember currentPeriodMember = (PeriodMember)periodMemberMap.get(periodMemberId);
            PeriodMember currentReportPeriod = (PeriodMember)periodMemberMap.get(reportData.getReportPeriodId());
            Date startDate = currentPeriodMember.getStartDate();
            Date endDate = currentPeriodMember.getEndDate();
            Date reportStartDate = currentReportPeriod.getStartDate();
            Date reportEndDate = currentReportPeriod.getEndDate();
            if (!startDate.after(reportStartDate) && startDate.compareTo(reportStartDate) != 0 || !endDate.before(reportEndDate) && endDate.compareTo(reportEndDate) != 0) continue;
            realReportDataList.add(reportData);
        }
        return realReportDataList;
    }

    private int getPeriodIndex(ReportData reportData) {
        List<TemplateDim> dimList = reportData.getDimList();
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = dimList.get(i);
            if (!templateDim.getDimType().isPeriodDim()) continue;
            return i;
        }
        return -1;
    }
}

