/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.strategy.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchParam;
import kd.tmc.fpm.business.mvc.service.match.strategy.IControlMatchStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.impl.AbstractControlMatchStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.impl.PeriodFilterDisableReportTypeControlMatchStrategy;
import kd.tmc.fpm.business.utils.ListHelper;

public class InputReportTypeFilterControlMatchStrategy
extends AbstractControlMatchStrategy {
    private Set<Long> reportTypeIds;

    public InputReportTypeFilterControlMatchStrategy(IControlMatchStrategy controlMatchStrategy, Long ... reportTypeIds) {
        super(new PeriodFilterDisableReportTypeControlMatchStrategy(controlMatchStrategy));
        this.reportTypeIds = ListHelper.asSet(reportTypeIds);
    }

    @Override
    public List<MatchInfo> getMatchInfoList(List<MatchParam> matchParamList) {
        List<MatchInfo> matchInfoList = super.getMatchInfoList(matchParamList);
        if (EmptyUtil.isEmpty(this.reportTypeIds)) {
            return this.splitWithReportType(matchInfoList);
        }
        Map periodMemberMap = matchInfoList.stream().map(MatchInfo::getFundPlanSystem).map(system -> system.getMainDimensionByDimType(DimensionType.PERIOD)).map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        for (MatchInfo matchInfo : matchInfoList) {
            matchInfo.getPeriodMemIds().removeIf(pid -> !this.reportTypeIds.contains(((PeriodMember)periodMemberMap.get(pid)).getPeriodTypeId()));
        }
        return this.splitWithReportType(matchInfoList);
    }
}

