/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.strategy.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchParam;
import kd.tmc.fpm.business.helper.ReportPeriodHelper;
import kd.tmc.fpm.business.mvc.service.match.strategy.IControlMatchStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.impl.AbstractControlMatchStrategy;

public class PeriodFilterDisableReportTypeControlMatchStrategy
extends AbstractControlMatchStrategy {
    public PeriodFilterDisableReportTypeControlMatchStrategy(IControlMatchStrategy controlMatchStrategy) {
        super(controlMatchStrategy);
    }

    @Override
    public List<MatchInfo> getMatchInfoList(List<MatchParam> matchParamList) {
        List<MatchInfo> matchInfoList = super.getMatchInfoList(matchParamList);
        HashMap<Long, Map> systemEnableReportTypeMap = new HashMap<Long, Map>(16);
        Map periodMemberMap = matchInfoList.stream().map(MatchInfo::getFundPlanSystem).map(system -> system.getMainDimensionByDimType(DimensionType.PERIOD)).map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        for (MatchInfo matchInfo : matchInfoList) {
            FundPlanSystem fundPlanSystem = matchInfo.getFundPlanSystem();
            Set<Long> periodMemIds = matchInfo.getPeriodMemIds();
            if (EmptyUtil.isEmpty(periodMemIds)) continue;
            Map reportTypeMap = systemEnableReportTypeMap.computeIfAbsent(fundPlanSystem.getId(), k -> fundPlanSystem.getReportTypeList().stream().filter(ReportPeriodType::isEnable).collect(Collectors.toMap(ReportPeriodType::getReportPeriodId, Function.identity(), (a, b) -> a)));
            periodMemIds.removeIf(id -> {
                PeriodMember periodMember = (PeriodMember)periodMemberMap.get(id);
                if (!reportTypeMap.containsKey(periodMember.getPeriodTypeId())) {
                    return true;
                }
                ReportPeriodType reportPeriodType = (ReportPeriodType)reportTypeMap.get(periodMember.getPeriodTypeId());
                return !ReportPeriodHelper.periodTypeEqual(reportPeriodType, periodMember.getPeriodType());
            });
        }
        return matchInfoList;
    }
}

