/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.strategy.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchParam;
import kd.tmc.fpm.business.helper.ReportPeriodHelper;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.match.strategy.IControlMatchStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.impl.AbstractControlMatchStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.impl.PeriodFilterDisableReportTypeControlMatchStrategy;
import org.apache.commons.collections4.MapUtils;

public class ReportTypeFilterControlMatchStrategy
extends AbstractControlMatchStrategy {
    private ControlContext controlContext;

    public ReportTypeFilterControlMatchStrategy(IControlMatchStrategy controlMatchStrategy, ControlContext controlContext) {
        super(new PeriodFilterDisableReportTypeControlMatchStrategy(controlMatchStrategy));
        this.controlContext = controlContext;
    }

    @Override
    public List<MatchInfo> getMatchInfoList(List<MatchParam> matchParamList) {
        List<MatchInfo> matchInfoList = super.getMatchInfoList(matchParamList);
        if (!this.controlContext.getPlanExecuteOpType().isOccupy()) {
            return matchInfoList.stream().map(MatchInfo::splitWithReportType).flatMap(Collection::stream).collect(Collectors.toList());
        }
        Map periodMemberMap = matchInfoList.stream().map(MatchInfo::getFundPlanSystem).map(system -> system.getMainDimensionByDimType(DimensionType.PERIOD)).map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        for (MatchInfo matchInfo : matchInfoList) {
            List<Long> controlledReportTypeIds;
            FundPlanSystem fundPlanSystem = matchInfo.getFundPlanSystem();
            Long systemId = fundPlanSystem.getId();
            ControlTime controlTime = this.controlContext.getControlTime(systemId);
            if (Objects.isNull(controlTime) || EmptyUtil.isEmpty(controlledReportTypeIds = controlTime.getControledReportTypeIds())) continue;
            Map reportPeriodTypeMap = fundPlanSystem.getReportTypeList().stream().filter(reportPeriodType -> controlledReportTypeIds.contains(reportPeriodType.getReportPeriodId())).filter(ReportPeriodType::isEnable).collect(Collectors.toMap(ReportPeriodType::getReportPeriodId, Function.identity(), (a, b) -> a));
            if (MapUtils.isEmpty(reportPeriodTypeMap)) {
                return Collections.emptyList();
            }
            Set<Long> periodMemIds = matchInfo.getPeriodMemIds().stream().map(periodMemberMap::get).filter(periodMember -> reportPeriodTypeMap.containsKey(periodMember.getPeriodTypeId())).filter(periodMember -> {
                ReportPeriodType reportPeriodType = (ReportPeriodType)reportPeriodTypeMap.get(periodMember.getPeriodTypeId());
                return ReportPeriodHelper.periodTypeEqual(reportPeriodType, periodMember.getPeriodType());
            }).map(DimMember::getId).collect(Collectors.toSet());
            matchInfo.setPeriodMemIds(periodMemIds);
        }
        return matchInfoList.stream().map(MatchInfo::splitWithReportType).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

