/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.strategy.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.DimValueListInfo;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.mvc.service.match.strategy.IMatchMemberStrategy;

public class SubjectMatchMemberStrategy
implements IMatchMemberStrategy {
    @Override
    public void process(MatchInfo matchInfo, DimValueListInfo dimValueListInfo) {
        Dimension subjectDim = matchInfo.getDimensionByType(DimensionType.SUBJECTS);
        if (dimValueListInfo.contains(subjectDim.getId(), matchInfo.getSubjectId())) {
            return;
        }
        Map dimMemberMap = subjectDim.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        DimMember dimMember = (DimMember)dimMemberMap.get(matchInfo.getSubjectId());
        dimValueListInfo.addDimensionValue(subjectDim, matchInfo.getSubjectId());
        DimMember parent = dimMember.getParent();
        if (Objects.isNull(parent)) {
            return;
        }
        List<DimMember> children = parent.getChildren();
        if (children.size() == 1) {
            return;
        }
        List<Object> brotherIds = children.stream().map(DimMember::getId).filter(subjectId -> !Objects.equals(subjectId, matchInfo.getSubjectId())).collect(Collectors.toList());
        brotherIds.add(parent.getId());
        dimValueListInfo.addDimensionListValue(subjectDim, brotherIds);
    }
}

