/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.strategy.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchParam;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.service.match.query.IReportDataQueryStrategy;
import kd.tmc.fpm.business.mvc.service.match.query.impl.DefaultReportDataQueryStrategy;
import kd.tmc.fpm.business.mvc.service.match.query.impl.RollReportDataFilterReportDataQueryStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.IControlMatchStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.impl.AbstractControlMatchStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.impl.OptionalCommMatchMemberStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.impl.PeriodMatchMemberStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.impl.ReportOrgMatchMemberStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.impl.SubjectMatchMemberStrategy;
import kd.tmc.fpm.business.utils.CommonUtils;

public class SumReportControlMatchStrategy
extends AbstractControlMatchStrategy {
    private IReportDataQueryStrategy reportDataQueryStrategy = new RollReportDataFilterReportDataQueryStrategy(new DefaultReportDataQueryStrategy().addMatchMemberStrategy(new ReportOrgMatchMemberStrategy(true)).addMatchMemberStrategy(new PeriodMatchMemberStrategy()).addMatchMemberStrategy(new SubjectMatchMemberStrategy()).addMatchMemberStrategy(new OptionalCommMatchMemberStrategy()).setSearchHook(t -> t.setReportPlanType(ReportPlanType.SUMPLAN)));

    public SumReportControlMatchStrategy(IControlMatchStrategy controlMatchStrategy) {
        super(controlMatchStrategy);
    }

    @Override
    public List<MatchInfo> getMatchInfoList(List<MatchParam> matchParamList) {
        List<MatchInfo> matchInfoList = super.getMatchInfoList(matchParamList);
        SumOrgFind sumOrgFind = new SumOrgFind(matchInfoList);
        for (MatchInfo matchInfo : matchInfoList) {
            Set<Long> allSumOrg = sumOrgFind.findAllSumOrg(matchInfo);
            if (EmptyUtil.isEmpty(allSumOrg)) continue;
            allSumOrg.forEach(matchInfo::addSumReportOrgId);
        }
        return matchInfoList;
    }

    @Override
    public List<GroupReportData> getGroupReportDataList(List<MatchInfo> matchInfoList) {
        List<GroupReportData> groupReportDataList = super.getGroupReportDataList(matchInfoList);
        if (EmptyUtil.isEmpty(groupReportDataList)) {
            return groupReportDataList;
        }
        List reportDataList = groupReportDataList.stream().map(GroupReportData::getReportDataList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(reportDataList)) {
            return groupReportDataList;
        }
        Set reportOrgIds = reportDataList.stream().map(rd -> {
            List<TemplateDim> dimList = rd.getDimList();
            for (int i = 0; i < dimList.size(); ++i) {
                if (!dimList.get(i).getDimType().isOrgDim()) continue;
                return rd.getDimValList().get(i);
            }
            return 0L;
        }).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        for (MatchInfo matchInfo : matchInfoList) {
            if (reportOrgIds.contains(matchInfo.getReportOrgId())) continue;
            matchInfo.clearSumReportOrgIds();
        }
        List<ReportData> maybeMatchReportData = this.reportDataQueryStrategy.getMaybeMatchReportData(matchInfoList);
        maybeMatchReportData.addAll(reportDataList);
        GroupReportData copy = groupReportDataList.get(0).copy();
        copy.setReportDataList(CommonUtils.getDistinctList(maybeMatchReportData, ReportData::getId));
        return Collections.singletonList(copy);
    }

    static class SumOrgFind {
        private Map<Long, Set<Long>> sumOrgCache;
        private List<MatchInfo> matchInfoList;
        private Map<Long, Map<Long, Dimension>> systemDimensionMap;
        private Map<Long, DimMember> memberMap;

        public SumOrgFind(List<MatchInfo> matchInfoList) {
            this.matchInfoList = matchInfoList;
            this.systemDimensionMap = new HashMap<Long, Map<Long, Dimension>>(matchInfoList.size());
            this.memberMap = new HashMap<Long, DimMember>(512);
            this.sumOrgCache = new HashMap<Long, Set<Long>>(matchInfoList.size());
            this.init();
        }

        public Set<Long> findAllSumOrg(MatchInfo matchInfo) {
            HashSet<Long> parentsId = new HashSet<Long>(4);
            Long reportOrgId = matchInfo.getReportOrgId();
            if (this.sumOrgCache.containsKey(reportOrgId)) {
                return this.sumOrgCache.get(reportOrgId);
            }
            DimMember orgMember = this.memberMap.get(reportOrgId);
            this.getAllParents(parentsId, orgMember, false);
            this.sumOrgCache.putIfAbsent(reportOrgId, parentsId);
            return parentsId;
        }

        private void getAllParents(Set<Long> parentsId, DimMember dimMember, boolean hasSelf) {
            if (EmptyUtil.isEmpty((Object)dimMember)) {
                return;
            }
            if (hasSelf) {
                parentsId.add(dimMember.getId());
            }
            DimMember parent = dimMember.getParent();
            this.getAllParents(parentsId, parent, true);
        }

        private void init() {
            this.initDimInfo();
        }

        private void initDimInfo() {
            for (MatchInfo matchInfo : this.matchInfoList) {
                FundPlanSystem fundPlanSystem = matchInfo.getFundPlanSystem();
                List<Dimension> dimensionList = fundPlanSystem.getDimList();
                Long systemId = fundPlanSystem.getId();
                if (this.systemDimensionMap.containsKey(systemId) || this.memberMap.containsKey(systemId)) continue;
                for (Dimension dimension : dimensionList) {
                    if (!dimension.getDimType().isOrgDim() && !dimension.getDimType().isPeriodDim()) continue;
                    Long dimensionId = dimension.getId();
                    Map dimensionMap = this.systemDimensionMap.computeIfAbsent(systemId, key -> new HashMap(8));
                    dimensionMap.put(dimensionId, dimension);
                    List<DimMember> memberList = dimension.getAllDimMemberList();
                    for (DimMember dimMember : memberList) {
                        this.memberMap.put(dimMember.getId(), dimMember);
                    }
                }
            }
        }
    }
}

